/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentRecordIndex;
import com.gridnine.xtrip.common.model.finance.PaymentItem;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentIndex;
import com.gridnine.xtrip.common.model.finance.ShipmentIndexData;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorageHelper;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class ShipmentIndexHandler
implements IndexHandler<Shipment, ShipmentIndex> {
    public Class<? extends BaseIndexData<Shipment, ShipmentIndex>> getDataClass() {
        return ShipmentIndexData.class;
    }

    public Class<ShipmentIndex> getIndexClass() {
        return ShipmentIndex.class;
    }

    public Class<Shipment> getEntityType() {
        return Shipment.class;
    }

    public void create(EntityContainer<Shipment> etc, Collection<BaseIndexData<Shipment, ShipmentIndex>> indexes) {
        ShipmentIndexData data = new ShipmentIndexData();
        DataAggregator aggregator = new DataAggregator();
        this.updateData(data, aggregator, etc);
        data.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<Shipment, ShipmentIndex>)data);
    }

    protected void updateData(ShipmentIndexData data, DataAggregator aggregator, EntityContainer<Shipment> etc) {
        Shipment shipment = (Shipment)etc.getEntity();
        data.setAgent(shipment.getAgent());
        data.setCategoryAgent(shipment.getCategoryAgent());
        data.setDate(shipment.getDate());
        data.setNavigationKey(shipment.getUid());
        data.setName(!TextUtil.isBlank((String)shipment.getName()) && shipment.getName().length() > 100 ? shipment.getName().substring(0, 100) + "..." : shipment.getName());
        aggregator.aggregate((Object)shipment.getName());
        StringBuilder costCodeValue = new StringBuilder();
        StringBuilder costCodeLocalValue = new StringBuilder();
        StringBuilder costCodeEnglishValue = new StringBuilder();
        shipment.getCostCodes().forEach(cc -> {
            costCodeValue.append(cc.getCostCodeProperties().getName());
            costCodeValue.append(":");
            costCodeValue.append(TextUtil.nonBlank((String)cc.getValue()) ? cc.getValue() : "?");
            costCodeValue.append(",");
            costCodeLocalValue.append(cc.getCostCodeProperties().getName());
            costCodeLocalValue.append(":");
            costCodeLocalValue.append(TextUtil.nonBlank((String)cc.getLocalValue()) ? cc.getLocalValue() : "?");
            costCodeLocalValue.append(",");
            costCodeEnglishValue.append(cc.getCostCodeProperties().getName());
            costCodeEnglishValue.append(":");
            costCodeEnglishValue.append(TextUtil.nonBlank((String)cc.getEnglishValue()) ? cc.getEnglishValue() : "?");
            costCodeEnglishValue.append(",");
        });
        String localValue = costCodeLocalValue.substring(0, costCodeLocalValue.length() < 1 ? 0 : costCodeLocalValue.length() - 1);
        String englishValue = costCodeEnglishValue.substring(0, costCodeEnglishValue.length() < 1 ? 0 : costCodeEnglishValue.length() - 1);
        Set costCodes = shipment.getCostCodes().stream().map(cc -> cc.getCostCodeProperties().getUid() + ":" + (cc.getValue() == null ? "*" : cc.getValue())).collect(Collectors.toSet());
        data.setCostCodeValue(costCodeValue.substring(0, costCodeValue.length() < 1 ? 0 : costCodeValue.length() - 1));
        data.setCostCodeLocalValue(localValue);
        data.setCostCodeEnglishValue(englishValue);
        data.setCostCodes(costCodes);
        data.setCostCodeProperties((Collection)shipment.getCostCodes().stream().map(CostCode::getCostCodeProperties).map(BaseIdentity::getUid).collect(Collectors.toSet()));
        aggregator.aggregate((Object)costCodeValue.substring(0, costCodeValue.length() < 1 ? 0 : costCodeValue.length() - 1));
        aggregator.aggregate((Object)localValue);
        aggregator.aggregate((Object)englishValue);
        aggregator.aggregate((Iterable)shipment.getCostCodes().stream().map(CostCode::getCostCodeProperties).map(BaseIdentity::getUid).collect(Collectors.toSet()));
        data.setNumber(TextUtil.buildFullNumber((CompositeNumber)shipment));
        data.setSystemNumber(shipment.getNumber());
        data.setCorrection(Boolean.valueOf(shipment.isCorrection()));
        data.setCategories((Collection)shipment.getCategories());
        data.setPayer(shipment.getPayer());
        data.setCustomer(shipment.getCustomer());
        data.setSupplier(shipment.getSupplier());
        data.setContract((EntityReference)shipment.getContract());
        EntityContainer contract = EntityStorage.get().resolve((EntityReference)shipment.getContract());
        if (contract != null) {
            data.setContractAgreementType(((Contract)contract.getEntity()).getAgreementType());
        }
        HashSet<PaymentType> paymentTypes = new HashSet<PaymentType>();
        HashSet<String> productUids = new HashSet<String>();
        EntityStorageContext ctx = LogicalStorageHelper.getEntityStorageContext();
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalVatAmount = BigDecimal.ZERO;
        for (BillingItem billingItem : FinanceDocumentHelper.getBillingItems(shipment.getBillingItems(), ctx)) {
            NestedEntityReference product = billingItem.getProduct();
            if (product != null) {
                productUids.add(product.getNestedEntityUid());
            }
            if (billingItem.getFops() != null) {
                paymentTypes.add(billingItem.getPaymentType());
            }
            if (billingItem.getAmount() == null) continue;
            if (billingItem.getAmount().getTotal() != null) {
                totalAmount = totalAmount.add(billingItem.getAmount().getTotal());
            }
            if (billingItem.getAmount().getVatAmount() == null) continue;
            totalVatAmount = totalVatAmount.add(billingItem.getAmount().getVatAmount());
        }
        data.setPaymentTypes(paymentTypes);
        data.setProductUids(productUids);
        BigDecimal totalPayedAmount = shipment.getPayedAmountCachedValue();
        if (totalPayedAmount == null) {
            totalPayedAmount = BigDecimal.ZERO;
            for (NestedEntityReference item3 : shipment.getPaymentItems()) {
                PaymentItem pi = (PaymentItem)EntityStorageHelper.resolve((NestedEntityReference)item3, (EntityStorageContext)ctx);
                if (pi == null || pi.getAmount() == null || pi.getAmount().getValue() == null) continue;
                totalPayedAmount = totalPayedAmount.add(pi.getAmount().getValue());
            }
        }
        SearchQuery searchQuery = new SearchQuery();
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])((SearchCriterion[])shipment.getFinanceDocuments().stream().map(item -> SearchCriterion.eq((String)"containerUid", (Object)item)).toArray(SearchCriterion[]::new))));
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)FinanceDocumentRecordIndex.Property.includedToDelivery.name(), (Object)Boolean.TRUE));
        searchQuery.setResultMode(ResultMode.COUNT_ONLY);
        int count = EntityStorage.get().search(FinanceDocumentRecordIndex.class, searchQuery).getTotalCount();
        data.setFinanceDocumentsIncludedToDelivery(Boolean.valueOf(shipment.getFinanceDocuments().size() == count));
        data.setTotalAmount(totalAmount);
        data.setTotalVatAmount(totalVatAmount);
        data.setTotalPayedAmount(totalPayedAmount);
        data.setDifferenceAmount(totalAmount.subtract(totalPayedAmount));
        data.setPayed(Boolean.valueOf(shipment.isAmountChecked() || MiscUtil.equals((Object)totalAmount, (Object)totalPayedAmount)));
        data.setCurrency(shipment.getCurrency() != null ? shipment.getCurrency().getCode() : null);
        data.setComments(shipment.getComments());
        for (EntityReference financeDocumentRef2 : shipment.getFinanceDocuments()) {
            EntityContainer ctr = EntityStorageHelper.resolve((EntityReference)financeDocumentRef2, (EntityStorageContext)ctx);
            if (ctr == null || ctr.getEntity() == null || !FinanceDocumentsHelper.isConsolidated((FinanceDocumentType)((FinanceDocument)ctr.getEntity()).getType())) continue;
            data.setConsolidatedFinDoc(financeDocumentRef2);
            break;
        }
        data.setPrepaymentInvoice((Collection)shipment.getPrepaymentFinanceDocuments().stream().filter(financeDocumentRef -> EntityStorageHelper.resolve((EntityReference)financeDocumentRef, (EntityStorageContext)ctx) != null).collect(Collectors.toList()));
        data.setSentToEmail(Boolean.valueOf(shipment.isSentToEmail()));
        aggregator.aggregate((Object)shipment.getAgent());
        aggregator.aggregate((Object)TextUtil.buildFullNumber((CompositeNumber)shipment));
        aggregator.aggregate((Iterable)shipment.getCategories());
        aggregator.aggregate((Object)shipment.getPayer());
        aggregator.aggregate((Object)shipment.getCustomer());
        aggregator.aggregate((Object)shipment.getSupplier());
    }
}

