/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AppliedRule;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ShipmentProductAppliedRules;
import com.gridnine.xtrip.common.model.finance.ShipmentProductAppliedRulesIndex;
import com.gridnine.xtrip.common.model.finance.ShipmentProductAppliedRulesIndexData;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ShipmentProductAppliedRulesIndexHandler
implements IndexHandler<ShipmentProductAppliedRules, ShipmentProductAppliedRulesIndex> {
    public Class<? extends BaseIndexData<ShipmentProductAppliedRules, ShipmentProductAppliedRulesIndex>> getDataClass() {
        return ShipmentProductAppliedRulesIndexData.class;
    }

    public Class<ShipmentProductAppliedRulesIndex> getIndexClass() {
        return ShipmentProductAppliedRulesIndex.class;
    }

    public Class<ShipmentProductAppliedRules> getEntityType() {
        return ShipmentProductAppliedRules.class;
    }

    public void create(EntityContainer<ShipmentProductAppliedRules> etc, Collection<BaseIndexData<ShipmentProductAppliedRules, ShipmentProductAppliedRulesIndex>> indexes) {
        DataAggregator aggregator = new DataAggregator();
        this.updateData(aggregator, etc, indexes);
    }

    protected void updateData(DataAggregator aggregator, EntityContainer<ShipmentProductAppliedRules> etc, Collection<BaseIndexData<ShipmentProductAppliedRules, ShipmentProductAppliedRulesIndex>> indexes) {
        ShipmentProductAppliedRules appliedRules = (ShipmentProductAppliedRules)etc.getEntity();
        String productUid = (String)CollectionUtil.single((Collection)appliedRules.getAppliedRules().stream().map(AppliedRule::getProductUid).collect(Collectors.toSet()));
        BaseProduct product = this.getProductByUid(productUid);
        String shortProductName = null;
        if (product != null) {
            shortProductName = BookingHelper.generateShortProductName((BaseProduct)product);
        }
        for (AppliedRule appliedRule : appliedRules.getAppliedRules()) {
            RuleSettings rule;
            RuleSet ruleSet;
            ShipmentProductAppliedRulesIndexData data = new ShipmentProductAppliedRulesIndexData();
            data.setShipment(appliedRules.getShipment());
            data.setCalculationDate(appliedRule.getCalculationDate());
            data.setProductUid(productUid);
            data.setShortProductName(shortProductName);
            data.setRuleUid(appliedRule.getRuleUid());
            data.setNavigationKey(appliedRule.getUid());
            EntityContainer rulesContainer = EntityStorage.get().resolve(appliedRule.getRulesContainer());
            if (rulesContainer != null && (ruleSet = ((BaseRulesContainer)rulesContainer.getEntity()).getRuleSet()) != null && (rule = (RuleSettings)CollectionUtil.find((Iterable)ruleSet.getRules(), (String)appliedRule.getRuleUid())) != null) {
                if (rule.getTarget() != null) {
                    data.setTarget(rule.getTarget().getId());
                }
                data.setActions((Collection)rule.getResults().stream().map(RuleResult::getAction).filter(Objects::nonNull).map(RuleAction::getId).collect(Collectors.toSet()));
            }
            aggregator.aggregate((Object)appliedRules.getShipment());
            aggregator.aggregate((Object)productUid);
            aggregator.aggregate((Object)shortProductName);
            data.setAggregatedData(aggregator.toString());
            indexes.add((BaseIndexData<ShipmentProductAppliedRules, ShipmentProductAppliedRulesIndex>)data);
        }
    }

    private BaseProduct getProductByUid(String productUid) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"navigationKey", (Object)productUid));
        List searchResult = EntityStorage.get().search(CommonProductIndex.class, query).getData();
        if (searchResult.size() != 0) {
            EntityReference bfRef = ((CommonProductIndex)searchResult.get(0)).getSource();
            EntityContainer bfCtr = EntityStorage.get().resolve(bfRef);
            if (bfCtr != null) {
                return ((BookingFile)bfCtr.getEntity()).getReservations().stream().flatMap(item -> item.getProducts().stream()).filter(item -> item.getUid().equals(productUid)).findFirst().orElse(null);
            }
        }
        return null;
    }
}

