/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.stockcontrol.BlankOrderLogItem;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlank;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlankIndex;
import com.gridnine.xtrip.common.model.stockcontrol.StockBlankIndexData;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class StockBlankIndexHandler
implements IndexHandler<StockBlank, StockBlankIndex> {
    public Class<? extends BaseIndexData<StockBlank, StockBlankIndex>> getDataClass() {
        return StockBlankIndexData.class;
    }

    public Class<StockBlankIndex> getIndexClass() {
        return StockBlankIndex.class;
    }

    public Class<StockBlank> getEntityType() {
        return StockBlank.class;
    }

    public void create(EntityContainer<StockBlank> etc, Collection<BaseIndexData<StockBlank, StockBlankIndex>> indexes) {
        StockBlankIndexData data = new StockBlankIndexData();
        StockBlank entity = (StockBlank)etc.getEntity();
        data.setNumber(entity.getNumber());
        data.setOperationDate(entity.getOperationDate());
        data.setVendorPaymentDate(entity.getVendorPaymentDate());
        data.setRegistrationDate(entity.getRegistrationDate());
        data.setType(entity.getType());
        data.setTicketNumber(entity.getProductNumber());
        ArrayList<String> orders = new ArrayList<String>();
        for (Object order : entity.getOrders()) {
            orders.add(order.getUid());
        }
        data.setOrders(orders);
        data.setUsageStatus(entity.getUsageStatus());
        data.setProductUid(entity.getProductUid());
        data.setBookingFile(entity.getBookingFile());
        data.setControlStatus(entity.getControlStatus());
        data.setSupplier(entity.getSupplier());
        data.setTariffType(entity.getTariffType());
        data.setOwner(entity.getOwner());
        data.setStockHolder(entity.getStockHolder());
        data.setCurrentLocation(entity.getCurrentLocation());
        data.setDestination(entity.getDestination());
        data.setReservationOrder(entity.getReservationOrder());
        data.setReserved(Boolean.valueOf(entity.isReserved()));
        HashSet<EntityReference> locations = new HashSet<EntityReference>();
        for (BlankOrderLogItem log : entity.getOrderLogItems()) {
            locations.add(log.getBlankLocation());
        }
        data.setLocations(locations);
        DataAggregator aggregator = new DataAggregator();
        aggregator.aggregate(entity.getOperationDate());
        aggregator.aggregate((Object)entity.getNumber());
        aggregator.aggregate(entity.getRegistrationDate());
        aggregator.aggregate(entity.getStockHolder() == null ? null : entity.getStockHolder().getUid());
        aggregator.aggregate((Object)entity.getType());
        aggregator.aggregate(orders);
        aggregator.aggregate((Object)entity.getSupplier());
        aggregator.aggregate((Object)entity.getOwner());
        aggregator.aggregate((Object)entity.getStockHolder());
        aggregator.aggregate((Object)entity.getReservationOrder());
        aggregator.aggregate((Object)entity.getCurrentLocation());
        aggregator.aggregate((Object)entity.getDestination());
        data.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<StockBlank, StockBlankIndex>)data);
    }
}

