/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.stockcontrol.OrderItem;
import com.gridnine.xtrip.common.model.stockcontrol.StockOrder;
import com.gridnine.xtrip.common.model.stockcontrol.StockOrderIndex;
import com.gridnine.xtrip.common.model.stockcontrol.StockOrderIndexData;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;

public class StockOrderIndexHandler
implements IndexHandler<StockOrder, StockOrderIndex> {
    public Class<? extends BaseIndexData<StockOrder, StockOrderIndex>> getDataClass() {
        return StockOrderIndexData.class;
    }

    public Class<StockOrderIndex> getIndexClass() {
        return StockOrderIndex.class;
    }

    public Class<StockOrder> getEntityType() {
        return StockOrder.class;
    }

    public void create(EntityContainer<StockOrder> etc, Collection<BaseIndexData<StockOrder, StockOrderIndex>> indexes) {
        StockOrderIndexData data = new StockOrderIndexData();
        StockOrder entity = (StockOrder)etc.getEntity();
        String fullNumber = TextUtil.buildFullNumber((CompositeNumber)entity);
        data.setFullNumber(fullNumber);
        data.setCreated(entity.getCreated());
        HashSet<String> relatedOrders = new HashSet<String>();
        for (EntityReference order : entity.getRelatedOrders()) {
            relatedOrders.add(order.getUid());
        }
        data.setRelatedOrders(relatedOrders);
        data.setType(entity.getType());
        data.setStockHolder(entity.getStockHolder());
        data.setSender(entity.getSender());
        data.setReceiver(entity.getReceiver());
        data.setSupplier(entity.getSupplier());
        int blanksCount = 0;
        LinkedHashSet<String> owners = new LinkedHashSet<String>();
        for (OrderItem item : entity.getItems()) {
            blanksCount = (int)((long)blanksCount + item.getBlanksCount());
            if (item.getOwner() == null) continue;
            owners.add(item.getOwner().toString());
        }
        data.setOwners(owners);
        data.setBlanksCount(blanksCount);
        data.setStatus(entity.getStatus());
        DataAggregator aggregator = new DataAggregator();
        aggregator.aggregate(entity.getCreated());
        aggregator.aggregate((Object)fullNumber);
        aggregator.aggregate((Object)entity.getNumber());
        aggregator.aggregate((Object)entity.getNumberPrefix());
        aggregator.aggregate((Object)entity.getNumberSuffix());
        aggregator.aggregate((Object)entity.getStockHolder());
        aggregator.aggregate((Object)entity.getSender());
        aggregator.aggregate((Object)entity.getReceiver());
        aggregator.aggregate((Object)entity.getSupplier());
        data.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<StockOrder, StockOrderIndex>)data);
    }
}

