/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiHelper;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiProduct;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiProductIndex;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiProductIndexData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class TaxiProductIndexHandler
implements IndexHandler<BookingFile, TaxiProductIndex> {
    public Class<? extends BaseIndexData<BookingFile, TaxiProductIndex>> getDataClass() {
        return TaxiProductIndexData.class;
    }

    public Class<TaxiProductIndex> getIndexClass() {
        return TaxiProductIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, TaxiProductIndex>> indexes) throws Exception {
        BookingFile bookingFile = (BookingFile)etc.getEntity();
        for (Reservation reservation : bookingFile.getReservations()) {
            DataAggregator aggregator = new DataAggregator();
            for (BaseProduct baseProduct : reservation.getProducts()) {
                if (!(baseProduct instanceof TaxiProduct)) continue;
                TaxiProduct product = (TaxiProduct)baseProduct;
                TaxiProductIndexData data = new TaxiProductIndexData();
                data.setAggregator(aggregator);
                this.updateData(data, product);
                data.setAggregatedData(aggregator.toString());
                indexes.add((BaseIndexData<BookingFile, TaxiProductIndex>)data);
                aggregator.reset();
            }
        }
    }

    protected String composeBookingNumber(TaxiProduct product) {
        return TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile());
    }

    protected Organization getOrganization(Reservation reservation) {
        EntityContainer subagencyContainer;
        Organization subagency = null;
        if (reservation.getSubagency() != null && (subagencyContainer = EntityStorage.get().resolve(reservation.getSubagency())) != null) {
            subagency = (Organization)subagencyContainer.getEntity();
        }
        return subagency;
    }

    private void updateData(TaxiProductIndexData data, TaxiProduct product) {
        boolean refund = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        data.setNavigationKey(product.getUid());
        data.setStatus(product.getStatus());
        data.setIssueDate(product.getIssueDate());
        data.setIssueDateTime(product.getIssueDate());
        data.setSystemNumber(product.getSystemNumber());
        data.setCarClass(product.getCarClass());
        data.setSupplier(TaxiHelper.getSupplier((TaxiProduct)product));
        data.setDateEnd(product.getDateEnd());
        data.setDateStart(product.getDateStart());
        data.setFinishDate(product.getFinishDate());
        data.setFinishDateTime(product.getFinishDate());
        data.setCountry(product.getCountry());
        data.setCity(product.getCity());
        data.setSourceAddress(product.getSource());
        data.setDestinationAddress(product.getDestination());
        data.setBlankOwner(product.getBlankOwner());
        EntityReference agency = TaxiHelper.getAgency((TaxiProduct)product);
        data.setAgency(agency);
        EntityReference subAgency = TaxiHelper.getSubagency((TaxiProduct)product);
        data.setSubagency(subAgency);
        data.setAgent(product.getAgent());
        data.setSalesPoint(product.getSalesPoint());
        data.setTicketType(product.getTicketType() != null ? product.getTicketType() : TicketType.OWN);
        data.setBookingNumber(this.composeBookingNumber(product));
        if (product.getEquivalentFare() != null) {
            data.setEquivalentSum(refund ? product.getEquivalentFare().getValue().negate() : product.getEquivalentFare().getValue());
            data.setEquivalentFareCurrency(product.getEquivalentFare().getCurrency());
        }
        data.setTotalPrice(BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.CLIENT).getTotal());
        data.setPenalty(product.getPenalty());
        data.setClientFee(BookingHelper.calculateFee((BaseProduct)product, (ContractType)ContractType.CLIENT));
        data.setSupplierFee(BookingHelper.calculateFee((BaseProduct)product, (ContractType)ContractType.SUBAGENCY));
        data.setClientCommission(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)TaxiHelper.getUnmodifiableCommissions((TaxiProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
        data.setSupplierCommission(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)TaxiHelper.getUnmodifiableCommissions((TaxiProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
        List travellersNames = product.getTravellers().stream().map(Traveller::getName).collect(Collectors.toList());
        data.setTravellersNames(travellersNames);
        data.setComments(product.getComments());
        boolean inFinanceDocuments = IndexBuilderHelper.isInFinanceDocuments((BaseProduct)product);
        data.setInFinanceDocuments(Boolean.valueOf(inFinanceDocuments));
        BigDecimal clientFOPAmount = BigDecimal.ZERO;
        boolean hasClientDebt = false;
        for (GeneralProductFop fop : TaxiHelper.getClientFops((TaxiProduct)product)) {
            if (fop.getEquivalentAmount() != null) {
                clientFOPAmount = clientFOPAmount.add(fop.getEquivalentAmount());
            }
            if (fop.getOperationDate() != null) continue;
            hasClientDebt = true;
        }
        if (refund) {
            clientFOPAmount = clientFOPAmount.negate();
        }
        data.setClientFopAmount(clientFOPAmount);
        data.setHasClientDebt(Boolean.valueOf(hasClientDebt));
        data.setChecked(Boolean.valueOf(product.isChecked()));
        data.setCompleted(Boolean.valueOf(product.isCompleted()));
        data.setHasOtherErrors(Boolean.valueOf(false));
        data.setHasErrors(Boolean.valueOf(false));
        for (ValidationMessage message : product.getValidationMessages()) {
            if (message.getSeverity() == ValidationMessageSeverity.USER_ERROR) {
                data.setHasErrors(Boolean.valueOf(true));
            }
            if (message.getSeverity() != ValidationMessageSeverity.ERROR) continue;
            data.setHasErrors(Boolean.valueOf(true));
            if (message.getCategory() != ValidationMessageCategory.OTHER) continue;
            data.setHasOtherErrors(Boolean.valueOf(true));
        }
        if (product.getReservation() != null) {
            data.setRecordLocators(IndexBuilderHelper.getRecordLocators(product.getReservation()));
            data.setDisplayedRecordLocator(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation()));
            data.setGdsNames(IndexBuilderHelper.getGdsNames(product.getReservation()));
            if (product.getReservation().getBookingFile() != null) {
                data.setClient(product.getReservation().getBookingFile().getCustomerProfile());
                String notes = product.getReservation().getBookingFile().getNotes();
                data.setHasNotes(Boolean.valueOf(TextUtil.nonBlank((String)notes)));
            }
        }
    }
}

