/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.TchDirectContract;
import com.gridnine.xtrip.common.model.profile.TchDirectContractIndex;
import com.gridnine.xtrip.common.model.profile.TchDirectContractIndexData;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;

public class TchDirectContractIndexHandler
implements IndexHandler<Contract, TchDirectContractIndex> {
    public Class<? extends BaseIndexData<Contract, TchDirectContractIndex>> getDataClass() {
        return TchDirectContractIndexData.class;
    }

    public Class<TchDirectContractIndex> getIndexClass() {
        return TchDirectContractIndex.class;
    }

    public Class<Contract> getEntityType() {
        return Contract.class;
    }

    public void create(EntityContainer<Contract> etc, Collection<BaseIndexData<Contract, TchDirectContractIndex>> indexes) {
        Contract entity = (Contract)etc.getEntity();
        for (ContractCustomerInfo info : entity.getCustomers()) {
            for (TchDirectContract directContract : info.getTchDirectContracts()) {
                TchDirectContractIndexData data = new TchDirectContractIndexData();
                DataAggregator aggregator = new DataAggregator();
                data.setNavigationKey(info.getUid());
                data.setContractName(entity.getName());
                data.setDirectContractNumber(directContract.getContractNumber());
                aggregator.aggregate((Object)entity.getName());
                aggregator.aggregate((Object)directContract.getContractNumber());
                data.setAggregatedData(aggregator.toString());
                aggregator.reset();
                indexes.add((BaseIndexData<Contract, TchDirectContractIndex>)data);
            }
        }
    }
}

