/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.finance.PaymentDocumentType;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.TemplateDescriptor;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.model.system.TemplateDocumentIndex;
import com.gridnine.xtrip.common.model.system.TemplateDocumentIndexData;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import org.slf4j.LoggerFactory;

public class TemplateDocumentIndexHandler
implements IndexHandler<TemplateDocument, TemplateDocumentIndex> {
    public Class<? extends BaseIndexData<TemplateDocument, TemplateDocumentIndex>> getDataClass() {
        return TemplateDocumentIndexData.class;
    }

    public Class<TemplateDocumentIndex> getIndexClass() {
        return TemplateDocumentIndex.class;
    }

    public Class<TemplateDocument> getEntityType() {
        return TemplateDocument.class;
    }

    public void create(EntityContainer<TemplateDocument> etc, Collection<BaseIndexData<TemplateDocument, TemplateDocumentIndex>> indexes) {
        TemplateDocumentIndexData data = new TemplateDocumentIndexData();
        TemplateDocument entity = (TemplateDocument)etc.getEntity();
        data.setCreated(etc.getCreated());
        data.setTitle(entity.getTitle());
        try {
            data.setCheckSum(MiscUtil.getCheckSum((byte[])entity.getContent()));
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Unable to calculate checksum for template document " + entity, (Throwable)e);
        }
        data.setSize(entity.getContent() == null ? 0 : entity.getContent().length);
        data.setModifiedDate(etc.getModified());
        data.setIcon(entity.getIcon());
        data.setTemplateId(entity.getTemplateId());
        data.setDisabled(Boolean.valueOf(entity.isDisabled()));
        TemplateDescriptor descriptor = HandlersRegistry.get().findTemplateHandler(entity.getTemplateId());
        if (descriptor != null) {
            data.setType(descriptor.getType());
        }
        DataAggregator aggregator = new DataAggregator();
        aggregator.aggregate((Object)entity.getTitle());
        data.setAggregatedData(aggregator.toString());
        for (Metadata meta : entity.getMetadata()) {
            if (meta.getKey() == null || meta.getKey().getCode() == null) continue;
            if (meta.getKey().getCode().equals(MetadataKey.KEY_FINANCE_DOCUMENT_TYPE.name())) {
                if (meta.getValue() instanceof String) {
                    data.setFinanceDocumentType(FinanceDocumentType.valueOf((String)((String)meta.getValue())));
                    continue;
                }
                if (!(meta.getValue() instanceof FinanceDocumentType)) continue;
                data.setFinanceDocumentType((FinanceDocumentType)meta.getValue());
                continue;
            }
            if (!meta.getKey().getCode().equals(MetadataKey.KEY_PAYMENT_DOCUMENT_TYPE.name())) continue;
            if (meta.getValue() instanceof String) {
                data.setPaymentDocumentType(PaymentDocumentType.valueOf((String)((String)meta.getValue())));
                continue;
            }
            if (!(meta.getValue() instanceof PaymentDocumentType)) continue;
            data.setPaymentDocumentType((PaymentDocumentType)meta.getValue());
        }
        indexes.add((BaseIndexData<TemplateDocument, TemplateDocumentIndex>)data);
    }
}

