/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.finance.Transaction;
import com.gridnine.xtrip.common.model.finance.TransactionSplit;
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndex;
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndexData;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;

public class TransactionSplitIndexHandler
implements IndexHandler<Transaction, TransactionSplitIndex> {
    public Class<? extends BaseIndexData<Transaction, TransactionSplitIndex>> getDataClass() {
        return TransactionSplitIndexData.class;
    }

    public Class<TransactionSplitIndex> getIndexClass() {
        return TransactionSplitIndex.class;
    }

    public Class<Transaction> getEntityType() {
        return Transaction.class;
    }

    public void create(EntityContainer<Transaction> etc, Collection<BaseIndexData<Transaction, TransactionSplitIndex>> indexes) {
        Transaction transaction = (Transaction)etc.getEntity();
        for (TransactionSplit transactionSplit : transaction.getSplits()) {
            TransactionSplitIndexData data = new TransactionSplitIndexData();
            DataAggregator aggregator = new DataAggregator();
            data.setOrganization(transaction.getOrganization());
            data.setBookingUid(transaction.getBooking() != null ? transaction.getBooking().getUid() : null);
            data.setProductUid(transaction.getProductUid());
            data.setDocumentUid(transaction.getDocumentUid());
            data.setTransactionUid(transaction.getTransactionUid());
            data.setDescription(transaction.getDescription());
            data.setOperationDate(transaction.getOperationDate());
            data.setCalculationDate(transaction.getCalculationDate());
            data.setHistorical(Boolean.valueOf(transaction.isHistorical()));
            data.setAutocreated(Boolean.valueOf(transaction.isAutocreated()));
            data.setAmount(transactionSplit.getAmount());
            data.setAccountUid(transactionSplit.getAccount() != null ? transactionSplit.getAccount().getUid() : null);
            data.setCredit(Boolean.valueOf(transactionSplit.isCredit()));
            data.setDimension1(transactionSplit.getDimension1());
            data.setDimension2(transactionSplit.getDimension2());
            data.setDimension3(transactionSplit.getDimension3());
            data.setNavigationKey(transaction.getUid());
            data.setAggregatedData(aggregator.toString());
            indexes.add((BaseIndexData<Transaction, TransactionSplitIndex>)data);
        }
    }
}

