/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.booking.transfer.TransferHelper;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.booking.transfers.TransferIndex;
import com.gridnine.xtrip.common.model.booking.transfers.TransferIndexData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class TransferIndexHandler
implements IndexHandler<BookingFile, TransferIndex> {
    public Class<? extends BaseIndexData<BookingFile, TransferIndex>> getDataClass() {
        return TransferIndexData.class;
    }

    public Class<TransferIndex> getIndexClass() {
        return TransferIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, TransferIndex>> indexes) throws Exception {
        BookingFile bookingFile = (BookingFile)etc.getEntity();
        for (Reservation reservation : bookingFile.getReservations()) {
            DataAggregator aggregator = new DataAggregator();
            for (BaseProduct baseProduct : reservation.getProducts()) {
                if (!(baseProduct instanceof Transfer)) continue;
                Transfer product = (Transfer)baseProduct;
                TransferIndexData data = new TransferIndexData();
                data.setAggregator(aggregator);
                this.updateData(data, product);
                data.setAggregatedData(aggregator.toString());
                indexes.add((BaseIndexData<BookingFile, TransferIndex>)data);
                aggregator.reset();
            }
        }
    }

    protected String composeBookingNumber(Transfer product) {
        return TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile());
    }

    protected Organization getOrganization(Reservation reservation) {
        EntityContainer subagencyContainer;
        Organization subagency = null;
        if (reservation.getSubagency() != null && (subagencyContainer = EntityStorage.get().resolve(reservation.getSubagency())) != null) {
            subagency = (Organization)subagencyContainer.getEntity();
        }
        return subagency;
    }

    private void updateData(TransferIndexData data, Transfer product) {
        List costCodes;
        boolean refund = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        data.setNavigationKey(product.getUid());
        data.setStatus(product.getStatus());
        data.setIssueDate(product.getIssueDate());
        data.setIssueDateTime(product.getIssueDate());
        data.setSystemNumber(product.getSystemNumber());
        data.setCarClass(product.getCarClass());
        data.setSupplier(TransferHelper.getSupplier((Transfer)product));
        data.setPassengersCount(product.getPassengersCount());
        data.setEndDate(product.getEndDate());
        data.setEndDateTime(product.getEndDate());
        data.setStartDate(product.getStartDate());
        data.setStartDateTime(product.getStartDate());
        data.setEndAddress(product.getEndAddress());
        data.setEndCountry(product.getEndCountry());
        data.setEndCity(product.getEndCity());
        data.setStartAddress(product.getStartAddress());
        data.setStartCountry(product.getStartCountry());
        data.setStartCity(product.getStartCity());
        data.setProvider(product.getProvider());
        data.setBlankOwner(product.getBlankOwner());
        EntityReference agency = TransferHelper.getAgency((Transfer)product);
        data.setAgency(agency);
        EntityReference subAgency = TransferHelper.getSubagency((Transfer)product);
        data.setSubagency(subAgency);
        data.setAgent(product.getAgent());
        data.setSalesPoint(product.getSalesPoint());
        data.setTicketType(product.getTicketType() != null ? product.getTicketType() : TicketType.OWN);
        data.setBookingNumber(this.composeBookingNumber(product));
        if (product.getEquivalentFare() != null) {
            data.setEquivalentSum(refund ? product.getEquivalentFare().getValue().negate() : product.getEquivalentFare().getValue());
            data.setEquivalentFareCurrency(product.getEquivalentFare().getCurrency());
        }
        data.setTotalPrice(BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.CLIENT).getTotal());
        data.setPenalty(product.getPenalty());
        data.setClientFee(BookingHelper.calculateFee((BaseProduct)product, (ContractType)ContractType.CLIENT));
        data.setSupplierFee(BookingHelper.calculateFee((BaseProduct)product, (ContractType)ContractType.VENDOR));
        data.setSubagencyFee(BookingHelper.calculateFee((BaseProduct)product, (ContractType)ContractType.SUBAGENCY));
        data.setClientCommission(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)TransferHelper.getUnmodifiableCommissions((Transfer)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
        data.setSupplierCommission(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)TransferHelper.getUnmodifiableCommissions((Transfer)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, null, null)), (boolean)refund));
        data.setSubAddresses((Collection)product.getSubAddresses());
        data.setIwayBookerNumber(product.getIwayBookerNumber());
        List travellersNames = product.getTravellers().stream().map(Traveller::getName).collect(Collectors.toList());
        data.setTravellersNames(travellersNames);
        data.setComments(product.getComments());
        boolean inFinanceDocuments = IndexBuilderHelper.isInFinanceDocuments((BaseProduct)product);
        data.setInFinanceDocuments(Boolean.valueOf(inFinanceDocuments));
        BigDecimal clientFOPAmount = BigDecimal.ZERO;
        boolean hasClientDebt = false;
        for (GeneralProductFop fop : TransferHelper.getClientFops((Transfer)product)) {
            if (fop.getEquivalentAmount() != null) {
                clientFOPAmount = clientFOPAmount.add(fop.getEquivalentAmount());
            }
            if (fop.getOperationDate() != null) continue;
            hasClientDebt = true;
        }
        if (refund) {
            clientFOPAmount = clientFOPAmount.negate();
        }
        data.setClientFopAmount(clientFOPAmount);
        data.setHasClientDebt(Boolean.valueOf(hasClientDebt));
        data.setSubagentFopAmount(GeneralProductHelper.getSubagentFopAmount((BaseProduct)product));
        data.setChecked(Boolean.valueOf(product.isChecked()));
        data.setCompleted(Boolean.valueOf(product.isCompleted()));
        data.setHasWarnings(Boolean.valueOf(false));
        data.setHasOtherErrors(Boolean.valueOf(false));
        data.setHasErrors(Boolean.valueOf(false));
        for (ValidationMessage message : product.getValidationMessages()) {
            if (message.getSeverity() == ValidationMessageSeverity.WARNING) {
                data.setHasWarnings(Boolean.valueOf(true));
            }
            if (message.getSeverity() == ValidationMessageSeverity.USER_ERROR) {
                data.setHasErrors(Boolean.valueOf(true));
            }
            if (message.getSeverity() != ValidationMessageSeverity.ERROR) continue;
            data.setHasErrors(Boolean.valueOf(true));
            if (message.getCategory() != ValidationMessageCategory.OTHER) continue;
            data.setHasOtherErrors(Boolean.valueOf(true));
        }
        if (product.getReservation() != null) {
            data.setRecordLocators(IndexBuilderHelper.getRecordLocators(product.getReservation()));
            data.setDisplayedRecordLocator(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation()));
            data.setGdsNames(IndexBuilderHelper.getGdsNames(product.getReservation()));
            if (product.getReservation().getBookingFile() != null) {
                data.setClient(product.getReservation().getBookingFile().getCustomerProfile());
                String notes = product.getReservation().getBookingFile().getNotes();
                data.setHasNotes(Boolean.valueOf(TextUtil.nonBlank((String)notes)));
            }
        }
        if (!(costCodes = StatisticsHelper.findCostCenterCostCodes((StatisticalData)product.getStatisticalData(), (EntityReference)product.getReservation().getBookingFile().getCustomerProfile())).isEmpty()) {
            data.setCostCenter(IndexBuilderHelper.getCostCodesJoinValue(costCodes, CostCode::getValue));
            data.setCostCenterList(IndexBuilderHelper.getCostCodeValues(costCodes, CostCode::getValue));
        }
    }
}

