/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.common.model.profile.TripartiteContractCalculationIndicatorType;
import com.gridnine.xtrip.common.model.profile.TripartiteContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.TripartiteContractIndex;
import com.gridnine.xtrip.common.model.profile.TripartiteContractIndexData;
import com.gridnine.xtrip.common.model.rules.tripartite.AviaTripartiteContractActions;
import com.gridnine.xtrip.common.model.rules.tripartite.CarTripartiteContractActions;
import com.gridnine.xtrip.common.model.rules.tripartite.HotelTripartiteContractActions;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public class TripartiteContractIndexHandler
implements IndexHandler<TripartiteContract, TripartiteContractIndex> {
    public Class<? extends BaseIndexData<TripartiteContract, TripartiteContractIndex>> getDataClass() {
        return TripartiteContractIndexData.class;
    }

    public Class<TripartiteContractIndex> getIndexClass() {
        return TripartiteContractIndex.class;
    }

    public Class<TripartiteContract> getEntityType() {
        return TripartiteContract.class;
    }

    public void create(EntityContainer<TripartiteContract> etc, Collection<BaseIndexData<TripartiteContract, TripartiteContractIndex>> indexes) {
        TripartiteContract entity = (TripartiteContract)etc.getEntity();
        TripartiteContractIndexData data = new TripartiteContractIndexData();
        DataAggregator aggregator = new DataAggregator();
        data.setContractType(entity.getType());
        aggregator.aggregate((Enum)entity.getType());
        data.setName(entity.getName());
        aggregator.aggregate((Object)entity.getName());
        aggregator.aggregate((Object)entity.getNotes());
        data.setAgency(entity.getAgency());
        aggregator.aggregate((Object)entity.getAgency());
        data.setVendorAirlines((Collection)entity.getAviaVendorData().getAirlines());
        aggregator.aggregate((Iterable)entity.getAviaVendorData().getAirlines());
        data.setVendorAlliances((Collection)entity.getAviaVendorData().getAlliances());
        aggregator.aggregate((Iterable)entity.getAviaVendorData().getAlliances());
        data.setVendorCarsSuppliers((Collection)entity.getCarVendorData().getSuppliers());
        aggregator.aggregate((Iterable)entity.getCarVendorData().getSuppliers());
        data.setVendorHotelsBrands((Collection)entity.getHotelVendorData().getBrands());
        aggregator.aggregate((Iterable)entity.getHotelVendorData().getBrands());
        data.setVendorHotelsProviders((Collection)entity.getHotelVendorData().getProviders());
        aggregator.aggregate((Iterable)entity.getHotelVendorData().getProviders());
        ArrayList<String> customerNames = new ArrayList<String>();
        ArrayList<String> customerUids = new ArrayList<String>();
        Date firstStartDate = null;
        Date lastEndDate = null;
        for (TripartiteContractCustomerInfo ccInfo : entity.getCustomers()) {
            if (ccInfo.getCustomer() != null) {
                customerUids.add(ccInfo.getCustomer().getUid());
                if (ccInfo.getCustomer().getCaption() != null) {
                    customerNames.add(ccInfo.getCustomer().getCaption());
                }
            }
            if (ccInfo.getStartDate() != null && (firstStartDate == null || ccInfo.getStartDate().before(firstStartDate))) {
                firstStartDate = ccInfo.getStartDate();
            }
            if (ccInfo.getEndDate() == null || lastEndDate != null && !ccInfo.getEndDate().after(lastEndDate)) continue;
            lastEndDate = ccInfo.getEndDate();
        }
        data.setFirstStartDate(firstStartDate);
        data.setLastEndDate(lastEndDate);
        data.setCustomerUids(customerUids);
        data.setCustomerNames(customerNames);
        StringBuilder accountCode = new StringBuilder();
        StringBuilder corporateId = new StringBuilder();
        StringBuilder tourCode = new StringBuilder();
        StringBuilder discountNumber = new StringBuilder();
        if (entity.getRuleSet() != null) {
            for (RuleSettings rule : entity.getRuleSet().getRules()) {
                for (RuleResult rr : rule.getResults()) {
                    if (rr == null) continue;
                    if (AviaTripartiteContractActions.AVIA_ACCOUNTING_CODE.equals((Object)rr.getAction())) {
                        accountCode.append(accountCode.length() > 0 ? ", " + rr.getValue().toString() : rr.getValue().toString());
                    }
                    if (AviaTripartiteContractActions.AVIA_CORPORATE_ID.equals((Object)rr.getAction()) || HotelTripartiteContractActions.HOTEL_CORPORATE_ID.equals((Object)rr.getAction())) {
                        corporateId.append(corporateId.length() > 0 ? ", " + rr.getValue().toString() : rr.getValue().toString());
                    }
                    if (AviaTripartiteContractActions.AVIA_TOUR_CODE.equals((Object)rr.getAction())) {
                        tourCode.append(tourCode.length() > 0 ? ", " + rr.getValue().toString() : rr.getValue().toString());
                    }
                    if (!CarTripartiteContractActions.CAR_DISCOUNT_NUMBER.equals((Object)rr.getAction()) && !HotelTripartiteContractActions.HOTEL_DISCOUNT_NUMBER.equals((Object)rr.getAction())) continue;
                    discountNumber.append(discountNumber.length() > 0 ? ", " + rr.getValue().toString() : rr.getValue().toString());
                }
            }
        }
        data.setAccountCode(accountCode.toString());
        data.setTourCode(tourCode.toString());
        data.setCorporateId(corporateId.toString());
        data.setDiscountNumber(discountNumber.toString());
        data.setCalculationIndicator(TripartiteContractIndexHandler.getCalculationIndicator(entity));
        aggregator.aggregate((Object)accountCode);
        aggregator.aggregate((Object)tourCode);
        aggregator.aggregate((Object)corporateId);
        aggregator.aggregate((Object)discountNumber);
        aggregator.aggregate(customerNames);
        data.setAggregatedData(aggregator.toString());
        aggregator.reset();
        indexes.add((BaseIndexData<TripartiteContract, TripartiteContractIndex>)data);
    }

    public static TripartiteContractCalculationIndicatorType getCalculationIndicator(TripartiteContract contract) {
        if (contract == null || contract.getRuleSet() == null) {
            return null;
        }
        for (RuleSettings rs : contract.getRuleSet().getRules()) {
            for (RuleResult rr : rs.getResults()) {
                if (rr.getAction() != AviaTripartiteContractActions.AVIA_CALCULATION_INDICATOR && rr.getAction() != CarTripartiteContractActions.CAR_CALCULATION_INDICATOR && rr.getAction() != HotelTripartiteContractActions.HOTEL_CALCULATION_INDICATOR) continue;
                return (TripartiteContractCalculationIndicatorType)rr.getValue();
            }
        }
        return null;
    }
}

