/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductFopIndex;
import com.gridnine.xtrip.common.model.booking.CommonProductFopIndexData;
import com.gridnine.xtrip.common.model.booking.FopType;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.UniversalProductHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniversalProductCommonProductFopIndexHandler
implements IndexHandler<BookingFile, CommonProductFopIndex> {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<BookingFile, CommonProductFopIndex>> getDataClass() {
        return CommonProductFopIndexData.class;
    }

    public Class<CommonProductFopIndex> getIndexClass() {
        return CommonProductFopIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> bookingFileContainer, Collection<BaseIndexData<BookingFile, CommonProductFopIndex>> datas) {
        for (Reservation reservation : ((BookingFile)bookingFileContainer.getEntity()).getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                if (!(baseProduct instanceof UniversalProduct)) continue;
                UniversalProduct product = (UniversalProduct)baseProduct;
                if (ProductStatusHandler.getAllVoidStatuses().contains(product.getStatus())) continue;
                this.addIndeces(datas, product, ContractType.VENDOR);
                this.addIndeces(datas, product, ContractType.SUBAGENCY);
                this.addIndeces(datas, product, ContractType.CLIENT);
            }
        }
    }

    private void addIndeces(Collection<BaseIndexData<BookingFile, CommonProductFopIndex>> datas, UniversalProduct product, ContractType contractType) {
        List fops = null;
        switch (contractType) {
            case VENDOR: {
                fops = UniversalProductHelper.getVendorFops((UniversalProduct)product);
                break;
            }
            case SUBAGENCY: {
                fops = UniversalProductHelper.getSubagentFops((UniversalProduct)product, (boolean)false);
                break;
            }
            default: {
                fops = UniversalProductHelper.getClientFops((UniversalProduct)product);
            }
        }
        for (GeneralProductFop fop : fops) {
            DataAggregator aggregator = new DataAggregator();
            CommonProductFopIndexData data = new CommonProductFopIndexData();
            this.updateProductData(data, aggregator, product);
            this.updateFopData(data, aggregator, fop, product);
            data.setContractType(contractType);
            if (contractType == ContractType.CLIENT) {
                data.setRefuse(Boolean.valueOf(fop.isRefused()));
            }
            data.setAggregatedData(aggregator.toString());
            datas.add((BaseIndexData<BookingFile, CommonProductFopIndex>)data);
        }
    }

    protected void updateProductData(CommonProductFopIndexData data, DataAggregator aggregator, UniversalProduct product) {
        data.setProductUid(product.getUid());
        String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile());
        data.setBookingNumber(bookingNumber);
        aggregator.aggregate((Object)bookingNumber);
        data.setProductType(ProductType.MISC_PRODUCT);
        aggregator.aggregate((Enum)ProductType.MISC_PRODUCT);
        data.setClient(product.getReservation().getBookingFile().getCustomerProfile());
        aggregator.aggregate((Object)product.getReservation().getBookingFile().getCustomerProfile());
        data.setBlankOwner(product.getBlankOwner());
        aggregator.aggregate((Object)product.getBlankOwner());
        EntityReference supplier = UniversalProductHelper.getSupplier((UniversalProduct)product);
        data.setSupplier(supplier);
        aggregator.aggregate((Object)supplier);
        EntityReference agency = UniversalProductHelper.getAgency((UniversalProduct)product);
        data.setAgency(agency);
        aggregator.aggregate((Object)agency);
        EntityReference subagency = UniversalProductHelper.getSubagency((UniversalProduct)product);
        data.setSubagency(subagency);
        aggregator.aggregate((Object)subagency);
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            data.setHolding(((Organization)clientContainer.getEntity()).getHolding());
            aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
        }
        data.setBranch(product.getBranch());
        aggregator.aggregate((Object)product.getBranch());
        data.setSalesPoint(product.getSalesPoint());
        aggregator.aggregate((Object)product.getSalesPoint());
        data.setAgent(product.getAgent());
        aggregator.aggregate((Object)product.getAgent());
        data.setTicketType(product.getTicketType());
        aggregator.aggregate((Enum)product.getTicketType());
        IndexBuilderHelper.updateReservationGdsNameInfo(product.getReservation(), data, aggregator);
        data.setIssueDate(product.getIssueDate());
        data.setIssueDateTime(product.getIssueDate());
        data.setUnholdDate(null);
        data.setUnholdDateTime(null);
        data.setStatus(product.getStatus());
        aggregator.aggregate((Enum)product.getStatus());
        String blankOwnerCode = null;
        String blankOwnerAirlineNumber = null;
        if (product.getBlankOwner() != null) {
            try {
                EntityContainer blankOwnerContainer = EntityStorage.get().resolve(product.getBlankOwner());
                if (blankOwnerContainer != null) {
                    Airline airline = (Airline)DictionaryCache.get().resolveReference(((Organization)blankOwnerContainer.getEntity()).getAirline());
                    if (airline != null) {
                        blankOwnerAirlineNumber = airline.getAirlineNumber();
                    }
                    blankOwnerCode = ((Organization)blankOwnerContainer.getEntity()).getCode();
                }
            }
            catch (Exception e) {
                this.log.error("unable to resolve blank owner", (Throwable)e);
            }
        }
        data.setBlankOwnerCode(blankOwnerCode);
        aggregator.aggregate(blankOwnerCode);
        data.setBlankOwnerAirlineNumber(blankOwnerAirlineNumber);
        aggregator.aggregate(blankOwnerAirlineNumber);
        ArrayList<String> systemNumbers = new ArrayList<String>();
        if (!TextUtil.isBlank((String)product.getSystemNumber())) {
            systemNumbers.add(product.getSystemNumber());
        }
        data.setSystemNumbers(systemNumbers);
        aggregator.aggregate(systemNumbers);
        String routeLine = UniversalProductHelper.getRouteLine((UniversalProduct)product);
        routeLine = !TextUtil.isBlank((String)routeLine) && routeLine.length() > 255 ? "???" : routeLine;
        data.setRouteLine(routeLine);
        aggregator.aggregate((Object)routeLine);
        HashSet<String> travellersNames = new HashSet<String>();
        for (String travellerUid : product.getTravellersUids()) {
            Traveller traveller = (Traveller)CollectionUtil.find((Iterable)product.getReservation().getBookingFile().getTravellers(), (String)travellerUid);
            if (traveller == null || traveller.getName() == null) continue;
            travellersNames.add(traveller.getName());
        }
        data.setTravellersNames(travellersNames);
        aggregator.aggregate(travellersNames);
        ServiceLocationType serviceLocationType = product.isHasVat() ? ServiceLocationType.DOMESTIC : ServiceLocationType.INTERNATIONAL;
        data.setServiceLocationType(serviceLocationType);
        aggregator.aggregate((Enum)serviceLocationType);
    }

    protected void updateFopData(CommonProductFopIndexData data, DataAggregator aggregator, GeneralProductFop fop, UniversalProduct product) {
        data.setFopUid(fop.getUid());
        FopType fopType = GeneralProductHelper.getFopType((GeneralProductFop)fop);
        data.setFopType(fopType);
        aggregator.aggregate((Enum)fopType);
        data.setPaymentType(fop.getType());
        aggregator.aggregate((Enum)fop.getType());
        BigDecimal equivalentAmount = fop.getEquivalentAmount();
        if (equivalentAmount != null && (product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE)) {
            equivalentAmount = equivalentAmount.negate();
        }
        data.setAmount(equivalentAmount);
        try {
            String currency = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)null);
            data.setCurrency(currency);
            aggregator.aggregate((Object)currency);
        }
        catch (Exception currency) {
            // empty catch block
        }
        CardVendor cardVendor = null;
        String cardNumber = null;
        String cardSecurityCode = null;
        if (fop.getCard() != null) {
            Card card = fop.getCard();
            cardVendor = card.getVendor();
            cardNumber = card.getNumber();
            cardSecurityCode = card.getSecurityCode();
        }
        data.setCardVendor(cardVendor);
        aggregator.aggregate((Enum)cardVendor);
        data.setCardNumber(cardNumber);
        aggregator.aggregate((Object)cardNumber);
        data.setCardSecurityCode(cardSecurityCode);
        aggregator.aggregate((Object)cardSecurityCode);
        data.setRelatedTicketNumber(fop.getRelatedTicketNumber());
        aggregator.aggregate((Object)fop.getRelatedTicketNumber());
        data.setFopAgent(fop.getAgent());
        aggregator.aggregate((Object)fop.getAgent());
        data.setFopDate(fop.getOperationDate());
        data.setHasComments(Boolean.valueOf(!TextUtil.isBlank((String)product.getReservation().getBookingFile().getNotes())));
    }
}

