/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductIndex;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductIndexData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.helpers.UniversalProductHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniversalProductIndexHandler
implements IndexHandler<BookingFile, UniversalProductIndex> {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<BookingFile, UniversalProductIndex>> getDataClass() {
        return UniversalProductIndexData.class;
    }

    public Class<UniversalProductIndex> getIndexClass() {
        return UniversalProductIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, UniversalProductIndex>> indexes) {
        for (Reservation reservation : ((BookingFile)etc.getEntity()).getReservations()) {
            DataAggregator aggregator = new DataAggregator();
            for (BaseProduct product : reservation.getProducts()) {
                if (!(product instanceof UniversalProduct)) continue;
                UniversalProductIndexData data = new UniversalProductIndexData();
                aggregator.reset();
                try {
                    UniversalProduct airProduct = (UniversalProduct)product;
                    this.updateData(data, aggregator, airProduct);
                    data.setAggregatedData(aggregator.toString());
                }
                catch (Exception e) {
                    this.log.error("unable to create index", (Throwable)e);
                    continue;
                }
                indexes.add((BaseIndexData<BookingFile, UniversalProductIndex>)data);
            }
        }
    }

    protected void updateData(UniversalProductIndexData data, DataAggregator aggregator, UniversalProduct product) throws Exception {
        List costCodes;
        UniversalProductDescription description;
        EntityReference descriptionReference;
        Date travelDate;
        String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile());
        data.setBookingNumber(bookingNumber);
        aggregator.aggregate((Object)bookingNumber);
        data.setDescription(product.getDescription());
        aggregator.aggregate((Object)product.getDescription());
        EntityReference agency = UniversalProductHelper.getAgency((UniversalProduct)product);
        data.setAgency(agency);
        aggregator.aggregate((Object)agency);
        data.setAgent(product.getAgent());
        aggregator.aggregate((Object)product.getAgent());
        data.setBlankOwner(product.getBlankOwner());
        aggregator.aggregate((Object)product.getBlankOwner());
        data.setBlankType(product.getBlankType());
        aggregator.aggregate((Object)product.getBlankType());
        Date refuseDate = null;
        for (GeneralProductFop fop : UniversalProductHelper.getClientFops((UniversalProduct)product)) {
            if (!fop.isRefused() || fop.getOperationDate() == null || refuseDate != null && !refuseDate.after(fop.getOperationDate())) continue;
            refuseDate = fop.getOperationDate();
        }
        if (refuseDate != null) {
            data.setCancellationDate(refuseDate);
            aggregator.aggregate(refuseDate);
        }
        if ((travelDate = UniversalProductHelper.getFirstTravelDate((UniversalProduct)product)) != null) {
            data.setTravelDate(travelDate);
            aggregator.aggregate(travelDate);
        }
        data.setChecked(Boolean.valueOf(product.isChecked()));
        data.setCompleted(Boolean.valueOf(product.isCompleted()));
        data.setClient(product.getReservation().getBookingFile().getCustomerProfile());
        aggregator.aggregate((Object)product.getReservation().getBookingFile().getCustomerProfile());
        String accountingCode = ProfileHelper.findAccountingCode((EntityReference)product.getReservation().getBookingFile().getCustomerProfile());
        data.setClientAccountingCode(accountingCode);
        aggregator.aggregate((Object)accountingCode);
        boolean refund = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        data.setNavigationKey(product.getUid());
        List<String> recordLocators = IndexBuilderHelper.getRecordLocators(product.getReservation());
        data.setRecordLocators(recordLocators);
        aggregator.aggregate(recordLocators);
        List<GdsName> gdsNames = IndexBuilderHelper.getGdsNames(product.getReservation());
        data.setGdsNames(gdsNames);
        aggregator.aggregate(gdsNames);
        data.setDisplayedRecordLocator(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation()));
        data.setRulesGdsName(product.getReservation().getGdsNameInfo().getRulesGdsName());
        ProductStatus status = product.getStatus();
        data.setStatus(status);
        aggregator.aggregate((Enum)status);
        Date issueDate = product.getIssueDate();
        data.setIssueDate(issueDate);
        aggregator.aggregate(issueDate);
        data.setIssueDateTime(issueDate);
        data.setTicketNumber(product.getSystemNumber());
        aggregator.aggregate((Object)product.getSystemNumber());
        TicketType ticketType = product.getTicketType() != null ? product.getTicketType() : TicketType.OWN;
        data.setTicketType(ticketType);
        aggregator.aggregate((Enum)ticketType);
        data.setScn(product.getScn());
        aggregator.aggregate((Object)product.getScn());
        EntityReference subagency = UniversalProductHelper.getSubagency((UniversalProduct)product);
        data.setSubagency(subagency);
        aggregator.aggregate((Object)subagency);
        EntityContainer clientContainer = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
        if (clientContainer != null) {
            data.setHolding(((Organization)clientContainer.getEntity()).getHolding());
            aggregator.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
        }
        if ((descriptionReference = product.getDescription()) != null && (description = (UniversalProductDescription)EntityStorage.get().resolve(descriptionReference).getEntity()).isBaseFareSupported()) {
            Money baseFare = product.getBaseFare();
            if (baseFare != null) {
                data.setTariff(baseFare.getValue());
            }
            data.setRate(product.getRateWithCoeff());
        }
        data.setBranch(product.getBranch());
        aggregator.aggregate((Object)product.getBranch());
        data.setSalesPoint(product.getSalesPoint());
        aggregator.aggregate((Object)product.getSalesPoint());
        EntityReference supplier = UniversalProductHelper.getSupplier((UniversalProduct)product);
        data.setSupplier(supplier);
        aggregator.aggregate((Object)supplier);
        data.setEticket(Boolean.valueOf(product.isEticket()));
        ArrayList<String> travellerNames = new ArrayList<String>();
        for (String travellerUid : product.getTravellersUids()) {
            Traveller traveller = (Traveller)CollectionUtil.find((Iterable)product.getReservation().getBookingFile().getTravellers(), (String)travellerUid);
            if (traveller == null || traveller.getName() == null) continue;
            travellerNames.add(traveller.getName());
        }
        data.setTravellersNames(travellerNames);
        aggregator.aggregate(travellerNames);
        data.setHasStockControlErrors(Boolean.valueOf(false));
        BigDecimal taxAmount = GeneralProductHelper.getEquivalentTaxAmount((Collection)product.getTaxes());
        BigDecimal taxesForBlankSum = GeneralProductHelper.getTaxesForBlankEquivalentAmount((BaseProduct)product);
        BigDecimal otherTaxesSum = taxAmount.subtract(taxesForBlankSum);
        data.setTaxesForBlankSum(refund ? taxesForBlankSum.negate() : taxesForBlankSum);
        data.setOtherTaxesSum(refund ? otherTaxesSum.negate() : otherTaxesSum);
        data.setTaxesSum(refund ? taxAmount.negate() : taxAmount);
        for (ValidationMessage message : product.getValidationMessages()) {
            if (message.getSeverity() != ValidationMessageSeverity.ERROR) continue;
            data.setHasErrors(Boolean.valueOf(true));
            if (message.getCategory() == ValidationMessageCategory.OTHER) {
                data.setHasOtherErrors(Boolean.valueOf(true));
            }
            if (message.getCategory() != ValidationMessageCategory.STOCK_CONTROL) continue;
            data.setHasStockControlErrors(Boolean.valueOf(true));
        }
        List vendorFops = UniversalProductHelper.getVendorFops((UniversalProduct)product);
        Date date = null;
        for (GeneralProductFop fop : vendorFops) {
            if (fop.getEquivalentAmount() == null || fop.getOperationDate() == null || date != null && !date.before(fop.getOperationDate())) continue;
            date = fop.getOperationDate();
        }
        data.setDateOfVendorPayment(date);
        if (status != ProductStatus.VOID) {
            BigDecimal equivalentFare = product.getEquivalentFare();
            if (equivalentFare == null) {
                equivalentFare = BigDecimal.ZERO;
            }
            if (refund) {
                equivalentFare = equivalentFare.negate();
            }
            data.setEquivalentFare(equivalentFare);
            aggregator.aggregate((Object)equivalentFare);
            VatAmount price = BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.CLIENT);
            BigDecimal totalSum = price.getTotal();
            data.setTotalSum(totalSum);
            if (refund && product.getPreviousProduct() != null) {
                data.setSellAgent(product.getPreviousProduct().getAgent());
                aggregator.aggregate((Object)product.getPreviousProduct().getAgent());
            }
            data.setPenalty(product.getPenalty());
            String route = UniversalProductHelper.getRouteLine((UniversalProduct)product);
            data.setRouteLine(route);
            aggregator.aggregate((Object)route);
            String serviceDescriptionLine = UniversalProductHelper.getServiceDetailsLine((UniversalProduct)product);
            data.setServiceDetailsLine(serviceDescriptionLine);
            data.setVendorCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)UniversalProductHelper.getUnmodifiableCommissions((UniversalProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
            data.setVendorBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)UniversalProductHelper.getUnmodifiableCommissions((UniversalProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
            data.setVendorFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)UniversalProductHelper.getUnmodifiableCommissions((UniversalProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
            data.setVendorCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)UniversalProductHelper.getUnmodifiableCommissions((UniversalProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
            data.setVendorBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)UniversalProductHelper.getUnmodifiableCommissions((UniversalProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
            data.setVendorFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)UniversalProductHelper.getUnmodifiableCommissions((UniversalProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
            data.setSubagencyCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)UniversalProductHelper.getUnmodifiableCommissions((UniversalProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
            data.setSubagencyBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)UniversalProductHelper.getUnmodifiableCommissions((UniversalProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
            data.setSubagencyFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)UniversalProductHelper.getUnmodifiableCommissions((UniversalProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
            data.setSubagencyCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)UniversalProductHelper.getUnmodifiableCommissions((UniversalProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
            data.setSubagencyBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)UniversalProductHelper.getUnmodifiableCommissions((UniversalProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
            data.setSubagencyFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)UniversalProductHelper.getUnmodifiableCommissions((UniversalProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
            data.setClientCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)UniversalProductHelper.getUnmodifiableCommissions((UniversalProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
            data.setClientBonusValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)UniversalProductHelper.getUnmodifiableCommissions((UniversalProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null)), (boolean)refund));
            data.setClientFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)UniversalProductHelper.getUnmodifiableCommissions((UniversalProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
            data.setClientCommissionRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)UniversalProductHelper.getUnmodifiableCommissions((UniversalProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null), (boolean)true));
            data.setClientBonusRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)UniversalProductHelper.getUnmodifiableCommissions((UniversalProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.bonusCommissionTypes, null), (boolean)true));
            data.setClientFeeRate(GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)GeneralProductHelper.filterCommissions((Collection)UniversalProductHelper.getUnmodifiableCommissions((UniversalProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null), (boolean)true));
            Date date2 = null;
            EntityReference agent = null;
            boolean hasClientDebt = false;
            HashSet<PaymentType> clientFopTypes = new HashSet<PaymentType>();
            HashSet<PaymentType> clientFeesFopTypes = new HashSet<PaymentType>();
            BigDecimal clientFOPAmount = BigDecimal.ZERO;
            for (GeneralProductFop fop : UniversalProductHelper.getClientFops((UniversalProduct)product)) {
                if (fop.getEquivalentAmount() == null) continue;
                clientFOPAmount = clientFOPAmount.add(fop.getEquivalentAmount());
                if (fop.getType() != null) {
                    if (GeneralProductHelper.isServiceFop((GeneralProductFop)fop)) {
                        clientFopTypes.add(fop.getType());
                    } else {
                        clientFeesFopTypes.add(fop.getType());
                    }
                }
                if (fop.getOperationDate() == null) {
                    hasClientDebt = true;
                    continue;
                }
                if (date2 != null && !date2.before(fop.getOperationDate())) continue;
                date2 = fop.getOperationDate();
                agent = fop.getAgent();
            }
            data.setClientFopAmount(clientFOPAmount);
            data.setClientFopTypes(clientFopTypes);
            data.setClientFeesFopTypes(clientFeesFopTypes);
            data.setDateOfClientPayment(date2);
            aggregator.aggregate(date2);
            data.setClientFopAgent(agent);
            aggregator.aggregate(agent);
            data.setHasClientDebt(Boolean.valueOf(hasClientDebt));
            HashSet<PaymentType> vendorFopTypes = new HashSet<PaymentType>();
            BigDecimal vendorFOPAmount = BigDecimal.ZERO;
            for (Object fop : vendorFops) {
                if (fop.getEquivalentAmount() == null) continue;
                vendorFOPAmount = vendorFOPAmount.add(fop.getEquivalentAmount());
                if (fop.getType() == null) continue;
                vendorFopTypes.add(fop.getType());
            }
            data.setVendorFopAmount(vendorFOPAmount);
            data.setVendorFopTypes(vendorFopTypes);
            HashSet<PaymentType> subagentFopTypes = new HashSet<PaymentType>();
            HashSet<PaymentType> subagentFeesFopTypes = new HashSet<PaymentType>();
            List subagentFops = UniversalProductHelper.getSubagentFops((UniversalProduct)product, (boolean)false);
            if (subagentFops != null) {
                for (GeneralProductFop fop : subagentFops) {
                    if (fop.getType() == null) continue;
                    if (GeneralProductHelper.isServiceFop((GeneralProductFop)fop)) {
                        subagentFopTypes.add(fop.getType());
                        continue;
                    }
                    subagentFeesFopTypes.add(fop.getType());
                }
            }
            data.setSubagentFopTypes(subagentFopTypes);
            data.setSubagentFeesFopTypes(subagentFeesFopTypes);
            String notes = product.getReservation().getBookingFile().getNotes();
            data.setHasNotes(Boolean.valueOf(notes != null && !notes.trim().isEmpty()));
            boolean inFinanceDocuments = IndexBuilderHelper.isInFinanceDocuments((BaseProduct)product);
            data.setInFinanceDocuments(Boolean.valueOf(inFinanceDocuments));
            boolean inDelivery = IndexBuilderHelper.isInDelivery((BaseProduct)product);
            data.setInDelivery(Boolean.valueOf(inDelivery));
            data.setAgentPenaltyForProduct(BookingHelper.calculateAgentPenaltyForProduct((BaseProduct)product));
            data.setAgentPenaltyForCommissions(null);
            data.setAgentPenaltyForFees(BookingHelper.calculateAgentPenaltyForFees((BaseProduct)product));
            HashSet<ProductType> mcoFeesTypes = new HashSet<ProductType>();
            mcoFeesTypes.add(ProductType.MCO_FEES);
            ArrayList<String> mcoFeesNumbers = new ArrayList<String>();
            for (BaseProduct mcoFeesProduct : BookingHelper.filterProducts((List)BookingHelper.getConnectedProducts((BaseProduct)product), mcoFeesTypes)) {
                ProductHandler handler = HandlersRegistry.get().findProductHandler(mcoFeesProduct.getClass());
                if (handler == null) continue;
                for (String systemNumber : handler.getProductNumbers(mcoFeesProduct)) {
                    mcoFeesNumbers.add(systemNumber);
                }
            }
            data.setMcoFeesNumbers(mcoFeesNumbers);
            aggregator.aggregate(mcoFeesNumbers);
        }
        if (!(costCodes = StatisticsHelper.findCostCenterCostCodes((StatisticalData)product.getStatisticalData(), (EntityReference)product.getReservation().getBookingFile().getCustomerProfile())).isEmpty()) {
            String value = IndexBuilderHelper.getCostCodesJoinValue(costCodes, CostCode::getValue);
            String localValue = IndexBuilderHelper.getCostCodesJoinValue(costCodes, CostCode::getLocalValue);
            String englishValue = IndexBuilderHelper.getCostCodesJoinValue(costCodes, CostCode::getEnglishValue);
            data.setCostCenter(value);
            data.setCostCenterLocalValue(localValue);
            data.setCostCenterEnglishValue(englishValue);
            aggregator.aggregate((Object)value);
            aggregator.aggregate((Object)localValue);
            aggregator.aggregate((Object)englishValue);
            data.setCostCenterList(IndexBuilderHelper.getCostCodeValues(costCodes, CostCode::getValue));
            data.setCostCenterLocalValueList(IndexBuilderHelper.getCostCodeValues(costCodes, CostCode::getLocalValue));
            data.setCostCenterEnglishValueList(IndexBuilderHelper.getCostCodeValues(costCodes, CostCode::getEnglishValue));
        }
        String comments = TextUtil.getFieldOrTrimToLength((String)product.getComments(), (int)255);
        data.setComments(comments);
        aggregator.aggregate((Object)comments);
    }
}

