/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.profile.ValidatorIndex;
import com.gridnine.xtrip.common.model.profile.ValidatorIndexData;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;
import java.util.HashMap;

public class ValidatorIndexHandler
implements IndexHandler<SalesPoint, ValidatorIndex> {
    public Class<? extends BaseIndexData<SalesPoint, ValidatorIndex>> getDataClass() {
        return ValidatorIndexData.class;
    }

    public Class<ValidatorIndex> getIndexClass() {
        return ValidatorIndex.class;
    }

    public Class<SalesPoint> getEntityType() {
        return SalesPoint.class;
    }

    public void create(EntityContainer<SalesPoint> etc, Collection<BaseIndexData<SalesPoint, ValidatorIndex>> indexes) {
        HashMap<EntityReference, DictionaryReference> blankOwnerAirlineMap = new HashMap<EntityReference, DictionaryReference>();
        for (Validator val : ((SalesPoint)etc.getEntity()).getValidators()) {
            ValidatorIndexData data = new ValidatorIndexData();
            DataAggregator aggregator = new DataAggregator();
            EntityReference blankOwner = val.getBlankOwner();
            DictionaryReference blankOwnerAirline = (DictionaryReference)blankOwnerAirlineMap.get(blankOwner);
            if (blankOwnerAirline == null) {
                EntityContainer blankOwnerCtr = EntityStorage.get().resolve(blankOwner);
                blankOwnerAirline = blankOwnerCtr == null ? null : ((Organization)blankOwnerCtr.getEntity()).getAirline();
                blankOwnerAirlineMap.put(blankOwner, blankOwnerAirline);
            }
            data.setBlankOwnerAirline(blankOwnerAirline);
            aggregator.aggregate((Object)blankOwnerAirline);
            data.setAgency(val.getAgency());
            data.setBlankOwner(blankOwner);
            data.setSalesPoint(etc.toReference());
            data.setDisabled(Boolean.valueOf(((SalesPoint)etc.getEntity()).isDisabled()));
            data.setClosed(val.getClosed());
            data.setNumber(val.getNumber());
            data.setOpened(val.getOpened());
            data.setSupplier(val.getSupplier());
            data.setNavigationKey(val.getUid());
            data.setSubagency(((SalesPoint)etc.getEntity()).getAgency());
            data.setPcc(val.getPCC() != null ? val.getPCC().getCode() : null);
            aggregator.aggregate(val.getClosed());
            aggregator.aggregate(val.getOpened());
            aggregator.aggregate((Object)val.getAgency());
            aggregator.aggregate((Object)blankOwner);
            aggregator.aggregate((Object)val.getNotes());
            aggregator.aggregate((Object)val.getSupplier());
            aggregator.aggregate((Object)((SalesPoint)etc.getEntity()).getAgency());
            aggregator.aggregate((Object)val.getNumber());
            aggregator.aggregate(val.getPCC() != null ? val.getPCC().getCode() : null);
            data.setAggregatedData(aggregator.toString());
            indexes.add((BaseIndexData<SalesPoint, ValidatorIndex>)data);
        }
    }
}

