/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.booking.visa.VisaEntryType;
import com.gridnine.xtrip.common.model.booking.visa.VisaProduct;
import com.gridnine.xtrip.common.model.booking.visa.VisaProductHelper;
import com.gridnine.xtrip.common.model.booking.visa.VisaProductIndex;
import com.gridnine.xtrip.common.model.booking.visa.VisaProductIndexData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisaProductIndexHandler
implements IndexHandler<BookingFile, VisaProductIndex> {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public Class<? extends BaseIndexData<BookingFile, VisaProductIndex>> getDataClass() {
        return VisaProductIndexData.class;
    }

    public Class<VisaProductIndex> getIndexClass() {
        return VisaProductIndex.class;
    }

    public Class<BookingFile> getEntityType() {
        return BookingFile.class;
    }

    public void create(EntityContainer<BookingFile> etc, Collection<BaseIndexData<BookingFile, VisaProductIndex>> indexes) {
        for (Reservation reservation : ((BookingFile)etc.getEntity()).getReservations()) {
            DataAggregator aggregator = new DataAggregator();
            for (BaseProduct baseProduct : reservation.getProducts()) {
                if (!(baseProduct instanceof VisaProduct)) continue;
                VisaProduct visa = (VisaProduct)baseProduct;
                VisaProductIndexData data = new VisaProductIndexData();
                this.updateData(data, aggregator, visa);
                data.setAggregatedData(aggregator.toString());
                indexes.add((BaseIndexData<BookingFile, VisaProductIndex>)data);
                aggregator.reset();
            }
        }
    }

    private void updateData(VisaProductIndexData data, DataAggregator aggregator, VisaProduct product) {
        data.setNavigationKey(product.getUid());
        ProductStatus status = product.getStatus();
        data.setStatus(status);
        TicketType ticketType = product.getTicketType() != null ? product.getTicketType() : TicketType.OWN;
        data.setTicketType(ticketType);
        Date issueDate = product.getIssueDate();
        data.setIssueDate(issueDate);
        data.setIssueDateTime(issueDate);
        String systemNumber = product.getSystemNumber();
        data.setSystemNumber(systemNumber);
        DictionaryReference country = product.getCountry();
        data.setCountry(country);
        DictionaryReference type = product.getType();
        data.setType(type);
        VisaEntryType entryType = product.getEntryType();
        data.setEntryType(entryType);
        DictionaryReference applicationStatus = product.getApplicationStatus();
        data.setApplicationStatus(applicationStatus);
        boolean expressService = product.isExpressService();
        data.setExpressService(Boolean.valueOf(expressService));
        Date startDate = product.getStartDate();
        data.setStartDate(startDate);
        Date endDate = product.getEndDate();
        data.setEndDate(endDate);
        EntityReference blankOwner = product.getBlankOwner();
        data.setBlankOwner(blankOwner);
        EntityReference supplier = VisaProductHelper.getSupplier((VisaProduct)product);
        data.setSupplier(supplier);
        EntityReference subagency = VisaProductHelper.getSubagency((VisaProduct)product);
        data.setSubagency(subagency);
        EntityReference agency = VisaProductHelper.getAgency((VisaProduct)product);
        data.setAgency(agency);
        EntityReference salesPoint = product.getSalesPoint();
        data.setSalesPoint(salesPoint);
        EntityReference agent = product.getAgent();
        data.setAgent(agent);
        EntityReference customerProfile = product.getReservation().getBookingFile().getCustomerProfile();
        if (customerProfile != null) {
            data.setClient(customerProfile);
            aggregator.aggregate((Object)customerProfile.getCaption());
        }
        HashSet travellersNames = new HashSet();
        product.getTravellers().stream().map(Traveller::getName).filter(TextUtil::nonBlank).forEach(travellersNames::add);
        data.setTravellersNames(travellersNames);
        aggregator.aggregate(travellersNames);
        String comments = product.getComments();
        data.setComments(comments);
        BigDecimal totalPrice = VisaProductHelper.getTotalPrice((VisaProduct)product);
        data.setTotalPrice(totalPrice);
        if (product.getEquivalentFare() != null) {
            data.setEquivalentFareCurrency(product.getEquivalentFare().getCurrency());
        }
        BigDecimal penalty = product.getPenalty();
        data.setPenalty(penalty);
        boolean refund = status == ProductStatus.REFUND;
        data.setVendorCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)VisaProductHelper.getUnmodifiableCommissions((VisaProduct)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
        data.setSubagencyCommissionValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)VisaProductHelper.getUnmodifiableCommissions((VisaProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, null)), (boolean)refund));
        data.setClientFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)VisaProductHelper.getUnmodifiableCommissions((VisaProduct)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
        data.setSubagencyFeeValue(BookingHelper.getCommissionValue((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)VisaProductHelper.getUnmodifiableCommissions((VisaProduct)product, (ContractType)ContractType.SUBAGENCY), (Set)GeneralProductHelper.feePropertyTypes, null, null)), (boolean)refund));
        aggregator.aggregate((Object)systemNumber);
        boolean inFinanceDocuments = IndexBuilderHelper.isInFinanceDocuments((BaseProduct)product);
        data.setInFinanceDocuments(Boolean.valueOf(inFinanceDocuments));
        boolean hasClientDebt = false;
        for (GeneralProductFop fop : VisaProductHelper.getClientFops((VisaProduct)product)) {
            if (fop.getOperationDate() != null) continue;
            hasClientDebt = true;
            break;
        }
        data.setHasClientDebt(Boolean.valueOf(hasClientDebt));
        data.setChecked(Boolean.valueOf(product.isChecked()));
        data.setCompleted(Boolean.valueOf(product.isCompleted()));
        data.setHasOtherErrors(Boolean.valueOf(false));
        data.setHasErrors(Boolean.valueOf(false));
        for (ValidationMessage message : product.getValidationMessages()) {
            if (message.getSeverity() == ValidationMessageSeverity.USER_ERROR) {
                data.setHasErrors(Boolean.valueOf(true));
            }
            if (message.getSeverity() != ValidationMessageSeverity.ERROR) continue;
            data.setHasErrors(Boolean.valueOf(true));
            if (message.getCategory() != ValidationMessageCategory.OTHER) continue;
            data.setHasOtherErrors(Boolean.valueOf(true));
        }
        if (product.getReservation() != null) {
            data.setRecordLocators(IndexBuilderHelper.getRecordLocators(product.getReservation()));
            data.setGdsNames(IndexBuilderHelper.getGdsNames(product.getReservation()));
            data.setDisplayedRecordLocator(CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation()));
            if (product.getReservation().getBookingFile() != null) {
                String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile());
                aggregator.aggregate((Object)bookingNumber);
                data.setBookingNumber(bookingNumber);
                data.setClient(product.getReservation().getBookingFile().getCustomerProfile());
                String notes = product.getReservation().getBookingFile().getNotes();
                data.setHasNotes(Boolean.valueOf(TextUtil.nonBlank((String)notes)));
            }
        }
    }
}

