/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Worklog;
import com.gridnine.xtrip.common.model.system.WorklogIndex;
import com.gridnine.xtrip.common.model.system.WorklogIndexData;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import java.util.Collection;

public class WorklogIndexHandler
implements IndexHandler<Worklog, WorklogIndex> {
    public Class<? extends BaseIndexData<Worklog, WorklogIndex>> getDataClass() {
        return WorklogIndexData.class;
    }

    public Class<WorklogIndex> getIndexClass() {
        return WorklogIndex.class;
    }

    public Class<Worklog> getEntityType() {
        return Worklog.class;
    }

    public void create(EntityContainer<Worklog> etc, Collection<BaseIndexData<Worklog, WorklogIndex>> indexes) {
        WorklogIndexData data = new WorklogIndexData();
        DataAggregator aggregator = new DataAggregator();
        this.updateData(etc, data, aggregator);
        data.setAggregatedData(aggregator.toString());
        indexes.add((BaseIndexData<Worklog, WorklogIndex>)data);
    }

    protected void updateData(EntityContainer<Worklog> etc, WorklogIndexData data, DataAggregator aggregator) {
        Worklog entity = (Worklog)etc.getEntity();
        EntityContainer salesPointContainer = EntityStorage.get().resolve(entity.getSalesPoint());
        if (salesPointContainer != null) {
            SalesPoint salesPoint = (SalesPoint)salesPointContainer.getEntity();
            data.setBranch(salesPoint.getBranch());
            aggregator.aggregate((Object)salesPoint.getBranch());
        }
        data.setEmployee(entity.getEmployee());
        data.setType(entity.getType());
        data.setTypes((Collection)entity.getTypes());
        data.setAgency(entity.getAgency());
        data.setSalesPoint(entity.getSalesPoint());
        data.setCash(entity.getCash());
        data.setCashRegister(entity.getCashRegister());
        data.setCashRegisterWorkplace(entity.getCashRegisterWorkplace());
        data.setCashier(Boolean.valueOf(entity.isCashier()));
        data.setStartDate(entity.getStartDate());
        data.setEndDate(entity.getEndDate());
        data.setForcedEnd(Boolean.valueOf(entity.isForcedEnd()));
        aggregator.aggregate((Object)entity.getEmployee());
        aggregator.aggregate((Enum)entity.getType());
        aggregator.aggregate((Iterable)entity.getTypes());
        aggregator.aggregate((Object)entity.getAgency());
        aggregator.aggregate((Object)entity.getSalesPoint());
        aggregator.aggregate((Object)entity.getCashRegister());
        aggregator.aggregate((Object)entity.getCashRegisterWorkplace());
    }
}

