/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.index.registry;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndexData;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Payment;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationGdsNameInfo;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndex;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AeroexpressTicketHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BalanceHelper;
import com.gridnine.xtrip.common.model.helpers.BookingFileHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.ExternalSystemCodeV2;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import com.gridnine.xtrip.server.model.index.registry.IndexRegistryHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookingFileIndexRegistryHandler
implements IndexRegistryHandler<BookingFile, BookingFileIndexData> {
    private static final Logger log = LoggerFactory.getLogger(BookingFileIndexRegistryHandler.class);

    public double getPriority() {
        return 0.0;
    }

    @Override
    public void updateData(EntityContainer<BookingFile> bookingFileContainer, BookingFileIndexData indexData, DataAggregator aggregatorData) {
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        String fullNumber = TextUtil.buildFullNumber((CompositeNumber)bookingFile);
        indexData.setFullNumber(fullNumber);
        aggregatorData.aggregate((Object)fullNumber);
        String numberPrefix = bookingFile.getNumberPrefix();
        indexData.setNumberPrefix(numberPrefix);
        aggregatorData.aggregate((Object)numberPrefix);
        String numberSuffix = bookingFile.getNumberSuffix();
        indexData.setNumberSuffix(numberSuffix);
        aggregatorData.aggregate((Object)numberSuffix);
        Date createDate = bookingFile.getCreateDate();
        indexData.setCreateDate(createDate);
        indexData.setDateOfBooking(createDate);
        aggregatorData.aggregate(createDate);
        String customerName = Optional.ofNullable(bookingFile.getCustomer()).map(Customer::getName).orElse(null);
        indexData.setCustomerName(customerName);
        aggregatorData.aggregate((Object)customerName);
        indexData.setFailedCancelling(Boolean.valueOf(bookingFile.isFailedCancelling()));
        Traveller firstTraveller = (Traveller)CollectionUtil.head((Iterable)bookingFile.getTravellers());
        String firstTravellerFIO = this.travellerFIO(firstTraveller);
        indexData.setFirstTraveller(firstTravellerFIO);
        aggregatorData.aggregate((Object)firstTravellerFIO);
        int travellerSize = bookingFile.getTravellers().size();
        indexData.setTravellersCount(travellerSize);
        aggregatorData.aggregate((Object)travellerSize);
        Collection<String> travellerFIOs = this.travellerFIOs(bookingFile);
        indexData.setTravellers(travellerFIOs);
        aggregatorData.aggregate(travellerFIOs);
        List<BaseProduct> products = this.getProducts(bookingFile);
        Date firstTravelDate = this.getFirstTravelDate(products);
        indexData.setFirstTravelDate(firstTravelDate);
        Date lastTravelDate = this.getLastTravelDate(products);
        indexData.setLastTravelDate(lastTravelDate);
        Set<String> bookingVendor = this.getBookingVendor(products);
        indexData.setBookingVendor(bookingVendor);
        BigDecimal totalPrice = BookingHelper.getTotalPrice((BookingFile)bookingFile, (ContractType)ContractType.CLIENT);
        indexData.setTotalPrice(totalPrice);
        indexData.setHasNotes(Boolean.valueOf(bookingFile.getNotes() != null && !bookingFile.getNotes().trim().isEmpty()));
        BigDecimal payedSum = BigDecimal.ZERO;
        try {
            payedSum = this.getPayedSum(bookingFileContainer);
        }
        catch (Exception exc) {
            LoggerFactory.getLogger(this.getClass()).error("unable to calculate payed sum", (Throwable)exc);
        }
        indexData.setPayedSum(payedSum);
        indexData.setSumToPay(totalPrice.subtract(payedSum));
        Date issueDate = this.getIssueDate(bookingFile);
        indexData.setIssueDate(issueDate);
        indexData.setAgency(bookingFile.getAgency());
        indexData.setSubagency(BookingHelper.getSubagency((BookingFile)bookingFile));
        PaymentType fopType = this.findFopType(bookingFile.getPayments(), products);
        if (fopType != null) {
            indexData.setFopTypeCode(fopType);
        }
        Set<String> recordLocators = this.getRecordLocators(bookingFile);
        indexData.setRecordLocators(recordLocators);
        indexData.setDisplayedRecordLocators(this.getDisplayedRecordLocators(bookingFile));
        indexData.setRulesGdsNames(this.getRulesGdsNames(bookingFile));
        EntityReference salesPoint = BookingHelper.getSalesPoint((BookingFile)bookingFile);
        indexData.setSalesPoint(salesPoint);
        Set<GdsName> gdsNames = this.getGdsNames(bookingFile);
        indexData.setGdsNames(gdsNames);
        indexData.setCustomerProfile(bookingFile.getCustomer() == null ? null : bookingFile.getCustomer().getProfile());
        Date timeLimit = this.getTimeLimit(bookingFile);
        indexData.setTimelimit(timeLimit);
        aggregatorData.aggregate(firstTravelDate);
        aggregatorData.aggregate(bookingVendor);
        aggregatorData.aggregate((Object)totalPrice);
        aggregatorData.aggregate((Object)payedSum);
        aggregatorData.aggregate(issueDate);
        aggregatorData.aggregate((Object)bookingFile.getAgency());
        aggregatorData.aggregate(recordLocators);
        aggregatorData.aggregate((Object)salesPoint);
        aggregatorData.aggregate(gdsNames);
        HashSet<TravelSubject> travelSubjects = new HashSet<TravelSubject>();
        HashSet<TravelSubject> travelSubjectExceptCorrection = new HashSet<TravelSubject>();
        HashSet ticketNumbers = new HashSet();
        HashSet<ProductStatus> productStatuses = new HashSet<ProductStatus>();
        EntityReference agentRef = null;
        HashSet<TicketType> ticketTypes = new HashSet<TicketType>();
        for (BaseProduct prod : products) {
            ProductStatus status;
            TravelSubject ts;
            TicketType ticketType;
            ProductHandler handler = HandlersRegistry.get().findProductHandler(prod.getClass());
            if (handler == null) {
                log.error("no product handler is registered for product class " + prod.getClass().getName());
                continue;
            }
            ticketNumbers.addAll(handler.getProductNumbers(prod));
            if (agentRef == null) {
                agentRef = handler.findIssuingAgent(prod);
            }
            if (prod instanceof Product) {
                aggregatorData.aggregate((Iterable)((Product)prod).getScns());
            }
            if ((ticketType = handler.getTicketType(prod)) != null) {
                ticketTypes.add(ticketType);
            }
            if ((ts = handler.findTravelSubject(prod)) != null) {
                travelSubjects.add(ts);
                if (ticketType != TicketType.CORRECTION) {
                    travelSubjectExceptCorrection.add(ts);
                }
            }
            if ((status = handler.getStatus(prod)) != null) {
                productStatuses.add(status);
            }
            if (!(prod instanceof Transfer)) continue;
            aggregatorData.aggregate((Object)((Transfer)prod).getIwayBookerNumber());
        }
        indexData.setAgent(agentRef);
        aggregatorData.aggregate((Object)this.agentFio(agentRef));
        indexData.setTicketNumbers(ticketNumbers);
        aggregatorData.aggregate(ticketNumbers);
        indexData.setTravelSubject(travelSubjects);
        indexData.setTravelSubjectExceptCorrection(travelSubjectExceptCorrection);
        indexData.setProductStatuses(productStatuses);
        indexData.setTicketTypes(ticketTypes);
        aggregatorData.aggregate(travelSubjects);
        aggregatorData.aggregate(timeLimit);
        BigDecimal agencyFee = BigDecimal.ZERO;
        BigDecimal vendorFee = BigDecimal.ZERO;
        BigDecimal clientFee = BigDecimal.ZERO;
        BigDecimal agencyCommission = BigDecimal.ZERO;
        BigDecimal vendorCommission = BigDecimal.ZERO;
        BigDecimal clientCommission = BigDecimal.ZERO;
        for (Reservation reservation : bookingFile.getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                ProductHandler handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
                if (handler == null) {
                    log.error("no product handler is registered for product class " + baseProduct.getClass().getName());
                    continue;
                }
                ProductStatus status = handler.getStatus(baseProduct);
                if (ProductStatusHandler.getAllVoidStatuses().contains(status)) continue;
                boolean negate = status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE;
                BigDecimal value = GeneralProductHelper.calculateCommissions((BaseProduct)baseProduct, (ContractType)ContractType.SUBAGENCY, Collections.singleton(FeeProperties.class));
                agencyFee = agencyFee.add(negate ? value.negate() : value);
                value = GeneralProductHelper.calculateCommissions((BaseProduct)baseProduct, (ContractType)ContractType.VENDOR, Collections.singleton(FeeProperties.class));
                vendorFee = vendorFee.add(negate ? value.negate() : value);
                value = GeneralProductHelper.calculateCommissions((BaseProduct)baseProduct, (ContractType)ContractType.CLIENT, Collections.singleton(FeeProperties.class));
                clientFee = clientFee.add(negate ? value.negate() : value);
                value = GeneralProductHelper.calculateCommissions((BaseProduct)baseProduct, (ContractType)ContractType.CLIENT, Collections.singleton(PaymentFeeProperties.class));
                clientFee = clientFee.add(negate ? value.negate() : value);
                value = GeneralProductHelper.calculateCommissions((BaseProduct)baseProduct, (ContractType)ContractType.SUBAGENCY, Collections.singleton(CommissionProperties.class));
                agencyCommission = agencyCommission.add(negate ? value.negate() : value);
                value = GeneralProductHelper.calculateCommissions((BaseProduct)baseProduct, (ContractType)ContractType.VENDOR, Collections.singleton(CommissionProperties.class));
                vendorCommission = vendorCommission.add(negate ? value.negate() : value);
                value = GeneralProductHelper.calculateCommissions((BaseProduct)baseProduct, (ContractType)ContractType.CLIENT, Collections.singleton(CommissionProperties.class));
                clientCommission = clientCommission.add(negate ? value.negate() : value);
            }
        }
        indexData.setTotalSubagencyFee(agencyFee);
        indexData.setTotalVendorFee(vendorFee);
        indexData.setTotalClientFee(clientFee);
        indexData.setTotalSubagencyCommission(agencyCommission);
        indexData.setTotalVendorCommission(vendorCommission);
        indexData.setTotalClientCommission(clientCommission);
        aggregatorData.aggregate((Object)agencyFee);
        aggregatorData.aggregate((Object)vendorFee);
        aggregatorData.aggregate((Object)clientFee);
        aggregatorData.aggregate((Object)agencyCommission);
        aggregatorData.aggregate((Object)vendorCommission);
        aggregatorData.aggregate((Object)clientCommission);
        indexData.setClient(bookingFile.getCustomerProfile());
        indexData.setSubagencies(this.getBookingFileSubagencies(bookingFile));
        aggregatorData.aggregate((Object)bookingFile.getCustomerProfile());
        EntityContainer clientContainer = EntityStorage.get().resolve(bookingFile.getCustomerProfile());
        if (clientContainer != null) {
            indexData.setHolding(((Organization)clientContainer.getEntity()).getHolding());
            aggregatorData.aggregate((Object)((Organization)clientContainer.getEntity()).getHolding());
        }
        indexData.setWorkflowStatus(bookingFile.getWorkflowStatus());
        aggregatorData.aggregate((Enum)bookingFile.getWorkflowStatus());
        indexData.setMaxIssueDate(BookingFileHelper.getMaxIssueDate((BookingFile)bookingFile));
        indexData.setProductsCount(Integer.valueOf(BookingFileHelper.getProductsCount((BookingFile)bookingFile)));
        List externalCodes = bookingFile.getExternalCodes().stream().map(ExternalSystemCodeV2::getCode).filter(TextUtil::nonBlank).collect(Collectors.toList());
        indexData.setExternalCodes(externalCodes);
        aggregatorData.aggregate(externalCodes);
        ArrayList vendorContractNumbers = new ArrayList();
        ArrayList clientContractNumbers = new ArrayList();
        products.stream().map(GeneralProductHelper::getUnmodifiableContractRelations).flatMap(Collection::stream).map(GeneralProductHelper::getContract).filter(Optional::isPresent).map(Optional::get).forEach(contract -> {
            if (contract.getContractType() == ContractType.VENDOR) {
                vendorContractNumbers.add(contract.getNumber());
            }
            if (contract.getContractType() == ContractType.CLIENT) {
                clientContractNumbers.add(contract.getNumber());
            }
        });
        indexData.setVendorContractNumbers(vendorContractNumbers);
        indexData.setClientContractNumbers(clientContractNumbers);
    }

    protected String agentFio(EntityReference<Person> personRef) {
        return Optional.ofNullable(personRef).map(Object::toString).orElse(null);
    }

    private PaymentType findFopType(List<Payment> payments, List<BaseProduct> products) {
        for (Payment payment : payments) {
            if (payment.isCanceled() || payment.getFop() == null || payment.getFop().getType() == null) continue;
            return payment.getFop().getType();
        }
        for (BaseProduct bp : products) {
            Product prod;
            if (bp instanceof Product) {
                prod = (Product)bp;
                for (ProductFop fop : AirProductHelper.getVendorContractRelation((Product)prod).getFops()) {
                    if (fop.getType() == null) continue;
                    return fop.getType();
                }
                for (ProductFop fop : AirProductHelper.getClientContractRelation((Product)prod).getFops()) {
                    if (fop.getType() == null) continue;
                    return fop.getType();
                }
                continue;
            }
            if (!(bp instanceof AeroexpressTicket)) continue;
            prod = (AeroexpressTicket)bp;
            for (ProductFop fop : AeroexpressTicketHelper.getClientFops((AeroexpressTicket)prod)) {
                if (fop.getType() == null) continue;
                return fop.getType();
            }
            for (ProductFop fop : AeroexpressTicketHelper.getSubagentFops((AeroexpressTicket)prod, (boolean)false)) {
                if (fop.getType() == null) continue;
                return fop.getType();
            }
            for (ProductFop fop : AeroexpressTicketHelper.getVendorFops((AeroexpressTicket)prod)) {
                if (fop.getType() == null) continue;
                return fop.getType();
            }
        }
        return null;
    }

    private Date getTimeLimit(BookingFile bf) {
        Date result = null;
        for (Reservation reservation : bf.getReservations()) {
            if (result != null && (reservation.getTimeLimit() == null || !result.after(reservation.getTimeLimit()))) continue;
            result = reservation.getTimeLimit();
        }
        return result;
    }

    private Collection<String> travellerFIOs(BookingFile bookingFile) {
        return bookingFile.getTravellers().stream().filter(Objects::nonNull).map(this::travellerFIO).filter(TextUtil::nonBlank).collect(Collectors.toSet());
    }

    protected Set<GdsName> getGdsNames(BookingFile bf) {
        HashSet<GdsName> gdss = new HashSet<GdsName>();
        for (Reservation reservation : bf.getReservations()) {
            gdss.addAll(IndexBuilderHelper.getGdsNames(reservation));
        }
        return gdss;
    }

    protected Set<String> getRecordLocators(BookingFile bf) {
        HashSet<String> pnrs = new HashSet<String>();
        for (Reservation reservation : bf.getReservations()) {
            pnrs.addAll(IndexBuilderHelper.getRecordLocators(reservation));
        }
        return pnrs;
    }

    protected Set<String> getDisplayedRecordLocators(BookingFile bf) {
        return bf.getReservations().stream().map(CommonReservationGdsNameInfoHelper::getDisplayedRecordLocator).collect(Collectors.toSet());
    }

    protected Set<GdsName> getRulesGdsNames(BookingFile bf) {
        return bf.getReservations().stream().map(Reservation::getGdsNameInfo).map(ReservationGdsNameInfo::getRulesGdsName).collect(Collectors.toSet());
    }

    protected Date getIssueDate(BookingFile bf) {
        Date result = null;
        for (Reservation reservation : bf.getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                ProductHandler handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
                if (handler == null) {
                    log.error("no product handler is registered for product class " + baseProduct.getClass().getName());
                    continue;
                }
                Date date = handler.findIssueDate(baseProduct);
                if (MiscUtil.compare((Date)date, result, (boolean)false) != -1) continue;
                result = date;
            }
        }
        return result;
    }

    protected BigDecimal getPayedSum(EntityContainer<BookingFile> etc) {
        BigDecimal payedSum = BigDecimal.ZERO;
        payedSum = MiscUtil.sum((BigDecimal[])new BigDecimal[]{payedSum, BalanceHelper.calculateTransactions((EntityReference)((BookingFile)etc.getEntity()).getCustomerProfile(), null, null, null, (ChartOfAccountsElementType)ChartOfAccountsElementType.SUPPLIER, (DictionaryReference)new CurrencyInfoReference(DictHelper.getLocalCurrencyCode()), Collections.emptyMap(), Collections.singletonList(SearchCriterion.eq((String)TransactionSplitIndex.Property.bookingUid.name(), (Object)etc.getUid())), (boolean)false)});
        return payedSum;
    }

    protected Set<String> getBookingVendor(List<BaseProduct> products) {
        HashSet<String> setCarrierNumber = new HashSet<String>();
        for (BaseProduct product : products) {
            String carrierNumber;
            if (!(product instanceof Product) || (carrierNumber = ((Product)product).getCarrierNumber()) == null) continue;
            setCarrierNumber.add(carrierNumber);
        }
        return setCarrierNumber;
    }

    protected List<BaseProduct> getProducts(BookingFile bookingFile) {
        ArrayList<BaseProduct> allProducts = new ArrayList<BaseProduct>();
        for (Reservation res : bookingFile.getReservations()) {
            allProducts.addAll(res.getProducts());
        }
        return allProducts;
    }

    protected Date getFirstTravelDate(List<BaseProduct> products) {
        Date firstTravelDate = null;
        for (BaseProduct product : products) {
            ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
            if (handler == null) {
                log.error("no product handler is registered for product class " + product.getClass().getName());
                continue;
            }
            Date date = handler.findFirstTravelDate(product);
            if (MiscUtil.compare((Date)date, firstTravelDate, (boolean)false) != -1) continue;
            firstTravelDate = date;
        }
        return firstTravelDate;
    }

    private Date getLastTravelDate(List<BaseProduct> products) {
        Date lastTravelDate = null;
        for (BaseProduct product : products) {
            ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
            if (handler == null) {
                log.error("no product handler is registered for product class " + product.getClass().getName());
                continue;
            }
            Date date = handler.findLastTravelDate(product);
            if (MiscUtil.compare((Date)date, lastTravelDate, (boolean)true) != 1) continue;
            lastTravelDate = date;
        }
        return lastTravelDate;
    }

    protected String travellerFIO(Traveller traveller) {
        return Optional.ofNullable(traveller).map(Traveller::getName).orElse(null);
    }

    private Collection<EntityReference<Organization>> getBookingFileSubagencies(BookingFile bookingFile) {
        return bookingFile.getReservations().stream().filter(Objects::nonNull).map(Reservation::getSubagency).filter(Objects::nonNull).collect(Collectors.toSet());
    }
}

