/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceCategory;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProductIndex;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AdditionalServiceProductHelper;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumberHelper;

public class AdditionalServiceProductInterceptor
implements EntityInterceptor {
    public static final double PRIORITY = 2.03;

    public double getPriority() {
        return 2.03;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!BookingFile.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        EntityContainer<?> bookingFileContainer = data;
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        for (Reservation res : bookingFile.getReservations()) {
            for (BaseProduct prod : res.getProducts()) {
                if (!(prod instanceof AdditionalServiceProduct)) continue;
                AdditionalServiceProduct product = (AdditionalServiceProduct)prod;
                this.updateProduct(product);
            }
        }
    }

    private void updateProduct(AdditionalServiceProduct product) throws Exception {
        if (product.getStatus() == null) {
            product.setStatus(ProductStatus.SELL);
        }
        if (product.getCategory() == AdditionalServiceCategory.CERTIFICATE_OF_COMPLETED_FLIGHT && product.getTicketType() == null) {
            product.setTicketType(TicketType.REFERRAL);
        }
        if (product.getLocalIssueDate() == null) {
            product.setLocalIssueDate(product.getIssueDate());
        }
        this.updateSupplier(product);
        if (TextUtil.isBlank((String)product.getSystemNumber())) {
            do {
                product.setSystemNumber(null);
                this.updateSystemNumber(product);
            } while (this.isSystemNumberExists(product));
        }
    }

    private void updateSupplier(AdditionalServiceProduct product) {
        if (AdditionalServiceProductHelper.getSupplier((AdditionalServiceProduct)product) == null) {
            EntityReference agencyRef = AdditionalServiceProductHelper.getAgency((AdditionalServiceProduct)product);
            if (agencyRef == null) {
                agencyRef = product.getReservation().getBookingFile().getAgency();
            }
            AdditionalServiceProductHelper.setSupplier((AdditionalServiceProduct)product, (EntityReference)agencyRef);
            if (AdditionalServiceProductHelper.getSubagency((AdditionalServiceProduct)product) == null) {
                AdditionalServiceProductHelper.setSubagency((AdditionalServiceProduct)product, (EntityReference)agencyRef);
            }
        }
    }

    private boolean isSystemNumberExists(AdditionalServiceProduct product) {
        SearchQuery query = new SearchQuery();
        query.setResultMode(ResultMode.COUNT_ONLY);
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AdditionalServiceProductIndex.Property.category.name(), (Object)product.getCategory()));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AdditionalServiceProductIndex.Property.systemNumber.name(), (Object)product.getSystemNumber()));
        return EntityStorage.get().search(AdditionalServiceProductIndex.class, query).getTotalCount() > 0;
    }

    private void updateSystemNumber(final AdditionalServiceProduct product) throws Exception {
        SequenceNumberHelper.get().generateInc(new CompositeNumber(){

            public void setNumberSuffix(String value) {
            }

            public void setNumberPrefix(String value) {
            }

            public void setNumber(String value) {
                product.setSystemNumber(value);
            }

            public String getNumberSuffix() {
                return null;
            }

            public String getNumberPrefix() {
                return null;
            }

            public String getNumber() {
                return product.getSystemNumber();
            }
        }, String.format("additional_service_product.%s", product.getCategory().name()), null);
    }
}

