/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageActualizeParameters;
import com.gridnine.xtrip.common.model.helpers.AeroexpressTicketHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.VatValue;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.model.interceptors.ProductsHelper;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.LoggerFactory;

public class AeroexpressTicketInterceptor
implements EntityInterceptor {
    public double getPriority() {
        return 2.01;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!BookingFile.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        EntityContainer<?> bookingFileContainer = data;
        EntityContainer oldBookingFileContainer = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        for (Reservation res : bookingFile.getReservations()) {
            for (BaseProduct prod : res.getProducts()) {
                if (!(prod instanceof AeroexpressTicket)) continue;
                AeroexpressTicket product = (AeroexpressTicket)prod;
                boolean isNewProduct = ProductsHelper.isNewProduct((EntityContainer<BookingFile>)oldBookingFileContainer, (BaseProduct)product);
                this.updateProduct(product, isNewProduct);
            }
        }
    }

    private void updateProduct(AeroexpressTicket product, boolean isNewProduct) throws Exception {
        this.updateBlankOwnerAndSupplier(product);
        this.updateBranch(product);
        this.updateVat(product);
        if (product.getStatus() == null) {
            product.setStatus(ProductStatus.SELL);
        }
        if (product.getLocalIssueDate() == null) {
            product.setLocalIssueDate(product.getIssueDate());
        }
        if (isNewProduct) {
            this.updateFops(product);
        }
        this.updateScnAndEticketFlag(product);
    }

    private void updateVat(AeroexpressTicket product) {
        if (product.getEquivalentFareVatValue() == null) {
            VatValue vatValue = new VatValue();
            vatValue.setRate(Double.valueOf(0.0));
            vatValue.setAmount(BigDecimal.ZERO);
            product.setEquivalentFareVatValue(vatValue);
            product.setPenaltyVatValue(new VatValue());
        }
    }

    private void updateScnAndEticketFlag(final AeroexpressTicket product) {
        ProductsHelper.updateScnAndEticketFlag(new ProductsHelper.BlankTypeHandler(){

            @Override
            public void setEticket(boolean value) {
                product.setEticket(value);
            }

            @Override
            public String getSystemNumber() {
                return product.getSystemNumber();
            }

            @Override
            public int getConjunctionsCount() {
                return 0;
            }

            @Override
            public DictionaryReference<BlankType> getBlankType() {
                return product.getBlankType();
            }

            @Override
            public void clearSCN() {
                product.setScn(null);
            }

            @Override
            public void addSCN(String value) {
                product.setScn(value);
            }
        });
    }

    private void updateBlankOwnerAndSupplier(AeroexpressTicket ticket) throws Exception {
        EntityReference supplier = AeroexpressTicketHelper.getSupplier((AeroexpressTicket)ticket);
        if (supplier != null && ticket.getBlankOwner() != null) {
            return;
        }
        String uid = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.AEROEXPRESS_PROFILE_UID, null);
        if (uid == null) {
            return;
        }
        EntityReference org = new EntityReference(uid, Organization.class, null);
        EntityStorage.get().actualize(org, new EntityStorageActualizeParameters().useRemoteCallIfNecessary(true));
        if (supplier == null) {
            AeroexpressTicketHelper.setSupplier((AeroexpressTicket)ticket, (EntityReference)org);
        }
        if (ticket.getBlankOwner() == null) {
            ticket.setBlankOwner(org);
        }
    }

    private void updateBranch(AeroexpressTicket product) throws Exception {
        if (product.getBranch() != null) {
            return;
        }
        EntityContainer salesPointContainer = EntityStorage.get().resolve(product.getSalesPoint());
        if (salesPointContainer != null) {
            product.setBranch(((SalesPoint)salesPointContainer.getEntity()).getBranch());
        }
    }

    private void updateFops(AeroexpressTicket product) {
        List contractRelations = AeroexpressTicketHelper.getContractRelations((AeroexpressTicket)product);
        EntityReference salesPointRef = product.getSalesPoint();
        Date operationDate = product.getIssueDate();
        EntityReference<Person> agent = product.getAgent();
        if (agent == null) {
            try {
                agent = ProfileDao.findCurrentAgent(null);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("unable to find current agent", (Throwable)e);
            }
        }
        operationDate = null;
        agent = null;
        ProductsHelper.updateFops(contractRelations, (EntityReference<SalesPoint>)salesPointRef, operationDate, agent);
    }
}

