/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.Callback;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import java.io.Serializable;
import java.util.Optional;

public class AgencyMemoProductInterceptor
implements EntityInterceptor {
    public double getPriority() {
        return 2.147483645E9;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!BookingFile.class.equals((Object)data.getEntityType())) {
            return;
        }
        EntityContainer<?> bookingFile = data;
        EntityContainer oldBookingFile = LogicalStorage.get().getEntityStorage().getGlobalOperationContext().getOldCtr();
        ss.addCallback((Callback & Serializable)callback -> {
            for (AgencyMemoProduct product : BookingHelper.getProductsList((BookingFile)((BookingFile)bookingFile.getEntity()), AgencyMemoProduct.class)) {
                this.removeAgencyMemoProductLink((EntityContainer<BookingFile>)bookingFile, product, (NestedEntityReference<BookingFile, AgencyMemoProduct>)product.getCustomerAgencyMemo());
                this.removeAgencyMemoProductLink((EntityContainer<BookingFile>)bookingFile, product, (NestedEntityReference<BookingFile, AgencyMemoProduct>)product.getSupplierAgencyMemo());
            }
            this.clearOldLinks((EntityContainer<BookingFile>)bookingFile, (EntityContainer<BookingFile>)oldBookingFile);
        });
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!BookingFile.class.equals((Object)data.getEntityType())) {
            return;
        }
        EntityContainer<?> bookingFile = data;
        EntityContainer oldBookingFile = LogicalStorage.get().getEntityStorage().getGlobalOperationContext().getOldCtr();
        ss.addCallback((Callback & Serializable)callback -> {
            for (AgencyMemoProduct product : BookingHelper.getProductsList((BookingFile)((BookingFile)bookingFile.getEntity()), AgencyMemoProduct.class)) {
                AgencyMemoProduct oldProduct;
                AgencyMemoProduct agencyMemoProduct = oldProduct = oldBookingFile == null ? null : (AgencyMemoProduct)BookingHelper.findProduct((BookingFile)((BookingFile)oldBookingFile.getEntity()), (String)product.getUid(), AgencyMemoProduct.class);
                if (oldProduct == null) {
                    if (product.getCustomerAgencyMemo() != null) {
                        this.setSupplierLink((EntityContainer<BookingFile>)bookingFile, product, (NestedEntityReference<BookingFile, AgencyMemoProduct>)product.getCustomerAgencyMemo());
                    }
                    if (product.getSupplierAgencyMemo() == null) continue;
                    this.setCustomerLink((EntityContainer<BookingFile>)bookingFile, product, (NestedEntityReference<BookingFile, AgencyMemoProduct>)product.getSupplierAgencyMemo());
                    continue;
                }
                if (product.getCustomerAgencyMemo() != null && !product.getCustomerAgencyMemo().equals((Object)oldProduct.getCustomerAgencyMemo())) {
                    this.setSupplierLink((EntityContainer<BookingFile>)bookingFile, product, (NestedEntityReference<BookingFile, AgencyMemoProduct>)product.getCustomerAgencyMemo());
                }
                if (product.getSupplierAgencyMemo() == null || product.getSupplierAgencyMemo().equals((Object)oldProduct.getSupplierAgencyMemo())) continue;
                this.setCustomerLink((EntityContainer<BookingFile>)bookingFile, product, (NestedEntityReference<BookingFile, AgencyMemoProduct>)product.getSupplierAgencyMemo());
            }
            this.clearOldLinks((EntityContainer<BookingFile>)bookingFile, (EntityContainer<BookingFile>)oldBookingFile);
        });
        for (Reservation res : ((BookingFile)bookingFile.getEntity()).getReservations()) {
            for (BaseProduct baseProduct : res.getProducts()) {
                if (!(baseProduct instanceof AgencyMemoProduct)) continue;
                AgencyMemoProduct product = (AgencyMemoProduct)baseProduct;
                product.setPaymentCurrency(Optional.ofNullable(EntityStorage.get().resolve((EntityReference)product.getContract())).map(item -> ((Contract)item.getEntity()).getPaymentCurrency()).orElse(DictHelper.getLocalCurrency()));
                if (product.getLocalIssueDate() != null) continue;
                product.setLocalIssueDate(product.getIssueDate());
            }
        }
    }

    private void setCustomerLink(EntityContainer<BookingFile> bookingFile, AgencyMemoProduct product, NestedEntityReference<BookingFile, AgencyMemoProduct> reference) {
        NestedEntityReference productReference = new NestedEntityReference(bookingFile, (BaseEntity)product, product.getSystemNumber());
        if (bookingFile.getUid().equals(reference.getUid())) {
            AgencyMemoProduct relatedProduct = (AgencyMemoProduct)BookingHelper.findProduct((BookingFile)((BookingFile)bookingFile.getEntity()), (String)reference.getNestedEntityUid(), AgencyMemoProduct.class);
            if (relatedProduct != null) {
                relatedProduct.setCustomerAgencyMemo(productReference);
            }
        } else {
            MiscUtil.Pair relatedProductPair = EntityStorageHelper.resolveDetailed(reference);
            if (relatedProductPair == null) {
                return;
            }
            EntityContainer relatedBookingFile = (EntityContainer)relatedProductPair.getFirst();
            AgencyMemoProduct relatedProduct = (AgencyMemoProduct)relatedProductPair.getSecond();
            if (!productReference.equals((Object)relatedProduct.getCustomerAgencyMemo())) {
                relatedProduct.setCustomerAgencyMemo(productReference);
                relatedBookingFile.getVersionInfo().setDataSource("agency-memo-product-interceptor");
                EntityStorage.get().save(relatedBookingFile, true);
            }
        }
    }

    private void setSupplierLink(EntityContainer<BookingFile> bookingFile, AgencyMemoProduct product, NestedEntityReference<BookingFile, AgencyMemoProduct> reference) {
        NestedEntityReference productReference = new NestedEntityReference(bookingFile, (BaseEntity)product, product.getSystemNumber());
        if (bookingFile.getUid().equals(reference.getUid())) {
            AgencyMemoProduct relatedProduct = (AgencyMemoProduct)BookingHelper.findProduct((BookingFile)((BookingFile)bookingFile.getEntity()), (String)reference.getNestedEntityUid(), AgencyMemoProduct.class);
            if (relatedProduct != null) {
                relatedProduct.setSupplierAgencyMemo(productReference);
            }
        } else {
            MiscUtil.Pair relatedProductPair = EntityStorageHelper.resolveDetailed(reference);
            if (relatedProductPair == null) {
                return;
            }
            EntityContainer relatedBookingFile = (EntityContainer)relatedProductPair.getFirst();
            AgencyMemoProduct relatedProduct = (AgencyMemoProduct)relatedProductPair.getSecond();
            if (!productReference.equals((Object)relatedProduct.getSupplierAgencyMemo())) {
                relatedProduct.setSupplierAgencyMemo(new NestedEntityReference(bookingFile, (BaseEntity)product, product.getSystemNumber()));
                relatedBookingFile.getVersionInfo().setDataSource("agency-memo-product-interceptor");
                EntityStorage.get().save(relatedBookingFile, true);
            }
        }
    }

    private void clearOldLinks(EntityContainer<BookingFile> bookingFile, EntityContainer<BookingFile> oldBookingFile) {
        if (oldBookingFile == null) {
            return;
        }
        for (AgencyMemoProduct oldProduct : BookingHelper.getProductsList((BookingFile)((BookingFile)oldBookingFile.getEntity()), AgencyMemoProduct.class)) {
            AgencyMemoProduct product = (AgencyMemoProduct)BookingHelper.findProduct((BookingFile)((BookingFile)bookingFile.getEntity()), (String)oldProduct.getUid(), AgencyMemoProduct.class);
            if (product == null) {
                this.removeAgencyMemoProductLink(bookingFile, oldProduct, (NestedEntityReference<BookingFile, AgencyMemoProduct>)oldProduct.getCustomerAgencyMemo());
                this.removeAgencyMemoProductLink(bookingFile, oldProduct, (NestedEntityReference<BookingFile, AgencyMemoProduct>)oldProduct.getSupplierAgencyMemo());
                continue;
            }
            if (oldProduct.getCustomerAgencyMemo() != null && !oldProduct.getCustomerAgencyMemo().equals((Object)product.getCustomerAgencyMemo())) {
                this.removeAgencyMemoProductLink(bookingFile, oldProduct, (NestedEntityReference<BookingFile, AgencyMemoProduct>)oldProduct.getCustomerAgencyMemo());
            }
            if (oldProduct.getSupplierAgencyMemo() == null || oldProduct.getSupplierAgencyMemo().equals((Object)product.getSupplierAgencyMemo())) continue;
            this.removeAgencyMemoProductLink(bookingFile, oldProduct, (NestedEntityReference<BookingFile, AgencyMemoProduct>)oldProduct.getSupplierAgencyMemo());
        }
    }

    private void removeAgencyMemoProductLink(EntityContainer<BookingFile> bookingFile, AgencyMemoProduct product, NestedEntityReference<BookingFile, AgencyMemoProduct> reference) {
        if (reference == null) {
            return;
        }
        if (bookingFile.getUid().equals(reference.getUid())) {
            AgencyMemoProduct relatedProduct = (AgencyMemoProduct)BookingHelper.findProduct((BookingFile)((BookingFile)bookingFile.getEntity()), (String)reference.getNestedEntityUid(), AgencyMemoProduct.class);
            if (relatedProduct != null) {
                this.clearLinksInProduct(relatedProduct, product);
            }
        } else {
            MiscUtil.Pair relatedProductPair = EntityStorageHelper.resolveDetailed(reference);
            if (relatedProductPair == null) {
                return;
            }
            EntityContainer relatedBookingFile = (EntityContainer)relatedProductPair.getFirst();
            AgencyMemoProduct relatedProduct = (AgencyMemoProduct)relatedProductPair.getSecond();
            boolean changed = this.clearLinksInProduct(relatedProduct, product);
            if (changed) {
                relatedBookingFile.getVersionInfo().setDataSource("agency-memo-product-interceptor");
                EntityStorage.get().save(relatedBookingFile, true);
            }
        }
    }

    private boolean clearLinksInProduct(AgencyMemoProduct product, AgencyMemoProduct relatedProduct) {
        boolean changed = false;
        if (product.getCustomerAgencyMemo() != null && relatedProduct.getUid().equals(product.getCustomerAgencyMemo().getNestedEntityUid())) {
            product.setCustomerAgencyMemo(null);
            changed = true;
        }
        if (product.getSupplierAgencyMemo() != null && relatedProduct.getUid().equals(product.getSupplierAgencyMemo().getNestedEntityUid())) {
            product.setSupplierAgencyMemo(null);
            changed = true;
        }
        return changed;
    }
}

