/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.incidents.IncidentsContext;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.model.handlers.rules.TchSpecialSchemeVirtualizationHelper;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.model.helpers.vat.air.AirProductVatCalculator;
import com.gridnine.xtrip.server.model.interceptors.ProductsHelper;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Function;
import org.slf4j.LoggerFactory;

public class AirProductInterceptor
implements EntityInterceptor {
    public static final double priority = 2.0;

    public double getPriority() {
        return 2.0;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!BookingFile.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        EntityContainer<?> bookingFileContainer = data;
        EntityContainer oldBookingFileContainer = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        for (Reservation res : bookingFile.getReservations()) {
            for (BaseProduct prod : res.getProducts()) {
                if (!(prod instanceof Product)) continue;
                Product product = (Product)prod;
                if (product.getConjCount() < 0 || product.getConjCount() > 9) {
                    throw Xeption.forEndUser((String)Messages.IncorrectRelatedTicketsCount, (Object[])new Object[0]);
                }
                boolean isNewProduct = ProductsHelper.isNewProduct((EntityContainer<BookingFile>)oldBookingFileContainer, (BaseProduct)product);
                this.updateProduct(product, isNewProduct);
                Product oldProduct = this.getOldProduct((EntityContainer<BookingFile>)oldBookingFileContainer, product);
                this.updateSegmentCityCodes(product, oldProduct);
                this.updateFlightDurations(product);
                this.updateCodeShare(product);
            }
        }
    }

    private void checkSalesOriginProviderAndContent(Product product) {
        String exceptionMessage;
        StringJoiner joiner = new StringJoiner(" and ", "", " is missing");
        joiner.setEmptyValue("");
        if (product.getSalesOriginProvider() == null) {
            joiner.add("SalesOriginProvider");
        }
        if (product.getSalesOriginContent() == null) {
            joiner.add("SalesOriginContent");
        }
        if (TextUtil.nonBlank((String)(exceptionMessage = joiner.toString()))) {
            IncidentsContext.setContextValue((String)"BookingFileNumber", (String)product.getReservation().getBookingFile().getNumber());
            IncidentsContext.setContextValue((String)"ProductNumber", (String)AirProductHelper.getTicketNumber((Product)product));
            IncidentsContext.setContextValue((String)"ProductUid", (String)product.getUid());
            IncidentsLog.reportStackTrace((String)exceptionMessage);
        }
    }

    private void updateFlightDurations(Product product) {
        product.getSegmentTariffs().stream().flatMap(it -> it.getSegments().stream()).forEach(seg -> {
            Long endTime;
            Long startTime;
            if ((seg.getFlightDuration() == null || seg.getFlightDuration() > Short.MAX_VALUE) && seg.getStartDate() != null && seg.getEndDate() != null && (startTime = this.getServerTime(seg.getStartDate(), (DictionaryReference<GeoLocation>)seg.getDepartureLocation())) != null && (endTime = this.getServerTime(seg.getEndDate(), (DictionaryReference<GeoLocation>)seg.getArriveLocation())) != null) {
                seg.setFlightDuration(Integer.valueOf((int)((endTime - startTime) / 60000L)));
            }
        });
    }

    private void updateCodeShare(Product product) {
        product.getSegmentTariffs().stream().flatMap(it -> it.getSegments().stream()).forEach(seg -> seg.setCodeShare(seg.getAirline() != null && seg.getCodeShareCarrier() != null && !MiscUtil.equals((Object)seg.getAirline(), (Object)seg.getCodeShareCarrier())));
    }

    private Long getServerTime(Date startDate, DictionaryReference<GeoLocation> departureLocation) {
        GeoLocation city = DictHelper.findCity(departureLocation);
        if (city == null || city.getTimeZoneId() == null) {
            return null;
        }
        try {
            Instant instant = Instant.ofEpochMilli(startDate.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime().atZone(ZoneId.of(city.getTimeZoneId())).toInstant();
            return instant.toEpochMilli();
        }
        catch (Exception e) {
            IncidentsLog.reportException((String)("bad timezone id " + city.getTimeZoneId()), (Throwable)e);
            return null;
        }
    }

    private void updateProduct(Product product, boolean isNewProduct) throws Exception {
        String classService;
        this.updateBranch(product);
        if (product.getStatus() == null) {
            product.setStatus(ProductStatus.SELL);
        }
        if (product.getLocalIssueDate() == null) {
            product.setLocalIssueDate(product.getIssueDate());
        }
        for (SegmentTariff segmentTariff : product.getSegmentTariffs()) {
            for (Segment segment : segmentTariff.getSegments()) {
                if (segment.getServiceClass() != null) continue;
                segment.setServiceClass(DictHelper.findClassOfService((Segment)segment, (Date)product.getIssueDate()));
            }
        }
        if (product.getStatisticalData() != null && TextUtil.isBlank((String)product.getStatisticalData().getOverallClassService()) && TextUtil.nonBlank((String)(classService = AirProductHelper.getOverallClassService((Product)product)))) {
            product.getStatisticalData().setOverallClassService(classService);
        }
        product.setServiceLocationType(AirProductHelper.getServiceLocationType((Product)product));
        this.updateTourCodeOnRefund(product);
        TchSpecialSchemeVirtualizationHelper.updateProduct(product);
        AirProductHelper.updateSegmentTariffsEquivalentFare((Product)product);
        if (isNewProduct) {
            this.updateFops(product);
        }
        AirProductVatCalculator.updateVat(product);
        this.updateScnAndEticketFlag(product);
    }

    private void updateTourCodeOnRefund(Product product) {
        Product rp;
        if (!TextUtil.isBlank((String)product.getTourCode())) {
            return;
        }
        if (product.getStatus() == ProductStatus.REFUND) {
            if (product.getPreviousProduct() != null) {
                product.setTourCode(product.getPreviousProduct().getTourCode());
            }
            return;
        }
        if (product.getProductCategory() == ProductCategory.MCO && (product.getMcoCategory() == MCOCategory.PENALTY || product.getMcoCategory() == MCOCategory.INFORMATION) && (rp = AirProductHelper.findRelatedAirProduct((Product)product, (ProductStatus)ProductStatus.REFUND, (boolean)true)) != null && rp.getPreviousProduct() != null) {
            product.setTourCode(rp.getPreviousProduct().getTourCode());
        }
    }

    private void updateBranch(Product product) {
        if (product.getBranch() != null) {
            return;
        }
        EntityContainer salesPointContainer = EntityStorage.get().resolve(product.getSalesPoint());
        if (salesPointContainer != null) {
            product.setBranch(((SalesPoint)salesPointContainer.getEntity()).getBranch());
        }
    }

    private void updateScnAndEticketFlag(final Product product) {
        ProductsHelper.updateScnAndEticketFlag(new ProductsHelper.BlankTypeHandler(){

            @Override
            public void setEticket(boolean value) {
                product.setEticket(value);
            }

            @Override
            public String getSystemNumber() {
                return product.getSystemNumber();
            }

            @Override
            public int getConjunctionsCount() {
                return product.getConjCount();
            }

            @Override
            public DictionaryReference<BlankType> getBlankType() {
                return product.getBlankType();
            }

            @Override
            public void clearSCN() {
                product.getScns().clear();
            }

            @Override
            public void addSCN(String value) {
                product.getScns().add(value);
            }
        });
    }

    private void updateFops(Product product) {
        List vendorFops = null;
        List clientFops = null;
        ArrayList<List> subagentFops = new ArrayList<List>();
        for (AirProductContractRelationData item : AirProductHelper.getContractRelations((Product)product)) {
            switch (GeneralProductHelper.getContractType((EntityReference)item.getDescription())) {
                case VENDOR: {
                    vendorFops = item.getFops();
                    break;
                }
                case CLIENT: {
                    clientFops = item.getFops();
                    break;
                }
                case SUBAGENCY: {
                    subagentFops.add(item.getFops());
                }
            }
        }
        EntityReference agent = product.getCashier();
        if (agent == null) {
            try {
                ProfileDao.findCurrentAgent(null);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("unable to find current agent", (Throwable)e);
            }
        }
        this.updateFops(clientFops, vendorFops);
        for (List sf : subagentFops) {
            this.updateFops(sf, clientFops);
        }
    }

    private void updateFops(List<ProductFop> targetFops, List<ProductFop> sourceFops) {
        if (!targetFops.isEmpty() || sourceFops.isEmpty()) {
            return;
        }
        for (ProductFop pf : sourceFops) {
            if (!AirProductHelper.isServiceFop((ProductFop)pf)) continue;
            ArrayList oldFares = new ArrayList(pf.getFares());
            ArrayList oldTaxes = new ArrayList(pf.getTaxes());
            pf.getFares().clear();
            pf.getTaxes().clear();
            try {
                ProductFop fop = (ProductFop)XCloneHelper.clone((XCloneable)pf, (boolean)true);
                fop.setOperationDate(null);
                fop.setAgent(null);
                fop.setPayer(null);
                fop.getFares().addAll(oldFares);
                fop.getTaxes().addAll(oldTaxes);
                targetFops.add(fop);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("unable to clone a fop", (Throwable)e);
            }
            pf.getFares().addAll(oldFares);
            pf.getTaxes().addAll(oldTaxes);
        }
    }

    private Product getOldProduct(EntityContainer<BookingFile> oldBookingFile, Product product) {
        if (oldBookingFile == null) {
            return null;
        }
        return ((BookingFile)oldBookingFile.getEntity()).getReservations().stream().flatMap(res -> res.getProducts().stream()).filter(prod -> prod instanceof Product).map(prod -> (Product)prod).filter(prod -> product.getUid().equals(prod.getUid())).findFirst().orElse(null);
    }

    private void updateSegmentCityCodes(Product newProduct, Product oldProduct) {
        for (Segment newSegment : AirProductHelper.getSegments((Collection)newProduct.getSegmentTariffs())) {
            Segment oldSegment;
            Segment segment = oldSegment = oldProduct != null ? (Segment)AirProductHelper.getSegments((Collection)oldProduct.getSegmentTariffs()).stream().filter(s -> s.getUid().equals(newSegment.getUid())).findFirst().orElse(null) : null;
            if (oldSegment != null) {
                String cityCode;
                if (this.isNeedReplaceCityCode(newSegment, oldSegment, Segment::getDepartureLocation, Segment::getDepartCityCode) && TextUtil.nonBlank((String)(cityCode = this.getCityCode((DictionaryReference<GeoLocation>)newSegment.getDepartureLocation(), TextUtil.containsCyrillicLetter((String)newSegment.getDepartCityCode()))))) {
                    newSegment.setDepartCityCode(cityCode);
                }
                if (!this.isNeedReplaceCityCode(newSegment, oldSegment, Segment::getArriveLocation, Segment::getArriveCityCode) || !TextUtil.nonBlank((String)(cityCode = this.getCityCode((DictionaryReference<GeoLocation>)newSegment.getArriveLocation(), TextUtil.containsCyrillicLetter((String)newSegment.getArriveCityCode()))))) continue;
                newSegment.setArriveCityCode(cityCode);
                continue;
            }
            if (TextUtil.isBlank((String)newSegment.getDepartCityCode())) {
                newSegment.setDepartCityCode(this.getCityCode((DictionaryReference<GeoLocation>)newSegment.getDepartureLocation(), false));
            }
            if (!TextUtil.isBlank((String)newSegment.getArriveCityCode())) continue;
            newSegment.setArriveCityCode(this.getCityCode((DictionaryReference<GeoLocation>)newSegment.getArriveLocation(), false));
        }
    }

    private boolean isNeedReplaceCityCode(Segment newSegment, Segment oldSegment, Function<Segment, DictionaryReference<GeoLocation>> locationGetter, Function<Segment, String> cityCodeGetter) {
        if (locationGetter.apply(newSegment) == null || locationGetter.apply(newSegment).equals(locationGetter.apply(oldSegment))) {
            return false;
        }
        return TextUtil.isBlank((String)cityCodeGetter.apply(newSegment)) || TextUtil.isSame((String)cityCodeGetter.apply(newSegment), (String)cityCodeGetter.apply(oldSegment));
    }

    private String getCityCode(DictionaryReference<GeoLocation> reference, boolean preferCrtCode) {
        GeoLocation city = DictHelper.findCity(reference);
        if (city == null) {
            return null;
        }
        if (preferCrtCode) {
            return DictHelper.getCodeVariant((BaseDictionary)city, (CodeSystem[])new CodeSystem[]{CodeSystem.CRT, CodeSystem.IATA});
        }
        return DictHelper.getCodeVariant((BaseDictionary)city, (CodeSystem[])new CodeSystem[]{CodeSystem.IATA, CodeSystem.CRT});
    }
}

