/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AirProductInterceptor3
implements EntityInterceptor {
    protected static final Logger log = LoggerFactory.getLogger(AirProductInterceptor3.class);

    public double getPriority() {
        return 5.0;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!BookingFile.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        EntityContainer<?> container = data;
        BookingFile bookingFile = (BookingFile)container.getEntity();
        for (Reservation res : bookingFile.getReservations()) {
            for (BaseProduct prod : res.getProducts()) {
                String clientContractCurrency;
                CurrencyRateType currencyRateType;
                if (!(prod instanceof Product)) continue;
                Product product = (Product)prod;
                List validationMessages = product.getValidationMessages();
                String equivalentCurrencyCode = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, null);
                if (!TextUtil.isBlank((String)equivalentCurrencyCode) && !TextUtil.isSame((String)"UAH", (String)equivalentCurrencyCode)) {
                    return;
                }
                if (TextUtil.isBlank((String)equivalentCurrencyCode)) {
                    validationMessages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.API3_CANT_DEFINE_CURRENCY_FROM_OPTIONS));
                }
                if ((currencyRateType = this.getCurrencyRateType(equivalentCurrencyCode)) == null) {
                    validationMessages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.API3_CANT_DEFINE_RATE_TYPE));
                }
                String vendorBaseFareCurrency = null;
                Money baseFare = AirProductHelper.getBaseFare((Product)product);
                if (baseFare != null) {
                    vendorBaseFareCurrency = baseFare.getCurrency();
                } else {
                    validationMessages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.API3_CANT_DEFINE_BASE_FARE_CURRENCY));
                }
                String vendorContractCurrency = DictHelper.getCurrencyByAnyCode((String)equivalentCurrencyCode);
                if (vendorContractCurrency == null) {
                    validationMessages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.API3_CANT_DEFINE_VENDOR_CURRENCY));
                }
                String vendorFopCurrency = null;
                List vendorFops = AirProductHelper.getVendorContractRelation((Product)product).getFops();
                List clientFops = AirProductHelper.getClientContractRelation((Product)product).getFops();
                for (ProductFop vendorFop : vendorFops) {
                    if (vendorFop == null) continue;
                    this.updateVendorFop(product, vendorFop, equivalentCurrencyCode, currencyRateType, vendorBaseFareCurrency, vendorContractCurrency, validationMessages);
                    if (vendorFopCurrency != null || vendorFop.getAmount() == null) continue;
                    vendorFopCurrency = vendorFop.getAmount().getCurrency();
                }
                if (vendorFopCurrency == null) {
                    validationMessages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.API3_CANT_DEFINE_VENDOR_CURRENCY));
                }
                if ((clientContractCurrency = this.getClientContractCurrency(product)) == null) {
                    validationMessages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.API3_CANT_DEFINE_CLIENT_CURRENCY));
                }
                for (ProductFop clientFop : clientFops) {
                    if (clientFop == null) continue;
                    this.updateClientFop(product, clientFop, equivalentCurrencyCode, currencyRateType, vendorFopCurrency, clientContractCurrency, validationMessages);
                }
            }
        }
    }

    private void updateVendorFop(Product product, ProductFop vendorFop, String equivalentCurrencyCode, CurrencyRateType currencyRateType, String vendorBaseFareCurrency, String vendorContractCurrency, List<ValidationMessage> validationMessages) {
        Money money = vendorFop.getPaymentAmount();
        if (money == null) {
            money = new Money();
            vendorFop.setPaymentAmount(money);
        }
        BigDecimal vendorPaymentAmount = null;
        String vendorPaymentCurrency = money.getCurrency();
        if (vendorPaymentCurrency == null) {
            vendorPaymentCurrency = vendorContractCurrency;
        }
        if (vendorFop.getAmount() != null && vendorFop.getAmount().getValue() != null) {
            vendorPaymentAmount = vendorFop.getAmount().getValue();
        }
        Double rate = null;
        if (vendorPaymentCurrency != null && currencyRateType != null) {
            if (!TextUtil.isSame((String)equivalentCurrencyCode, (String)vendorPaymentCurrency)) {
                CurrencyRate currencyRate = DictHelper.findCurrencyRate((String)vendorPaymentCurrency, (Date)product.getIssueDate(), (CurrencyRateType)currencyRateType, (TariffType)TariffType.REGULAR, (EntityReference)GeneralProductHelper.getSupplier((BaseProduct)product));
                if (currencyRate != null) {
                    rate = currencyRate.getRate();
                } else {
                    validationMessages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.API3_NO_CURRENCY_RATE_IN_DICT, (Object[])new Object[]{vendorPaymentCurrency}));
                    vendorPaymentAmount = null;
                }
            } else {
                rate = 1.0;
            }
        }
        vendorFop.setCurrencyRate(rate);
        if (rate != null) {
            vendorPaymentAmount = vendorPaymentAmount != null ? vendorPaymentAmount.divide(BigDecimal.valueOf(rate), 2, RoundingMode.HALF_UP) : null;
        }
        money.setValue(vendorPaymentAmount);
        money.setCurrency(vendorPaymentCurrency);
    }

    private void updateClientFop(Product product, ProductFop clientFop, String equivalentCurrencyCode, CurrencyRateType currencyRateType, String vendorFopCurrency, String clientContractCurrency, List<ValidationMessage> validationMessages) {
        Money money = clientFop.getPaymentAmount();
        if (money == null) {
            money = new Money();
            clientFop.setPaymentAmount(money);
        }
        BigDecimal clientPaymentAmount = null;
        String clientPaymentCurrency = money.getCurrency();
        if (clientPaymentCurrency == null) {
            clientPaymentCurrency = clientContractCurrency;
        }
        if (clientContractCurrency != null && !TextUtil.isSame((String)clientContractCurrency, (String)clientPaymentCurrency)) {
            validationMessages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.API3_CURRENCES_NOT_EQUALS, (Object[])new Object[]{clientPaymentCurrency, clientContractCurrency}));
        }
        if (clientFop.getAmount() != null && clientFop.getAmount().getValue() != null) {
            clientPaymentAmount = clientFop.getAmount().getValue();
        }
        Double rate = null;
        if (clientPaymentCurrency != null && currencyRateType != null) {
            if (!TextUtil.isSame((String)equivalentCurrencyCode, (String)clientPaymentCurrency)) {
                CurrencyRate currencyRate = DictHelper.findCurrencyRate((String)clientPaymentCurrency, (Date)product.getIssueDate(), (CurrencyRateType)currencyRateType, (TariffType)TariffType.REGULAR, (EntityReference)GeneralProductHelper.getSupplier((BaseProduct)product));
                if (currencyRate != null) {
                    rate = currencyRate.getRate();
                } else {
                    validationMessages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.API3_NO_CURRENCY_RATE_IN_DICT, (Object[])new Object[]{clientPaymentCurrency}));
                    clientPaymentAmount = null;
                }
            } else {
                rate = 1.0;
            }
        }
        clientFop.setCurrencyRate(rate);
        if (rate != null) {
            clientPaymentAmount = clientPaymentAmount != null ? clientPaymentAmount.divide(BigDecimal.valueOf(rate), 2, RoundingMode.HALF_UP) : null;
        }
        money.setValue(clientPaymentAmount);
        money.setCurrency(clientPaymentCurrency);
    }

    private CurrencyRateType getCurrencyRateType(String equivalentCurrencyCode) {
        CurrencyRateType currencyRateType = null;
        if (!TextUtil.isBlank((String)equivalentCurrencyCode)) {
            if (TextUtil.isSame((String)"RUB", (String)equivalentCurrencyCode)) {
                currencyRateType = CurrencyRateType.CBR;
            } else if (TextUtil.isSame((String)"UAH", (String)equivalentCurrencyCode)) {
                currencyRateType = CurrencyRateType.NBU;
            }
        }
        return currencyRateType;
    }

    private String getClientContractCurrency(Product product) throws Exception {
        if (product == null) {
            return null;
        }
        EntityReference agency = AirProductHelper.getAgency((Product)product);
        EntityReference subagency = AirProductHelper.getSubagency((Product)product);
        EntityReference client = product.getReservation().getBookingFile().getCustomerProfile();
        if (agency == null || client == null) {
            return null;
        }
        List<EntityContainer<Contract>> contractContainers = this.getContractContainers((EntityReference<Organization>)agency, (EntityReference<Organization>)subagency, (EntityReference<Organization>)client, ContractType.CLIENT, product.getIssueDate());
        if (contractContainers.isEmpty()) {
            return null;
        }
        if (contractContainers.size() > 1) {
            log.warn(String.format("found more than one client contract (agency: %s, client: %s)", agency, client));
        }
        Contract clientContract = (Contract)contractContainers.get(0).getEntity();
        return this.getPaymentCurrency(clientContract, (EntityReference<Organization>)client);
    }

    private String getPaymentCurrency(Contract contract, EntityReference<Organization> customer) {
        ContractCustomerInfo contractCustomerInfo = this.getContractCustomerInfo(contract, customer);
        return contractCustomerInfo != null ? contractCustomerInfo.getPaymentCurrency() : null;
    }

    private ContractCustomerInfo getContractCustomerInfo(Contract contract, EntityReference<Organization> customer) {
        if (contract == null || customer == null) {
            return null;
        }
        for (ContractCustomerInfo contractCustomerInfo : contract.getCustomers()) {
            if (!contractCustomerInfo.getCustomer().equals(customer)) continue;
            return contractCustomerInfo;
        }
        return null;
    }

    private List<EntityContainer<Contract>> getContractContainers(EntityReference<Organization> agency, EntityReference<Organization> subagency, EntityReference<Organization> client, ContractType contractType, Date operationDate) {
        ArrayList<EntityContainer<Contract>> contractContainers = new ArrayList<EntityContainer<Contract>>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)ContractType.CLIENT));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), client));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), subagency != null ? subagency : agency));
        if (operationDate != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractCustomerIndex.Property.startDate.name(), (Object)operationDate)}));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.startDate.name(), null));
        }
        if (operationDate != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractCustomerIndex.Property.endDate.name(), (Object)operationDate)}));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.endDate.name(), null));
        }
        EntityStorage entityCache = EntityStorage.get();
        List contractCustomerIndexes = entityCache.search(ContractCustomerIndex.class, query).getData();
        for (ContractCustomerIndex contractCustomerIndex : contractCustomerIndexes) {
            EntityContainer contractContainer = entityCache.resolve(contractCustomerIndex.getSource());
            if (contractContainer == null) {
                log.warn("unable to load contract " + contractCustomerIndex.getSource());
                continue;
            }
            contractContainers.add((EntityContainer<Contract>)contractContainer);
        }
        return contractContainers;
    }
}

