/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.rules.fops.FopActionSet;
import com.gridnine.xtrip.common.model.rules.fops.FopPropertySet;
import com.gridnine.xtrip.common.model.rules.fops.Targets;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseFopSettingsInterceptor
implements EntityInterceptor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final List<ProductStatus> activeStatuses = Arrays.asList(ProductStatus.SELL, ProductStatus.REFUND, ProductStatus.EXCHANGE, ProductStatus.VOID, ProductStatus.VOID_BOOKING);

    BaseFopSettingsInterceptor() {
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!BookingFile.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        this.log.debug(String.format("fop update -> checking booking file %s", data.toReference()));
        Date date = new Date();
        EntityContainer<?> bookingFileContainer = data;
        EntityContainer oldBookingFileContainer = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
        HashMap<BaseProduct, MiscUtil.Pair> oldProducts = new HashMap<BaseProduct, MiscUtil.Pair>();
        if (oldBookingFileContainer != null) {
            oldProducts.clear();
            oldProducts.putAll(((BookingFile)oldBookingFileContainer.getEntity()).getReservations().stream().flatMap(item -> item.getProducts().stream()).collect(Collectors.toMap(product -> product, product -> new MiscUtil.Pair((Object)ProductHandler.of((BaseProduct)product).getBaseStatus(product), GeneralProductHelper.getHandler((BaseProduct)product).getUnmodifiableContractRelations(product).stream().collect(Collectors.toMap(contractRelation -> contractRelation, contractRelation -> new MiscUtil.Pair((Object)contractRelation.getGeneralData().getContractData().getContract(), new HashSet(contractRelation.getFops()))))))));
        }
        List products = ((BookingFile)bookingFileContainer.getEntity()).getReservations().stream().flatMap(item -> item.getProducts().stream()).collect(Collectors.toList());
        for (BaseProduct product2 : products) {
            List contractRelations = GeneralProductHelper.getHandler((BaseProduct)product2).getUnmodifiableContractRelations(product2);
            ProductStatus status = ProductHandler.of((BaseProduct)product2).getBaseStatus(product2);
            Date productDate = ProductHandler.of((BaseProduct)product2).findIssueDate(product2);
            EntityReference productAgent = ProductHandler.of((BaseProduct)product2).findIssuingAgent(product2);
            boolean update = false;
            for (GeneralProductContractRelationData contractRelation : contractRelations) {
                ArrayList rules = new ArrayList();
                boolean search = true;
                for (GeneralProductFop fop : contractRelation.getFops()) {
                    if (!this.isAppropriateFop(product2, fop) || (oldProducts.containsKey(product2) || !activeStatuses.contains(status)) && (!oldProducts.containsKey(product2) || (activeStatuses.contains(((MiscUtil.Pair)oldProducts.get(product2)).getFirst()) || !activeStatuses.contains(status)) && ((Map)((MiscUtil.Pair)oldProducts.get(product2)).getSecond()).containsKey(contractRelation) && MiscUtil.equals((Object)((MiscUtil.Pair)((Map)((MiscUtil.Pair)oldProducts.get(product2)).getSecond()).get(contractRelation)).getFirst(), (Object)contractRelation.getGeneralData().getContractData().getContract()) && !((Set)((MiscUtil.Pair)((Map)((MiscUtil.Pair)oldProducts.get(product2)).getSecond()).get(contractRelation)).getSecond()).stream().noneMatch(oldFop -> this.isSameFop(fop, (GeneralProductFop)oldFop)))) continue;
                    this.log.debug(String.format("fop update -> checking fop %s", fop.getUid()));
                    if (search) {
                        EntityContainer<Contract> contractContainer = this.findContract(product2, contractRelation);
                        if (contractContainer != null) {
                            rules.clear();
                            rules.addAll(ProfileHelper.getRuleContainers(contractContainer, (Date)new Date()));
                        }
                        search = false;
                    }
                    Date fopDate = productDate;
                    EntityReference fopAgent = productAgent;
                    if (rules.size() > 0) {
                        this.log.debug("fop update -> rules found");
                        RuleProxy proxy = new RuleProxy();
                        FopPropertySet propertySet = new FopPropertySet(proxy);
                        propertySet.init(product2, fop);
                        FopActionSet actionSet = new FopActionSet();
                        proxy.setProxyType(Targets.FOPS.getId());
                        proxy.setProxyDate(date);
                        proxy.setPropertySet((Object)propertySet);
                        proxy.setActionSet((Object)actionSet);
                        for (EntityContainer rule : rules) {
                            RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)((BaseRulesContainer)rule.getEntity()).getRuleSet());
                        }
                        if (proxy.getAppliedRuleCategories().contains("rule_category_payment_type")) {
                            this.log.debug("fop update -> payment type rules applied");
                            PaymentType fopPaymentType = actionSet.getFopPaymentType();
                            if (!MiscUtil.equals((Object)fop.getType(), (Object)fopPaymentType)) {
                                this.log.debug(String.format("fop update -> fop payment type update -> %s -> %s", fop.getType(), fopPaymentType));
                                fop.setType(fopPaymentType);
                                proxy = new RuleProxy();
                                propertySet = new FopPropertySet(proxy);
                                propertySet.init(product2, fop);
                                actionSet = new FopActionSet();
                                proxy.setProxyType(Targets.FOPS.getId());
                                proxy.setProxyDate(date);
                                proxy.setPropertySet((Object)propertySet);
                                proxy.setActionSet((Object)actionSet);
                                for (EntityContainer rule : rules) {
                                    RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)((BaseRulesContainer)rule.getEntity()).getRuleSet());
                                }
                                update = true;
                            } else {
                                this.log.debug(String.format("fop update -> fop payment type matches -> %s", fop.getType()));
                            }
                        } else {
                            this.log.debug("fop update -> payment type rules not applied");
                        }
                        if (proxy.getAppliedRuleCategories().contains("rule_category_date") || proxy.getAppliedRuleCategories().contains("rule_category_agent")) {
                            this.log.debug("fop update -> operation date or agent rules applied");
                            fopDate = actionSet.getFopDate();
                            fopAgent = actionSet.getFopAgent();
                        } else {
                            this.log.debug("fop update -> operation date or agent rules not applied");
                        }
                    } else {
                        this.log.debug("fop update -> rules not found");
                    }
                    if (!MiscUtil.equals((Object)fop.getOperationDate(), (Object)fopDate)) {
                        this.log.debug(String.format("fop update -> fop operation date update -> %s -> %s", fop.getOperationDate(), fopDate));
                        fop.setOperationDate(fopDate);
                        update = true;
                    } else {
                        this.log.debug(String.format("fop update -> fop operation date matches -> %s", fop.getOperationDate()));
                    }
                    if (!MiscUtil.equals((Object)fop.getAgent(), (Object)fopAgent)) {
                        this.log.debug(String.format("fop update -> fop agent update -> %s -> %s", fop.getAgent(), fopAgent));
                        fop.setAgent(fopAgent);
                        update = true;
                        continue;
                    }
                    this.log.debug(String.format("fop update -> fop agent matches -> %s", fop.getAgent()));
                }
            }
            if (!update) continue;
            this.log.debug("fop update -> contract relations update");
            GeneralProductHelper.getHandler((BaseProduct)product2).updateContractRelations(product2, contractRelations);
        }
    }

    private boolean isSameFop(GeneralProductFop fop, GeneralProductFop oldFop) {
        if (fop.equals((Object)oldFop)) {
            return true;
        }
        return MiscUtil.equals((Object)fop.getType(), (Object)oldFop.getType()) && MiscUtil.isSameDaySafe((Date)fop.getOperationDate(), (Date)oldFop.getOperationDate()) && MiscUtil.equals((Object)fop.getAgent(), (Object)oldFop.getAgent()) && MiscUtil.equals((Object)fop.getEquivalentAmount(), (Object)oldFop.getEquivalentAmount()) && CollectionUtil.equals((Collection)fop.getCommissions(), (Collection)oldFop.getCommissions(), (comm1, comm2) -> MiscUtil.equals((Object)comm1.getCommissionProperties(), (Object)comm2.getCommissionProperties()), (boolean)true);
    }

    protected abstract EntityContainer<Contract> findContract(BaseProduct var1, GeneralProductContractRelationData var2) throws Exception;

    protected abstract boolean isAppropriateFop(BaseProduct var1, GeneralProductFop var2);
}

