/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Payment;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BillingTransactionHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.FopPaymentInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.BillingTransaction;
import com.gridnine.xtrip.common.model.system.BillingTransactionCategory;
import com.gridnine.xtrip.common.model.system.BillingTransactionIndex;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.model.system.BillingTransactionType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import com.gridnine.xtrip.server.model.handlers.finance.ProductBillingTransactionsHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BillingTransactionsInterceptor
implements EntityInterceptor {
    public static final String KEY_DELETED_BILLING_TRANSACTIONS_UIDS = "key-deleted-billing-transactions-uids";
    public static final String KEY_CREATED_BILLING_TRANSACTIONS_UIDS = "key-created-billing-transactions-uids";
    static final Logger log = LoggerFactory.getLogger(BillingTransactionsInterceptor.class);

    public static boolean isChanged(List<EntityContainer<BillingTransaction>> billingTransactions, List<EntityContainer<BillingTransaction>> oldBillingTransactions) {
        if (billingTransactions.size() != oldBillingTransactions.size()) {
            return true;
        }
        HashSet<String> foundTransactionUids = new HashSet<String>();
        for (EntityContainer<BillingTransaction> ctr : billingTransactions) {
            boolean found = false;
            BillingTransaction transaction = (BillingTransaction)ctr.getEntity();
            for (EntityContainer<BillingTransaction> oldCtr : oldBillingTransactions) {
                if (foundTransactionUids.contains(oldCtr.getUid())) continue;
                BillingTransaction oldTransaction = (BillingTransaction)oldCtr.getEntity();
                if (!MiscUtil.equals((Object)transaction.getFopUid(), (Object)oldTransaction.getFopUid()) || !MiscUtil.equals((Object)transaction.getAgency(), (Object)oldTransaction.getAgency()) || !MiscUtil.equals((Object)transaction.getAgent(), (Object)oldTransaction.getAgent()) || !MiscUtil.equals((Object)transaction.getCategory(), (Object)oldTransaction.getCategory()) || !MiscUtil.equals((Object)transaction.getClient(), (Object)oldTransaction.getClient()) || !MiscUtil.equals((Object)transaction.getDate(), (Object)oldTransaction.getDate()) || !MiscUtil.equals((Object)transaction.getDetails(), (Object)oldTransaction.getDetails()) || !MiscUtil.equals((Object)transaction.getEntity(), (Object)oldTransaction.getEntity()) || !MiscUtil.equals((Object)transaction.getParent(), (Object)oldTransaction.getParent()) || !MiscUtil.equals((Object)transaction.getPaymentType(), (Object)oldTransaction.getPaymentType()) || !MiscUtil.equals((Object)transaction.getFinDocNumber(), (Object)oldTransaction.getFinDocNumber()) || !MiscUtil.equals((Object)transaction.getFinDocDate(), (Object)oldTransaction.getFinDocDate()) || (transaction.getSum() == null || transaction.getSum().getValue() == null) && oldTransaction.getSum() != null && oldTransaction.getSum().getValue() != null || transaction.getSum() != null && transaction.getSum().getValue() != null && (oldTransaction.getSum() == null || oldTransaction.getSum().getValue() == null) || transaction.getSum() != null && transaction.getSum().getValue().compareTo(oldTransaction.getSum().getValue()) != 0 || transaction.getSum() != null && !MiscUtil.equals((Object)MiscUtil.guarded((Object)transaction.getSum().getCurrency(), (Object)DictHelper.getLocalCurrency()), (Object)MiscUtil.guarded((Object)oldTransaction.getSum().getCurrency(), (Object)DictHelper.getLocalCurrency())) || !MiscUtil.equals((Object)transaction.getType(), (Object)oldTransaction.getType()) || !MiscUtil.equals((Object)transaction.getContractType(), (Object)oldTransaction.getContractType()) || !MiscUtil.equals((Object)transaction.getStatus(), (Object)oldTransaction.getStatus())) continue;
                found = true;
                foundTransactionUids.add(oldCtr.getUid());
                break;
            }
            if (found) continue;
            return true;
        }
        return false;
    }

    public static List<EntityContainer<BillingTransaction>> createProductTransactions(EntityContainer<BookingFile> data) throws Exception {
        ArrayList<EntityContainer<BillingTransaction>> billingTransactions = new ArrayList<EntityContainer<BillingTransaction>>();
        EntityReference bookingFileReference = data.toReference();
        BookingFile bookingFile = (BookingFile)data.getEntity();
        for (Reservation reservation : bookingFile.getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                EntityReference<Organization> provider;
                EntityContainer clientProfile;
                ProductStatus productStatus;
                ProductBillingTransactionsHandler<BaseProduct> handler = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).findProductBillingTransactionHandler(baseProduct.getClass());
                if (handler == null) continue;
                EntityStorage entityStorage = EntityStorage.get();
                if (handler.getTicketType(baseProduct) == TicketType.FAKE || (productStatus = handler.getStatus(baseProduct)) != ProductStatus.SELL && productStatus != ProductStatus.REFUND && productStatus != ProductStatus.EXCHANGE) continue;
                EntityReference client = bookingFile.getCustomerProfile();
                EntityReference<Organization> supplier = handler.getSupplier(baseProduct);
                EntityReference<Organization> agency = handler.getAgency(baseProduct);
                EntityReference<Organization> subagency = handler.getSubagency(baseProduct);
                EntityReference<SalesPoint> salesPoint = handler.getSalesPoint(baseProduct);
                entityStorage.actualize(client);
                entityStorage.actualize(supplier);
                entityStorage.actualize(agency);
                entityStorage.actualize(subagency);
                if (supplier != null && agency != null && !supplier.equals(agency)) {
                    billingTransactions.addAll(BillingTransactionsInterceptor.createProductTransactions(ContractType.VENDOR, supplier, agency, salesPoint, handler, baseProduct, (EntityReference<BookingFile>)bookingFileReference));
                }
                if (agency != null && subagency != null && !agency.equals(subagency)) {
                    billingTransactions.addAll(BillingTransactionsInterceptor.createProductTransactions(ContractType.SUBAGENCY, agency, subagency, salesPoint, handler, baseProduct, (EntityReference<BookingFile>)bookingFileReference));
                }
                if (client != null && !handler.isCreateForRetail() && ((clientProfile = entityStorage.resolve(client)) == null || clientProfile.getEntity() == null || TextUtil.isSame((String)((BaseProfile)clientProfile.getEntity()).getCode(), (String)DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.RETAIL_PROFILE_CODE, null))) || (provider = subagency != null && !subagency.equals(agency) ? subagency : agency) == null || client == null || provider.equals((Object)client)) continue;
                billingTransactions.addAll(BillingTransactionsInterceptor.createProductTransactions(ContractType.CLIENT, provider, (EntityReference<? extends BaseProfile>)client, salesPoint, handler, baseProduct, (EntityReference<BookingFile>)bookingFileReference));
            }
        }
        return billingTransactions;
    }

    private static List<EntityContainer<BillingTransaction>> createProductTransactions(ContractType contractType, EntityReference<? extends BaseProfile> agency, EntityReference<? extends BaseProfile> client, EntityReference<SalesPoint> salesPoint, ProductBillingTransactionsHandler<BaseProduct> handler, BaseProduct baseProduct, EntityReference<BookingFile> bookingFileReference) throws Exception {
        if (contractType == ContractType.VENDOR) {
            return Collections.emptyList();
        }
        List<ProductBillingTransactionsHandler.FopData> fops = null;
        if (contractType == ContractType.SUBAGENCY) {
            fops = handler.getSubagentFops(baseProduct);
        } else if (contractType == ContractType.CLIENT) {
            fops = handler.getClientFops(baseProduct);
        }
        if (fops == null) {
            return Collections.emptyList();
        }
        ArrayList<EntityContainer<BillingTransaction>> billingTransactionContainers = new ArrayList<EntityContainer<BillingTransaction>>();
        ProductHandler productHandler = HandlersRegistry.get().findProductHandler(baseProduct.getClass());
        ProductStatus productStatus = handler.getStatus(baseProduct);
        ProductType productType = handler.getProductType(baseProduct);
        EntityReference branch = productHandler.getBranch(baseProduct);
        Date issueDate = productHandler.findIssueDate(baseProduct);
        EntityReference issuingAgent = productHandler.findIssuingAgent(baseProduct);
        String documentNumber = "";
        Date documentDate = null;
        if (baseProduct.getReservation() != null && baseProduct.getReservation().getBookingFile() != null) {
            block0: for (Payment payment : baseProduct.getReservation().getBookingFile().getPayments()) {
                for (BillingItem billingItem : payment.getBillingItems()) {
                    if (!billingItem.getProductUids().contains(baseProduct.getUid())) continue;
                    documentNumber = payment.getNumber();
                    documentDate = payment.getDate();
                    continue block0;
                }
            }
        }
        for (ProductBillingTransactionsHandler.FopData fop : fops) {
            FopPaymentInfo fopPaymentInfo;
            if (fop.getAmount() == null || fop.getAmount().getValue() == null || issueDate == null || !handler.getAllowedPaymentTypes().isEmpty() && fop.getPaymentType() != null && !handler.getAllowedPaymentTypes().contains(fop.getPaymentType()) || fop.isRefused()) continue;
            EntityContainer billingTransactionContainer = new EntityContainer(BillingTransaction.class);
            BillingTransaction billingTransaction = (BillingTransaction)billingTransactionContainer.getEntity();
            billingTransaction.setFopUid(fop.getUid());
            billingTransaction.setContractType(contractType);
            billingTransaction.setAgency(agency);
            billingTransaction.setClient(client);
            billingTransaction.setEntity(bookingFileReference);
            BillingTransactionCategory category = BillingTransactionHelper.getBillingTransactionCategory((ProductStatus)productStatus);
            billingTransaction.setCategory(category);
            billingTransaction.setProductType(productType);
            BillingTransactionType type = BillingTransactionHelper.getBillingTransactionType((ProductStatus)productStatus);
            for (ProductBillingTransactionsHandler.CommissionData commission : fop.getCommissions()) {
                if (commission.getCommissionProperties() == null || commission.getCommissionProperties().getType() == null || !commission.getCommissionProperties().getType().equals(DiscountProperties.class)) continue;
                type = BillingTransactionType.DISCOUNT;
                break;
            }
            billingTransaction.setType(type);
            billingTransaction.setStatus(BillingTransactionStatus.ACTIVE);
            billingTransaction.setDescription(handler.getShortName(baseProduct));
            billingTransaction.setPaymentType(fop.getPaymentType());
            billingTransaction.setDate(issueDate);
            billingTransaction.setAgent(issuingAgent);
            billingTransaction.setSum(fop.getAmount());
            if (billingTransaction.getSum() != null && billingTransaction.getSum().getCurrency() == null) {
                billingTransaction.getSum().setCurrency(DictHelper.getLocalCurrency());
            }
            billingTransaction.setDetails(null);
            billingTransaction.setParent(null);
            billingTransaction.setFinDocNumber(documentNumber);
            billingTransaction.setFinDocDate(documentDate);
            billingTransaction.setAutoCreated(true);
            if (productHandler.isHoldable(baseProduct)) {
                Date unholdDate = productHandler.getUnholdDate(baseProduct);
                if (productStatus == ProductStatus.SELL || productStatus == ProductStatus.EXCHANGE) {
                    EntityContainer holdBillingTransactionContainer = EntityContainer.create((BaseEntity)((BaseEntity)XCloneHelper.clone((XCloneable)billingTransaction, (boolean)true)));
                    BillingTransaction holdBillingTransaction = (BillingTransaction)holdBillingTransactionContainer.getEntity();
                    holdBillingTransaction.setStatus(BillingTransactionStatus.HOLD);
                    billingTransactionContainers.add((EntityContainer<BillingTransaction>)holdBillingTransactionContainer);
                    if (unholdDate != null) {
                        holdBillingTransactionContainer = EntityContainer.create((BaseEntity)((BaseEntity)XCloneHelper.clone((XCloneable)billingTransaction, (boolean)true)));
                        holdBillingTransaction = (BillingTransaction)holdBillingTransactionContainer.getEntity();
                        holdBillingTransaction.setStatus(BillingTransactionStatus.HOLD);
                        holdBillingTransaction.setDate(unholdDate);
                        holdBillingTransaction.getSum().setValue(MiscUtil.negate((BigDecimal)holdBillingTransaction.getSum().getValue()));
                        billingTransactionContainers.add((EntityContainer<BillingTransaction>)holdBillingTransactionContainer);
                    }
                }
                if (unholdDate != null) {
                    EntityContainer activeBillingTransactionContainer = EntityContainer.create((BaseEntity)((BaseEntity)XCloneHelper.clone((XCloneable)billingTransaction, (boolean)true)));
                    BillingTransaction activeBillingTransaction = (BillingTransaction)activeBillingTransactionContainer.getEntity();
                    activeBillingTransaction.setDate(unholdDate);
                    billingTransactionContainers.add((EntityContainer<BillingTransaction>)activeBillingTransactionContainer);
                }
            } else {
                billingTransactionContainers.add((EntityContainer<BillingTransaction>)billingTransactionContainer);
            }
            if (contractType == ContractType.CLIENT && fop.getOperationDate() == null || (fopPaymentInfo = FinanceHelper.getFopPaymentInfo(client, (PaymentType)fop.getPaymentType(), (boolean)false)) != null && !fopPaymentInfo.isCreatePaymentTransaction()) continue;
            EntityContainer billingBillingTransactionContainer = EntityContainer.create((BaseEntity)((BaseEntity)XCloneHelper.clone((XCloneable)billingTransaction, (boolean)true)));
            BillingTransaction billingBillingTransaction = (BillingTransaction)billingBillingTransactionContainer.getEntity();
            billingBillingTransaction.setCategory(billingTransaction.getCategory() == BillingTransactionCategory.CREDIT ? BillingTransactionCategory.DEBIT : BillingTransactionCategory.CREDIT);
            billingBillingTransaction.setType(BillingTransactionType.BILLING);
            billingBillingTransaction.setDate(contractType == ContractType.CLIENT ? fop.getOperationDate() : issueDate);
            billingBillingTransaction.setAgent(fop.getAgent());
            billingTransactionContainers.add((EntityContainer<BillingTransaction>)billingBillingTransactionContainer);
        }
        return billingTransactionContainers;
    }

    public static SearchQuery createAutoCreatedTransactionsSearchQuery(EntityReference<? extends BaseEntity> entityReference) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.referencedEntity.name(), entityReference));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.autoCreated.name(), (Object)Boolean.TRUE));
        query.getCriteria().getOrders().put(BillingTransactionIndex.Property.transactionDate.name(), SortOrder.ASC);
        return query;
    }

    public static void deleteBillingTransactions(EntityContainer<? extends BaseEntity> entityContainer, boolean context, String source) throws Exception {
        EntityReference entityReference = entityContainer.toReference();
        SearchQuery query = BillingTransactionsInterceptor.createAutoCreatedTransactionsSearchQuery((EntityReference<? extends BaseEntity>)entityReference);
        List billingTransactionIndexes = EntityStorage.get().search(BillingTransactionIndex.class, query).getData();
        for (BillingTransactionIndex billingTransactionIndex : billingTransactionIndexes) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("delete transaction (" + (source != null ? source : "unknown source") + ") uid=%s, entity=%s, sum=%s, contractType=%s, client=%s, agency=%s, description=%s, agent=%s, category=%s, date=%s, transactionCode=%s, parent=%s, paymentType=%s, finDocNumber=%s, finDocDate=%s, type=%s, status=%s", billingTransactionIndex.getSource().getUid(), billingTransactionIndex.getReferencedEntity(), billingTransactionIndex.getTransactionSum() != null ? billingTransactionIndex.getTransactionSum().toString() : "null", billingTransactionIndex.getContractType() != null ? billingTransactionIndex.getContractType().name() : "null", billingTransactionIndex.getClient() != null ? billingTransactionIndex.getClient().getUid() + " (" + String.valueOf(billingTransactionIndex.getClient().getCaption()) + ")" : "null", billingTransactionIndex.getAgency() != null ? billingTransactionIndex.getAgency().getUid() + " (" + String.valueOf(billingTransactionIndex.getAgency().getCaption()) + ")" : "null", String.valueOf(billingTransactionIndex.getDescription()), billingTransactionIndex.getAgent() != null ? billingTransactionIndex.getAgent().getUid() + " (" + String.valueOf(billingTransactionIndex.getAgent().getCaption()) + ")" : "null", billingTransactionIndex.getCategory() != null ? billingTransactionIndex.getCategory().name() : "null", String.valueOf(billingTransactionIndex.getTransactionDate()), String.valueOf(billingTransactionIndex.getTransactionCode()), billingTransactionIndex.getParent() != null ? billingTransactionIndex.getParent().getUid() + " (" + String.valueOf(billingTransactionIndex.getParent().getCaption()) + ")" : "null", billingTransactionIndex.getPaymentType() != null ? billingTransactionIndex.getPaymentType().name() : "null", String.valueOf(billingTransactionIndex.getFinDocNumber()), String.valueOf(billingTransactionIndex.getFinDocDate()), billingTransactionIndex.getType() != null ? billingTransactionIndex.getType().name() : "null", billingTransactionIndex.getStatus() != null ? billingTransactionIndex.getStatus().name() : "null"));
            }
            EntityStorage.get().delete(billingTransactionIndex.getSource());
            if (!context) continue;
            HashSet<String> uids = (HashSet<String>)LogicalStorage.get().getEntityStorage().getGlobalOperationContext().getParameters().get(KEY_DELETED_BILLING_TRANSACTIONS_UIDS);
            if (uids == null) {
                uids = new HashSet<String>();
                LogicalStorage.get().getEntityStorage().getGlobalOperationContext().getParameters().put(KEY_DELETED_BILLING_TRANSACTIONS_UIDS, uids);
            }
            uids.add(billingTransactionIndex.getSource().getUid());
        }
    }

    public static void saveBillingTransactions(EntityContainer<? extends BaseEntity> entityContainer, List<EntityContainer<BillingTransaction>> transactionContainers, boolean context, String source) throws Exception {
        for (EntityContainer<BillingTransaction> transactionContainer : transactionContainers) {
            BillingTransactionsInterceptor.logBillingTransaction(transactionContainer, true, source);
            transactionContainer.getVersionInfo().setDataSource("billing transaction interceptor");
            transactionContainer.getVersionInfo().setVersionNotes(source);
            EntityStorage.get().save(transactionContainer, true);
            if (!context) continue;
            HashSet<String> uids = (HashSet<String>)LogicalStorage.get().getEntityStorage().getGlobalOperationContext().getParameters().get(KEY_CREATED_BILLING_TRANSACTIONS_UIDS);
            if (uids == null) {
                uids = new HashSet<String>();
                LogicalStorage.get().getEntityStorage().getGlobalOperationContext().getParameters().put(KEY_CREATED_BILLING_TRANSACTIONS_UIDS, uids);
            }
            uids.add(transactionContainer.getUid());
        }
    }

    private static void logBillingTransaction(EntityContainer<BillingTransaction> transactionContainer, boolean save, String source) {
        if (log.isDebugEnabled()) {
            BillingTransaction billingTransaction = (BillingTransaction)transactionContainer.getEntity();
            log.debug(String.format((save ? "save" : "delete") + " transaction (" + (source != null ? source : "unknown source") + ") uid=%s, number=%s, sum=%s, contractType=%s, client=%s, agency=%s, description=%s, agent=%s, category=%s, date=%s, details=%s, parent=%s, paymentType=%s, finDocNumber=%s, finDocDate=%s, type=%s, status=%s", transactionContainer.getUid(), String.valueOf(billingTransaction.getEntity()), billingTransaction.getSum() != null && billingTransaction.getSum().getValue() != null ? billingTransaction.getSum().getValue().toString() : "null", billingTransaction.getContractType() != null ? billingTransaction.getContractType().name() : "null", billingTransaction.getClient() != null ? billingTransaction.getClient().getUid() + " (" + String.valueOf(billingTransaction.getClient().getCaption()) + ")" : "null", billingTransaction.getAgency() != null ? billingTransaction.getAgency().getUid() + " (" + String.valueOf(billingTransaction.getAgency().getCaption()) + ")" : "null", String.valueOf(billingTransaction.getDescription()), billingTransaction.getAgent() != null ? billingTransaction.getAgent().getUid() + " (" + String.valueOf(billingTransaction.getAgent().getCaption()) + ")" : "null", billingTransaction.getCategory() != null ? billingTransaction.getCategory().name() : "null", String.valueOf(billingTransaction.getDate()), billingTransaction.getDetails() != null ? billingTransaction.getDetails().getUid() + " (" + String.valueOf(billingTransaction.getDetails().getTransactionCode()) + ")" : "null", billingTransaction.getParent() != null ? billingTransaction.getParent().getUid() + " (" + String.valueOf(billingTransaction.getParent().getCaption()) + ")" : "null", billingTransaction.getPaymentType() != null ? billingTransaction.getPaymentType().name() : "null", String.valueOf(billingTransaction.getFinDocNumber()), String.valueOf(billingTransaction.getFinDocDate()), billingTransaction.getType() != null ? billingTransaction.getType().name() : "null", billingTransaction.getStatus() != null ? billingTransaction.getStatus().name() : "null"));
        }
    }

    public double getPriority() {
        return 3.1;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }
}

