/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeType;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.vat.hotel.HotelProductVatFiller;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.model.handlers.GeneralProductCommissionActionSet;
import com.gridnine.xtrip.server.model.helpers.ShipmentHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookingFileContainerInterceptor
implements EntityInterceptor {
    public static final double PRIORITY = 1.0;
    private static final Logger logger = LoggerFactory.getLogger(BookingFileContainerInterceptor.class);

    public double getPriority() {
        return 1.0;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (BookingFile.class.getName().equals(data.getEntityType().getName())) {
            EntityContainer oldBookingCtr;
            BookingFile bookingFile = (BookingFile)data.getEntity();
            for (Traveller traveller : bookingFile.getTravellers()) {
                if (traveller.getPassenger() != null) continue;
                traveller.setPassenger(ProfileHelper.findPerson((Traveller)traveller, (EntityReference)bookingFile.getCustomerProfile()));
            }
            if ((bookingFile.getCustomerProfile() == null || ProfileHelper.isRetailProfile((EntityReference)bookingFile.getCustomerProfile()) && !this.isTrueRetailClient(bookingFile)) && BookingHelper.getBaseProductsStream((BookingFile)bookingFile).noneMatch(ShipmentHelper::hasClientRelatedShipment)) {
                EntityContainer retailClientContainer = ProfileHelper.getRetailProfileContainer();
                if (retailClientContainer != null) {
                    bookingFile.setCustomerProfile(retailClientContainer.toReference());
                }
                if (!this.isUseRetailClient(bookingFile)) {
                    ArrayList organizations = new ArrayList();
                    boolean initialized = false;
                    for (Traveller traveller : bookingFile.getTravellers()) {
                        EntityContainer personContainer = EntityStorage.get().resolve(traveller.getPassenger());
                        if (personContainer == null) continue;
                        ArrayList<EntityReference> personOrganizations = new ArrayList<EntityReference>();
                        for (PersonEmployment employment : ((Person)personContainer.getEntity()).getEmployments()) {
                            EntityContainer orgCont;
                            if (employment.getOrganization() == null || !MiscUtil.isBetween((Date)employment.getOpened(), (Date)employment.getClosed(), (Date)bookingFile.getCreateDate()) || (orgCont = EntityStorage.get().resolve(employment.getOrganization())) == null || orgCont.getEntity() == null || !((Organization)orgCont.getEntity()).getTypes().contains(OrganizationType.CORPORATE_CLIENT)) continue;
                            personOrganizations.add(employment.getOrganization());
                        }
                        if (initialized) {
                            organizations.retainAll(personOrganizations);
                        } else {
                            organizations = personOrganizations;
                            initialized = true;
                        }
                        if (organizations.size() != 0) continue;
                        break;
                    }
                    if (organizations.size() == 1) {
                        bookingFile.setCustomerProfile((EntityReference)organizations.get(0));
                    }
                }
            }
            if (LogicalStorage.get().getEntityStorage().isGlobalOperationContextAvailable() && (oldBookingCtr = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr()) != null) {
                boolean clientChanged = !MiscUtil.equals((Object)bookingFile.getCustomerProfile(), (Object)((BookingFile)oldBookingCtr.getEntity()).getCustomerProfile());
                for (Reservation res : bookingFile.getReservations()) {
                    for (BaseProduct prod : res.getProducts()) {
                        BaseProduct oldProduct;
                        if (GeneralProductHelper.getHandler((BaseProduct)prod).isChecked(prod) || (oldProduct = BookingHelper.findProduct((BookingFile)((BookingFile)oldBookingCtr.getEntity()), (String)prod.getUid())) == null) continue;
                        boolean resetRulesFlag = clientChanged;
                        if (!resetRulesFlag && !CollectionUtil.equals((Collection)GeneralProductHelper.getHandler((BaseProduct)prod).getSalesChain(prod).getContractors(), (Collection)GeneralProductHelper.getHandler((BaseProduct)oldProduct).getSalesChain(oldProduct).getContractors(), (c1, c2) -> {
                            if (c1 == null) {
                                return c2 == null;
                            }
                            if (c2 == null) {
                                return false;
                            }
                            return MiscUtil.equals((Object)c1.getDescription(), (Object)c2.getDescription()) && MiscUtil.equals((Object)c1.getContractor(), (Object)c2.getContractor());
                        }, (boolean)true)) {
                            resetRulesFlag = true;
                        }
                        if (!resetRulesFlag) continue;
                        GeneralProductHelper.getHandler((BaseProduct)prod).setContractRulesApplied(prod, false);
                    }
                }
            }
            if ("import-hotel-booking".equals(data.getVersionInfo().getDataSource())) {
                this.validateHotelProducts(bookingFile);
            }
            this.fixVatDetalization(bookingFile);
            this.resetAuthorizationCode(bookingFile, data.toReference());
            this.updateManuallyCalculatedFeesEquivalentAmount(bookingFile);
            BookingFileContainerInterceptor.checkForLoopsInProductChains(bookingFile);
            logger.info("booking file save, uid={}, number={}", (Object)data.getUid(), (Object)TextUtil.buildFullNumber((CompositeNumber)bookingFile));
        }
    }

    private static void checkForLoopsInProductChains(BookingFile bookingFile) {
        for (Reservation reservation : bookingFile.getReservations()) {
            for (BaseProduct bp : reservation.getProducts()) {
                ProductHandler handler = ProductHandler.of((BaseProduct)bp);
                GeneralProductHelper.getFirstProduct((BaseProduct)bp, (ProductHandler)handler);
                GeneralProductHelper.getLastProduct((BaseProduct)bp, (ProductHandler)handler);
            }
        }
    }

    private void resetAuthorizationCode(BookingFile bookingFile, EntityReference<?> data) {
        if (LogicalStorage.get().getEntityStorage().isGlobalOperationContextAvailable()) {
            EntityContainer oldBookingCtr = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data).getOldCtr();
            for (Reservation res : bookingFile.getReservations()) {
                for (BaseProduct bp : res.getProducts()) {
                    Product oldProduct;
                    Product product;
                    if (!(bp instanceof Product) || (product = (Product)bp).getStatus() != ProductStatus.REFUND && (product.getPreviousProduct() == null || product.getPreviousProduct().getStatus() != ProductStatus.EXCHANGE) || (oldProduct = oldBookingCtr == null ? null : (Product)BookingHelper.findProduct((BookingFile)((BookingFile)oldBookingCtr.getEntity()), (String)product.getUid())) != null) continue;
                    for (AirProductContractRelationData cr : AirProductHelper.getContractRelations((Product)product)) {
                        for (ProductFop fop : cr.getFops()) {
                            if (AirProductHelper.isServiceFop((ProductFop)fop) || fop.getCard() == null) continue;
                            fop.getCard().setSecurityCode(null);
                        }
                    }
                }
            }
        }
    }

    private void validateHotelProducts(BookingFile booking) {
        BookingHelper.getProductsStream((BookingFile)booking, HotelProduct.class).forEach(hp -> hp.getRooms().forEach(room -> {
            Money basePrice = room.getBasePrice();
            if (basePrice != null && basePrice.getCurrency() == null) {
                IncidentsLog.reportStackTrace((String)("malformed hotel product in order " + booking.getNumber() + ": room basePrice without currency"));
            }
        }));
    }

    private void fixVatDetalization(BookingFile booking) {
        BookingHelper.getProductsStream((BookingFile)booking, HotelProduct.class).forEach(hp -> {
            if (hp.getVendorVatDetalization() != null) {
                HotelProductVatFiller.updateVat((HotelProduct)hp);
            }
        });
    }

    private void updateManuallyCalculatedFeesEquivalentAmount(BookingFile bookingFile) {
        bookingFile.getReservations().forEach(reservation -> reservation.getProducts().forEach(baseProduct -> {
            List contractRelations = ProductHandler.of((BaseProduct)baseProduct).getUnmodifiableContractRelations(baseProduct);
            AtomicBoolean update = new AtomicBoolean(false);
            contractRelations.forEach(contractRelation -> contractRelation.getCommissions().forEach(commission -> {
                FeeProperties feeProperties;
                BaseCommissionProperties entity;
                if (MiscUtil.isZero((BigDecimal)commission.getEquivalentAmount(), (boolean)false)) {
                    return;
                }
                if (commission.getRate() == null) {
                    return;
                }
                Double rate = commission.getRate();
                EntityContainer commissionPropertiesCtr = EntityStorage.get().resolve(commission.getCommissionProperties());
                if (commissionPropertiesCtr != null && (entity = (BaseCommissionProperties)commissionPropertiesCtr.getEntity()) instanceof FeeProperties && (feeProperties = (FeeProperties)entity).getType() == FeeType.MANUALLY_CALCULATED) {
                    BigDecimal basis = GeneralProductCommissionActionSet.getBasis(feeProperties.getCalculationBasis(), contractRelation, null, baseProduct, GeneralProductHelper.filterCommissions((Collection)contractRelation.getCommissions(), (Set)GeneralProductHelper.serviceFeePropertyTypes, (Set)GeneralProductHelper.standardCommissionTypes, (Set)GeneralProductHelper.hiddenCommissionCategories));
                    if (MiscUtil.isZero((BigDecimal)basis, (boolean)true)) {
                        return;
                    }
                    BigDecimal result = RulesHelper.roundDouble((BigDecimal)basis.multiply(BigDecimal.valueOf(rate / 100.0)), (RoundingMode)feeProperties.getRoundingMode(), (RoundingValue)feeProperties.getRoundingValue());
                    commission.setEquivalentAmount(result);
                    update.set(true);
                }
            }));
            if (update.get()) {
                ProductHandler.of((BaseProduct)baseProduct).updateContractRelations(baseProduct, contractRelations);
            }
        }));
    }

    private boolean isUseRetailClient(BookingFile bookingFile) {
        List agencies = bookingFile.getReservations().stream().flatMap(reservation -> reservation.getProducts().stream()).map(GeneralProductHelper::getAgency).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List subagencies = bookingFile.getReservations().stream().flatMap(reservation -> reservation.getProducts().stream()).map(GeneralProductHelper::getSubagency).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (agencies.size() == 1 && subagencies.size() == 1 && !((EntityReference)subagencies.get(0)).equals(agencies.get(0))) {
            Organization subagency;
            EntityContainer ctrAgency = EntityStorage.get().resolve((EntityReference)agencies.get(0));
            EntityContainer ctrSubagency = EntityStorage.get().resolve((EntityReference)subagencies.get(0));
            Organization agency = ctrAgency != null ? (Organization)ctrAgency.getEntity() : null;
            Organization organization = subagency = ctrSubagency != null ? (Organization)ctrSubagency.getEntity() : null;
            if (agency != null && agency.getUseRetailClient() != null) {
                return agency.getUseRetailClient();
            }
            if (subagency != null && subagency.getUseRetailClient() != null) {
                return subagency.getUseRetailClient();
            }
        }
        return false;
    }

    protected boolean isTrueRetailClient(BookingFile bookingFile) {
        return false;
    }
}

