/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.export.xml.XMLEntityExportHelper;
import com.gridnine.xtrip.common.model.export.xml.XMLFilterHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.ServerApplication;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import com.gridnine.xtrip.server.model.interceptors.EntityTransformer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.java.plugin.util.ExtendedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class BookingFileExportInterceptor
implements EntityInterceptor {
    private static final String DATE_FORMAT_FILENAME = "'bookings_'yyyyMMddHHmmssSSS'.xml'";
    private static final String DATE_FORMAT_FILENAME_WITH_POSTFIX = "'bookings_'yyyyMMddHHmmssSSS'_%d.xml'";
    protected static final Logger log = LoggerFactory.getLogger(BookingFileExportInterceptor.class);
    private static final String ENABLED_PROPERTY_NAME = "booking.file.xml.exporter.enabled";
    private static final String PATH_PROPERTY_NAME = "booking.file.xml.exporter.path";
    private static final String FILTER_FILE_PROPERTY_NAME = "booking.file.xml.exporter.filter.file";
    private static final String FILTER_EXCLUSIVE_PROPERTY_NAME = "booking.file.xml.exporter.filter.exclusive";
    public static final double PRIORITY = 2.147483647E9;

    public double getPriority() {
        return 2.147483647E9;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        ArrayList<Message> messages;
        Document document;
        if (!BookingFile.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        EntityContainer<?> container = data;
        EntityReference bookingFileReference = container.toReference();
        BookingFile bookingFile = this.transform((BookingFile)container.getEntity());
        log.debug(String.format("preparing export booking file %s", bookingFile));
        if (!Environment.isPublished(ServerApplication.class)) {
            return;
        }
        if (!this.exportConditionsMet(container)) {
            return;
        }
        ExtendedProperties serverProperties = ((ServerApplication)Environment.getPublished(ServerApplication.class)).getConfiguration();
        String enabledString = serverProperties.getProperty(ENABLED_PROPERTY_NAME, null);
        boolean enabled = !TextUtil.isBlank((String)enabledString) && enabledString.equalsIgnoreCase("true");
        log.debug(String.format("service enabled %s", String.valueOf(enabled)));
        if (!enabled) return;
        log.debug(String.format("starting export booking file %s", bookingFile));
        String filterFile = serverProperties.getProperty(FILTER_FILE_PROPERTY_NAME, null);
        String filterExclusiveString = serverProperties.getProperty(FILTER_EXCLUSIVE_PROPERTY_NAME, null);
        boolean filterExclusive = TextUtil.isBlank((String)filterExclusiveString) || !filterExclusiveString.equalsIgnoreCase("false");
        List filters = XMLFilterHelper.getFilters();
        if (!TextUtil.isBlank((String)filterFile)) {
            try {
                if (filterExclusive) {
                    filters.add(XMLFilterHelper.createExclusiveFilter((String)filterFile));
                } else {
                    filters.add(XMLFilterHelper.createInclusiveFilter((String)filterFile));
                }
            }
            catch (IOException e) {
                log.warn(String.format("filter file \"%s\" was not found", filterFile), (Throwable)e);
            }
        }
        if ((document = XMLEntityExportHelper.export((BaseEntity)bookingFile, (List)filters, messages = new ArrayList<Message>())) == null || this.hasErrors(messages)) {
            log.error(String.format("unable to export booking file \"%s\"", bookingFile.getNumber()));
            return;
        }
        String exportPath = serverProperties.getProperty(PATH_PROPERTY_NAME, null);
        File folder = !TextUtil.isBlank((String)exportPath) ? new File(exportPath) : new File(Environment.getDataFolder(), "export/booking-files");
        SimpleDateFormat dateFormatNormalFilename = new SimpleDateFormat(DATE_FORMAT_FILENAME);
        Date currentTimestamp = new Date();
        String exportFileName = dateFormatNormalFilename.format(currentTimestamp);
        if (!folder.isDirectory()) {
            folder.mkdirs();
        }
        File file = new File(folder, exportFileName);
        try (OutputStream outputStream = null;){
            if (!file.createNewFile()) {
                boolean wasCreated;
                String string = DATE_FORMAT_FILENAME;
                // MONITORENTER : "'bookings_'yyyyMMddHHmmssSSS'.xml'"
                int postfixIndex = 0;
                SimpleDateFormat dateFormatFilenameWithPostfix = new SimpleDateFormat(DATE_FORMAT_FILENAME_WITH_POSTFIX);
                while (!(wasCreated = (file = new File(folder, exportFileName = String.format(dateFormatFilenameWithPostfix.format(currentTimestamp), ++postfixIndex))).createNewFile())) {
                }
                // MONITOREXIT : string
            }
            outputStream = new FileOutputStream(file);
            Transformer transformer = XUtil.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new DOMSource(document), new StreamResult(outputStream));
            outputStream.flush();
            log.info(String.format("booking file %s was exported successfully to the file %s", bookingFile, file.getName()));
            SysLogHelper.audit(bookingFileReference, "entity-modification", SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)L10nResourcesManager.getStr((String)Messages.BookingFileExportInterceptor_orderSuccessfullyExport, (Object[])new Object[]{file.getName()}), (Object[])new Object[0]));
            return;
        }
    }

    private BookingFile transform(BookingFile bookingFile) {
        try {
            String clsName = System.getProperty("booking-file-export-transformer.className");
            EntityTransformer transformer = TextUtil.isBlank((String)clsName) ? null : (EntityTransformer)Class.forName(clsName).newInstance();
            return transformer != null ? transformer.transform(bookingFile) : bookingFile;
        }
        catch (Throwable t) {
            IncidentsLog.reportException((String)("failed to transform booking file " + bookingFile.getNumber()), (Throwable)t);
            return bookingFile;
        }
    }

    private boolean hasErrors(List<Message> messages) {
        for (Message message : messages) {
            if (message.getType() != MessageType.ERROR) continue;
            return true;
        }
        return false;
    }

    protected boolean exportConditionsMet(EntityContainer<BookingFile> bfCtr) {
        return true;
    }
}

