/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.model.helpers.fopDetalization.FopDetalizer;

public class BookingFileFopDetalizationInterceptor
implements EntityInterceptor {
    public double getPriority() {
        return Math.max(4.0, 3.001);
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!BookingFile.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        if (Environment.isTest() && !Environment.isPublished(FopDetalizer.class)) {
            return;
        }
        BookingFile bf = (BookingFile)data.getEntity();
        ((FopDetalizer)Environment.getPublished(FopDetalizer.class)).updateFopDetalizations(bf);
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }
}

