/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;

public class BookingFileReferralTicketTypeRulesInterceptor
implements EntityInterceptor {
    public double getPriority() {
        return 2.0;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!BookingFile.class.isAssignableFrom(data.getEntityType())) {
            return;
        }
        EntityContainer<?> bfCtr = data;
        EntityContainer oldCtr = LogicalStorage.get().getEntityStorage().getLocalOperationContext(bfCtr.toReference()).getOldCtr();
        if (null == oldCtr) {
            return;
        }
        ((BookingFile)bfCtr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).forEach(p -> this.process((BaseProduct)p, BookingHelper.findProduct((EntityContainer)oldCtr, (String)p.getUid())));
    }

    private void process(BaseProduct product, BaseProduct oldProduct) {
        if (null == oldProduct) {
            return;
        }
        ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)product);
        if (handler.isChecked(product) || handler.isFareFopsRelevant(product) == handler.isFareFopsRelevant(oldProduct)) {
            return;
        }
        handler.setContractRulesApplied(product, false);
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) {
    }
}

