/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.model.helpers.ProfileHelper;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class BookingFileTechnicalProviderInterceptor
implements EntityInterceptor {
    private static final double PRIORITY = 1.0;

    public double getPriority() {
        return 1.0;
    }

    public boolean isSystem() {
        return true;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) {
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) {
        if (!BookingFile.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        EntityReference<Organization> techProvider = ProfileHelper.findTechnicalProviderProfile();
        if (techProvider == null) {
            return;
        }
        EntityContainer<?> bfCtr = data;
        EntityContainer oldBfCtr = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
        List oldProducts = oldBfCtr == null ? Collections.emptyList() : BookingStreamHelper.getProductsStream((BookingFile)((BookingFile)oldBfCtr.getEntity()), Product.class).collect(Collectors.toList());
        BookingStreamHelper.getProductsStream((BookingFile)((BookingFile)bfCtr.getEntity()), Product.class).filter(bp -> GeneralProductHelper.getTechnicalProvider((BaseProduct)bp) == null).filter(bp -> !oldProducts.contains(bp)).forEach(bp -> AirProductHelper.setTechnicalProvider((Product)bp, this.getTechProvider((Product)bp, techProvider)));
    }

    private EntityReference<Organization> getTechProvider(Product bp, EntityReference<Organization> currentTechProvider) {
        if (bp.getStatus() == ProductStatus.REFUND || bp.getStatus() == ProductStatus.EXCHANGE) {
            return AirProductHelper.getTechnicalProvider((Product)bp.getPreviousProduct());
        }
        if (bp.getProductCategory() != ProductCategory.AIR) {
            return bp.getRelatedProducts().stream().map(AirProductHelper::getTechnicalProvider).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return currentTechProvider;
    }
}

