/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorageHelper;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.model.number.helpers.FinanceDocumentNumberHelper;
import com.gridnine.xtrip.server.model.number.helpers.PaymentDocumentNumberHelper;
import com.gridnine.xtrip.server.model.number.helpers.ShipmentNumberHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsecutiveNumberInterceptor
implements EntityInterceptor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public double getPriority() {
        return 0.0;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        BasePaymentDocument document;
        if (Shipment.class.getName().equals(data.getEntityType().getName())) {
            Shipment shipment = (Shipment)data.getEntity();
            if (TextUtil.isBlank((String)shipment.getNumber())) {
                ShipmentNumberHelper.generateNumber(shipment, LogicalStorageHelper.getEntityStorageContext());
            }
        } else if (FinanceDocument.class.getName().equals(data.getEntityType().getName())) {
            FinanceDocument document2 = (FinanceDocument)data.getEntity();
            if (TextUtil.isBlank((String)document2.getNumber())) {
                FinanceDocumentNumberHelper.generateNumber(document2, LogicalStorageHelper.getEntityStorageContext());
            }
        } else if (BasePaymentDocument.class.isAssignableFrom(data.getEntityType()) && TextUtil.isBlank((String)(document = (BasePaymentDocument)data.getEntity()).getNumber())) {
            PaymentDocumentNumberHelper.generateNumber(document, LogicalStorageHelper.getEntityStorageContext());
        }
    }
}

