/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.async.AsyncCommand;
import com.gridnine.xtrip.common.async.AsyncCommandOption;
import com.gridnine.xtrip.common.async.AsyncExecutor;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.PersonEmploymentIndex;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.db.Callback;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ContractUpdateOrganizationIndexInterceptor
implements EntityInterceptor {
    public double getPriority() {
        return 0.0;
    }

    public void onSave(SessionCallback sessionCallback0, EntityContainer<?> data) throws Exception {
        if (!Contract.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        EntityContainer<?> newContractContainer = data;
        EntityContainer oldContractContainer = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
        Set<EntityReference<Organization>> organizationReferencesToUpdate = this.getOrganizationsRequiringIndexUpdate(newContractContainer, (EntityContainer<Contract>)oldContractContainer);
        this.processIndexesUpdate(sessionCallback0, organizationReferencesToUpdate);
    }

    public void onDelete(SessionCallback sessionCallback0, EntityContainer<?> data) throws Exception {
        if (!Contract.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        EntityContainer oldContractContainer = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
        Set<EntityReference<Organization>> organizationReferencesToUpdate = this.getOrganizationsRequiringIndexUpdate(null, (EntityContainer<Contract>)oldContractContainer);
        this.processIndexesUpdate(sessionCallback0, organizationReferencesToUpdate);
    }

    private Set<EntityReference<Organization>> getOrganizationsRequiringIndexUpdate(EntityContainer<Contract> newContractContainer, EntityContainer<Contract> oldContractContainer) {
        HashSet<EntityReference<Organization>> resultReferences = new HashSet<EntityReference<Organization>>();
        HashSet newCustomers = new HashSet();
        EntityReference newSupplier = null;
        if (newContractContainer != null) {
            List newCustomerInfos = ((Contract)newContractContainer.getEntity()).getCustomers();
            newSupplier = ((Contract)newContractContainer.getEntity()).getSupplier();
            if (newCustomerInfos != null) {
                newCustomerInfos.forEach(customerInfo -> newCustomers.add(customerInfo.getCustomer()));
            }
        }
        if (oldContractContainer == null) {
            resultReferences.addAll(newCustomers);
            return resultReferences;
        }
        EntityReference oldSupplier = ((Contract)oldContractContainer.getEntity()).getSupplier();
        HashSet oldCustomers = new HashSet();
        List oldCustomerInfos = ((Contract)oldContractContainer.getEntity()).getCustomers();
        if (oldCustomerInfos != null) {
            oldCustomerInfos.forEach(customerInfo -> oldCustomers.add(customerInfo.getCustomer()));
        }
        if (newContractContainer == null) {
            resultReferences.addAll(oldCustomers);
            return resultReferences;
        }
        if (newSupplier != null && !newSupplier.equals((Object)oldSupplier)) {
            resultReferences.addAll(newCustomers);
            resultReferences.addAll(oldCustomers);
            return resultReferences;
        }
        newCustomers.stream().filter(customerReference -> !oldCustomers.contains(customerReference)).forEach(customerReference -> resultReferences.add((EntityReference<Organization>)customerReference));
        oldCustomers.stream().filter(customerReference -> !newCustomers.contains(customerReference)).forEach(customerReference -> resultReferences.add((EntityReference<Organization>)customerReference));
        return resultReferences;
    }

    private void processIndexesUpdate(SessionCallback sessionCallback0, Set<EntityReference<Organization>> organizationReferencesToUpdate) {
        sessionCallback0.addCallback((Callback & Serializable)sessionCallback1 -> {
            UpdateIndexesAsyncCommand updateIndexesAsyncCommand = new UpdateIndexesAsyncCommand(organizationReferencesToUpdate);
            AsyncExecutor.get().execute(this.getClass().getName(), (AsyncCommand)updateIndexesAsyncCommand, new AsyncCommandOption[0]);
        });
    }

    private static final class UpdateIndexesAsyncCommand
    implements AsyncCommand {
        private static final long serialVersionUID = -1832524118642408830L;
        Set<EntityReference<Organization>> organizationReferences;

        UpdateIndexesAsyncCommand(Set<EntityReference<Organization>> organizationReferences) {
            this.organizationReferences = organizationReferences;
        }

        public void run() throws Exception {
            this.updateOrganizationIndex();
            this.updatePersonIndex();
        }

        private void updateOrganizationIndex() {
            for (EntityReference<Organization> organizationReference : this.organizationReferences) {
                EntityContainer organizationContainer = EntityStorage.get().resolve(organizationReference);
                if (organizationContainer == null) continue;
                LogicalStorage.get().getEntityStorage().updateIndexes(organizationContainer, organizationContainer, Collections.singleton(OrganizationIndex.class), false);
            }
        }

        private void updatePersonIndex() {
            for (EntityReference<Organization> organizationReference : this.organizationReferences) {
                EntityContainer organizationContainer = EntityStorage.get().resolve(organizationReference);
                if (organizationContainer == null) continue;
                this.performUpdatePersonIndex((EntityContainer<Organization>)organizationContainer);
            }
        }

        private void performUpdatePersonIndex(EntityContainer<Organization> organizationContainer) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonEmploymentIndex.Property.organization.name(), (Object)organizationContainer.toReference()));
            List personEmploymentIndexes = EntityStorage.get().search(PersonEmploymentIndex.class, query).getData();
            if (personEmploymentIndexes != null) {
                for (PersonEmploymentIndex personEmploymentIndex : personEmploymentIndexes) {
                    EntityContainer personContainer;
                    if (personEmploymentIndex.getSource() == null || (personContainer = EntityStorage.get().resolve(personEmploymentIndex.getSource())) == null) continue;
                    LogicalStorage.get().getEntityStorage().updateIndexes(personContainer, personContainer, Collections.singleton(PersonIndex.class), false);
                }
            }
        }
    }
}

