/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.TravellerCostCodes;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.LazyValueHolder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class DefaultCostCodesInterceptor
implements EntityInterceptor {
    public double getPriority() {
        return 100.0;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) {
        if (!BookingFile.class.equals((Object)data.getEntityType())) {
            return;
        }
        EntityContainer<?> currentBookingFile = data;
        if (((BookingFile)currentBookingFile.getEntity()).getCustomerProfile() == null) {
            return;
        }
        EntityContainer oldBookingFile = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
        LazyValueHolder clientHolder = new LazyValueHolder(() -> EntityStorage.get().resolve(((BookingFile)currentBookingFile.getEntity()).getCustomerProfile()));
        List<BaseProduct> currentProducts = ((BookingFile)currentBookingFile.getEntity()).getReservations().stream().flatMap(res -> res.getProducts().stream()).filter(p -> ProductHandler.of((BaseProduct)p).isStatisticalDataAvailable(p)).collect(Collectors.toList());
        this.fillCommonCostCodes(currentProducts, (LazyValueHolder<EntityContainer<Organization>>)clientHolder, (EntityContainer<BookingFile>)oldBookingFile);
        if (DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.FILL_DEFAULT_COST_CODES, (boolean)false)) {
            for (BaseProduct currentProduct : currentProducts) {
                this.updateProductFromProfile(currentProduct, (ProductHandler<BaseProduct>)ProductHandler.of((BaseProduct)currentProduct), (LazyValueHolder<EntityContainer<Organization>>)clientHolder, (EntityContainer<BookingFile>)oldBookingFile);
            }
        }
        if (DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.FILL_DEFAULT_COST_CODES_FROM_PRODUCTS, (boolean)false)) {
            for (BaseProduct currentProduct : currentProducts) {
                this.updateProductFromOtherProducts(currentProduct, (ProductHandler<BaseProduct>)ProductHandler.of((BaseProduct)currentProduct), (LazyValueHolder<EntityContainer<Organization>>)clientHolder, currentBookingFile, (EntityContainer<BookingFile>)oldBookingFile);
            }
        }
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) {
    }

    private static List<CostCode> getCostCodesRelatedProduct(BaseProduct product, ProductHandler<BaseProduct> handler, Traveller traveller) {
        Product air;
        BaseProduct previousProduct;
        ProductStatus status = handler.getStatus(product);
        if (MiscUtil.equals((Object)ProductStatus.REFUND, (Object)status) && (previousProduct = handler.getPreviousProduct(product)) != null) {
            return StatisticsHelper.getProductCostCodes((BaseProduct)previousProduct, (Traveller)traveller);
        }
        if (ProductStatus.SELL == status && product instanceof Product && (air = (Product)product).getMcoCategory() != null) {
            return air.getRelatedProducts().stream().map(pr -> StatisticsHelper.getProductCostCodes((BaseProduct)pr, (Traveller)traveller)).filter(CollectionUtil::isNotEmpty).findFirst().orElse(Collections.emptyList());
        }
        return Collections.emptyList();
    }

    private void updateProductFromOtherProducts(BaseProduct currentProduct, ProductHandler<BaseProduct> handler, LazyValueHolder<EntityContainer<Organization>> clientHolder, EntityContainer<BookingFile> currentBookingFile, EntityContainer<BookingFile> oldBookingFile) {
        BaseProduct previousProduct;
        Collection currentTravellers = handler.getTravellers(currentProduct);
        if (currentTravellers.isEmpty()) {
            return;
        }
        if (oldBookingFile != null && (previousProduct = BookingHelper.findProductByUid((String)currentProduct.getUid(), (BookingFile)((BookingFile)oldBookingFile.getEntity()))) != null) {
            return;
        }
        StatisticalData currentStatisticalData = this.getStatisticalData(handler, currentProduct);
        List products = ((BookingFile)currentBookingFile.getEntity()).getReservations().stream().flatMap(res -> res.getProducts().stream()).filter(p -> !currentProduct.getUid().equals(p.getUid())).collect(Collectors.toList());
        EntityContainer client = (EntityContainer)clientHolder.get();
        if (client == null || ((Organization)client.getEntity()).getCostCodeProperties().isEmpty()) {
            return;
        }
        for (Traveller currentTraveller : currentTravellers) {
            TravellerCostCodes currentTravellerCostCodes = currentStatisticalData.getTravellerCostCodes().stream().filter(tcc -> currentTraveller.equals((Object)tcc.getTraveller())).findFirst().orElseGet(() -> {
                TravellerCostCodes travellerCostCodes = new TravellerCostCodes();
                travellerCostCodes.setTraveller(currentTraveller);
                currentStatisticalData.getTravellerCostCodes().add(travellerCostCodes);
                return travellerCostCodes;
            });
            for (BaseProduct product : products) {
                TravellerCostCodes travellerCostCodes;
                Collection travellers;
                Traveller traveller;
                List costCodes = currentTravellerCostCodes.getCostCodes();
                ProductHandler productHandler = ProductHandler.of((BaseProduct)product);
                StatisticalData statisticalData = productHandler.getStatisticalData(product);
                if (statisticalData == null || statisticalData.getTravellerCostCodes().isEmpty() || (traveller = (Traveller)(travellers = productHandler.getTravellers(product)).stream().filter(t -> t.equals((Object)currentTraveller)).findFirst().orElse(travellers.stream().filter(t -> MiscUtil.equals((Object)t.getPassenger(), (Object)currentTraveller.getPassenger(), (boolean)false)).findFirst().orElse(null))) == null || (travellerCostCodes = (TravellerCostCodes)statisticalData.getTravellerCostCodes().stream().filter(tcc -> traveller.equals((Object)tcc.getTraveller())).findFirst().orElse(null)) == null || travellerCostCodes.getCostCodes().isEmpty()) continue;
                List<CostCode> mergedCostCodes = this.mergeCostCodes(costCodes, travellerCostCodes.getCostCodes(), (EntityContainer<Organization>)client);
                currentTravellerCostCodes.getCostCodes().clear();
                currentTravellerCostCodes.getCostCodes().addAll(mergedCostCodes);
            }
        }
        currentStatisticalData.getTravellerCostCodes().removeIf(tcc -> tcc.getCostCodes().isEmpty());
    }

    private void updateProductFromProfile(BaseProduct currentProduct, ProductHandler<BaseProduct> handler, LazyValueHolder<EntityContainer<Organization>> clientHolder, EntityContainer<BookingFile> oldBookingFile) {
        BaseProduct previousProduct;
        Collection currentTravellers = handler.getTravellers(currentProduct);
        List currentPassengerProfiles = currentTravellers.stream().map(Traveller::getPassenger).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (currentPassengerProfiles.isEmpty()) {
            return;
        }
        StatisticalData statisticalData = handler.getStatisticalData(currentProduct);
        boolean isNewProduct = true;
        if (oldBookingFile != null && (previousProduct = BookingHelper.findProductByUid((String)currentProduct.getUid(), (BookingFile)((BookingFile)oldBookingFile.getEntity()))) != null) {
            isNewProduct = false;
            Collection previousTravellers = handler.getTravellers(previousProduct);
            List previousPassengerProfiles = previousTravellers.stream().map(Traveller::getPassenger).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (CollectionUtil.equals(currentPassengerProfiles, previousPassengerProfiles, (boolean)true)) {
                return;
            }
        }
        if (statisticalData == null) {
            handler.newStatisticalData(currentProduct);
            statisticalData = handler.getStatisticalData(currentProduct);
        }
        for (Traveller currentTraveller : currentTravellers) {
            List<CostCode> costCodes;
            TravellerCostCodes defaultCostCodes;
            if (currentTraveller.getPassenger() == null) continue;
            EntityContainer client = (EntityContainer)clientHolder.get();
            if (client == null || ((Organization)client.getEntity()).getCostCodeProperties().isEmpty()) {
                return;
            }
            EntityContainer person = EntityStorage.get().resolve(currentTraveller.getPassenger());
            if (person == null || (defaultCostCodes = this.getDefaultCostCodes((EntityContainer<Organization>)client, (EntityContainer<Person>)person, currentTraveller, costCodes = DefaultCostCodesInterceptor.getCostCodesRelatedProduct(currentProduct, handler, currentTraveller))).getCostCodes().isEmpty()) continue;
            TravellerCostCodes currentTravellerCostCodes = statisticalData.getTravellerCostCodes().stream().filter(tcc -> currentTraveller.equals((Object)tcc.getTraveller())).findFirst().orElse(null);
            if (currentTravellerCostCodes != null) {
                List<CostCode> mergedCostCodes = this.mergeCostCodes(currentTravellerCostCodes.getCostCodes(), defaultCostCodes.getCostCodes(), (EntityContainer<Organization>)client, isNewProduct);
                currentTravellerCostCodes.getCostCodes().clear();
                currentTravellerCostCodes.getCostCodes().addAll(mergedCostCodes);
                continue;
            }
            statisticalData.getTravellerCostCodes().add(defaultCostCodes);
        }
    }

    private void fillCommonCostCodes(List<BaseProduct> currentProducts, LazyValueHolder<EntityContainer<Organization>> clientHolder, EntityContainer<BookingFile> oldBookingFile) {
        EntityContainer client = (EntityContainer)clientHolder.get();
        if (client == null || ((Organization)client.getEntity()).getCostCodeProperties().isEmpty()) {
            return;
        }
        ArrayList<CostCode> commonCostCodes = new ArrayList<CostCode>();
        Map groupedCommonCostCodes = currentProducts.stream().map(p -> ProductHandler.of((BaseProduct)p).getStatisticalData(p)).filter(Objects::nonNull).map(StatisticsHelper::getAllCostCodes).flatMap(Collection::stream).filter(cc -> cc.getCostCodeProperties() != null && cc.getCostCodeProperties().isCommon() && (TextUtil.nonBlank((String)cc.getValue()) || TextUtil.nonBlank((String)cc.getLocalValue()) || TextUtil.nonBlank((String)cc.getEnglishValue()))).collect(Collectors.groupingBy(CostCode::getCostCodeProperties, Collectors.toList()));
        for (Map.Entry entry : groupedCommonCostCodes.entrySet()) {
            ArrayList costCodes = new ArrayList();
            entry.getValue().forEach(cc -> {
                if (costCodes.stream().noneMatch(c -> StatisticsHelper.equalsCostCodeValues((CostCode)c, (CostCode)cc, (int)1))) {
                    costCodes.add(cc);
                }
            });
            if (costCodes.size() != 1) continue;
            CostCode fulfilledCostCode = StatisticsHelper.getFulfilledCostCode((Collection)entry.getValue());
            CostCode costCode = new CostCode();
            costCode.setCostCodeProperties(entry.getKey());
            costCode.setValue(fulfilledCostCode.getValue());
            costCode.setLocalValue(fulfilledCostCode.getLocalValue());
            costCode.setEnglishValue(fulfilledCostCode.getEnglishValue());
            commonCostCodes.add(costCode);
        }
        if (commonCostCodes.isEmpty()) {
            return;
        }
        for (BaseProduct currentProduct : currentProducts) {
            BaseProduct previousProduct;
            if (oldBookingFile != null && (previousProduct = BookingHelper.findProductByUid((String)currentProduct.getUid(), (BookingFile)((BookingFile)oldBookingFile.getEntity()))) != null) continue;
            ProductHandler handler = ProductHandler.of((BaseProduct)currentProduct);
            StatisticalData statisticalData = this.getStatisticalData((ProductHandler<BaseProduct>)handler, currentProduct);
            Collection travellers = handler.getTravellers(currentProduct);
            for (Traveller traveller : travellers) {
                TravellerCostCodes travellerCostCodes = statisticalData.getTravellerCostCodes().stream().filter(tcc -> traveller.equals((Object)tcc.getTraveller())).findFirst().orElseGet(() -> {
                    TravellerCostCodes costCodes = new TravellerCostCodes();
                    costCodes.setTraveller(traveller);
                    statisticalData.getTravellerCostCodes().add(costCodes);
                    return costCodes;
                });
                List costCodes = travellerCostCodes.getCostCodes();
                List<CostCode> mergeCostCodes = this.mergeCostCodes(costCodes, commonCostCodes, (EntityContainer<Organization>)client);
                travellerCostCodes.getCostCodes().clear();
                travellerCostCodes.getCostCodes().addAll(mergeCostCodes);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private TravellerCostCodes getDefaultCostCodes(EntityContainer<Organization> client, EntityContainer<Person> person, Traveller traveller, List<CostCode> costCodes) {
        TravellerCostCodes travellerCostCodes = new TravellerCostCodes();
        travellerCostCodes.setTraveller(traveller);
        EntityReference clientReference = client.toReference();
        Date now = new Date();
        List clientCostCodes = ((Organization)client.getEntity()).getCostCodes();
        List personCostCodes = ((Person)person.getEntity()).getCostCodes();
        List clientCostCodeProperties = ((Organization)client.getEntity()).getCostCodeProperties().stream().filter(ccp -> StatisticsHelper.testCostCodeProperties((CostCodeProperties)ccp, (List)clientCostCodes, (List)personCostCodes, (Date)now, (cc, pcc) -> MiscUtil.equals((Object)pcc.getOrganization(), (Object)clientReference, (boolean)false) && MiscUtil.equals((Object)pcc.getCostCodeProperties(), (Object)cc.getCostCodeProperties(), (boolean)false), (cc, pcc) -> MiscUtil.equals((Object)pcc.getValue(), (Object)cc.getValue(), (boolean)false) || MiscUtil.equals((Object)pcc.getLocalValue(), (Object)cc.getLocalValue(), (boolean)false) || MiscUtil.equals((Object)pcc.getEnglishValue(), (Object)cc.getEnglishValue(), (boolean)false))).collect(Collectors.toList());
        Iterator iterator = clientCostCodeProperties.iterator();
        block0: while (true) {
            PersonCostCode personCostCode;
            Object localValue;
            CostCodeProperties costCodeProperties;
            if (!iterator.hasNext()) {
                Iterator iterator2 = clientCostCodeProperties.iterator();
                block1: while (true) {
                    if (!iterator2.hasNext()) {
                        return travellerCostCodes;
                    }
                    costCodeProperties = (CostCodeProperties)iterator2.next();
                    String sabreValue = costCodeProperties.getSabreValue();
                    String localValue2 = null;
                    String englishValue = null;
                    if (TextUtil.isBlank((String)sabreValue) && CollectionUtil.isNotEmpty(costCodes)) {
                        CostCode costCode;
                        localValue = costCodes.iterator();
                        do {
                            if (!localValue.hasNext()) continue block1;
                        } while (!TextUtil.nonBlank((String)(costCode = (CostCode)localValue.next()).getValue()) && !TextUtil.nonBlank((String)costCode.getLocalValue()) && !TextUtil.nonBlank((String)costCode.getEnglishValue()) || !StatisticsHelper.equalsCostCodeProperties((CostCodeProperties)costCode.getCostCodeProperties(), (CostCodeProperties)costCodeProperties));
                        sabreValue = costCode.getValue();
                        localValue2 = costCode.getLocalValue();
                        englishValue = costCode.getEnglishValue();
                    }
                    CostCode costCode = new CostCode();
                    costCode.setCostCodeProperties(costCodeProperties);
                    costCode.setValue(sabreValue);
                    costCode.setLocalValue(localValue2);
                    costCode.setEnglishValue(englishValue);
                    travellerCostCodes.getCostCodes().add(costCode);
                }
            }
            costCodeProperties = (CostCodeProperties)iterator.next();
            Iterator iterator3 = personCostCodes.iterator();
            do {
                if (!iterator3.hasNext()) continue block0;
            } while (!clientReference.equals((Object)(personCostCode = (PersonCostCode)iterator3.next()).getOrganization()) || !costCodeProperties.equals((Object)personCostCode.getCostCodeProperties()));
            String value = personCostCode.getValue();
            localValue = personCostCode.getLocalValue();
            String englishValue = personCostCode.getEnglishValue();
            CostCode clientCostCode = ProfileHelper.findCostCodeByValue((CostCodeProperties)costCodeProperties, (Collection)clientCostCodes, (String)value);
            if (TextUtil.isBlank((String)localValue) && clientCostCode != null) {
                localValue = clientCostCode.getLocalValue();
            }
            if (TextUtil.isBlank((String)englishValue) && clientCostCode != null) {
                englishValue = clientCostCode.getEnglishValue();
            }
            CostCode costCode = new CostCode();
            costCode.setCostCodeProperties(costCodeProperties);
            costCode.setValue(value);
            costCode.setLocalValue((String)localValue);
            costCode.setEnglishValue(englishValue);
            travellerCostCodes.getCostCodes().add(costCode);
            iterator.remove();
        }
    }

    private List<CostCode> mergeCostCodes(List<CostCode> oldCostCodes, List<CostCode> defaultCostCodes, EntityContainer<Organization> client, boolean isNewProduct) {
        return isNewProduct ? this.mergeCostCodes(oldCostCodes, defaultCostCodes, client) : this.mergeCostCodes(defaultCostCodes, oldCostCodes, client);
    }

    private List<CostCode> mergeCostCodes(List<CostCode> mainCostCodes, List<CostCode> addCostCodes, EntityContainer<Organization> client) {
        ArrayList<CostCode> newCostCodes = new ArrayList<CostCode>(mainCostCodes);
        addCostCodes.stream().filter(addCostCode -> ((Organization)client.getEntity()).getCostCodeProperties().contains(addCostCode.getCostCodeProperties()) && newCostCodes.stream().noneMatch(newCostCode -> StatisticsHelper.equalsCostCodeProperties((CostCodeProperties)addCostCode.getCostCodeProperties(), (CostCodeProperties)newCostCode.getCostCodeProperties()))).forEach(newCostCodes::add);
        newCostCodes.stream().filter(newCostCode -> TextUtil.isBlank((String)newCostCode.getValue())).forEach(newCostCode -> {
            CostCode costCode = addCostCodes.stream().filter(addCostCode -> StatisticsHelper.equalsCostCodeProperties((CostCodeProperties)addCostCode.getCostCodeProperties(), (CostCodeProperties)newCostCode.getCostCodeProperties())).filter(cc -> cc.getValue() != null || cc.getLocalValue() != null || cc.getEnglishValue() != null).findFirst().orElse(null);
            if (costCode != null) {
                newCostCode.setValue(costCode.getValue());
                newCostCode.setLocalValue(costCode.getLocalValue());
                newCostCode.setEnglishValue(costCode.getEnglishValue());
            }
        });
        newCostCodes.removeIf(costCode -> costCode.getCostCodeProperties().isDependant() && ((Organization)client.getEntity()).getCostCodes().stream().filter(cc -> cc.getRelatedCostCodeProperties().contains(costCode.getCostCodeProperties())).noneMatch(cc -> newCostCodes.stream().anyMatch(c -> StatisticsHelper.equalsCostCodeValues((CostCode)cc, (CostCode)c))));
        return newCostCodes;
    }

    private StatisticalData getStatisticalData(ProductHandler<BaseProduct> handler, BaseProduct product) {
        StatisticalData statisticalData = handler.getStatisticalData(product);
        if (statisticalData == null) {
            handler.newStatisticalData(product);
            statisticalData = handler.getStatisticalData(product);
        }
        return statisticalData;
    }
}

