/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.async.AsyncCommand;
import com.gridnine.xtrip.common.async.AsyncCommandOption;
import com.gridnine.xtrip.common.async.AsyncExecutor;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductSearchIndex;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.delivery.DeliveryItem;
import com.gridnine.xtrip.common.model.delivery.DeliveryItemType;
import com.gridnine.xtrip.common.model.delivery.DeliveryStatus;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.ShipmentIndex;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.Callback;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.LogicalStorageHelper;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumberHelper;
import com.gridnine.xtrip.server.model.interceptors.ProductsHelper;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeliveryInterceptor
implements EntityInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DeliveryInterceptor.class);
    private static final String KEY_UPDATE_SHIPMENT_INDEX_CALLBACK_ADDED = "key_update_shipment_index_callback_added";
    private static final String KEY_UPDATE_SHIPMENT_INDEX_SHIPMENT_LIST = "key_update_shipment_index_shipment_list";

    public double getPriority() {
        return 2.1;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!BookingFile.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        EntityContainer<?> bookingFileContainer = data;
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        for (Reservation res : bookingFile.getReservations()) {
            for (BaseProduct prod : res.getProducts()) {
                if (!(prod instanceof Delivery)) continue;
                Delivery product = (Delivery)prod;
                for (DeliveryItem item : product.getDeliveryItems()) {
                    NestedEntityReference itemProductReference;
                    if (item.getType() != DeliveryItemType.PRODUCT || (itemProductReference = (NestedEntityReference)item.getObject()) == null) continue;
                    this.updateProductIndex(itemProductReference.getNestedEntityUid(), ss);
                }
            }
        }
        this.updateFinanceDocument(null, bookingFileContainer, ss);
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!BookingFile.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        EntityContainer<?> bookingFileContainer = data;
        EntityContainer oldBookingFileContainer = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        for (Reservation res : bookingFile.getReservations()) {
            for (BaseProduct prod : res.getProducts()) {
                if (!(prod instanceof Delivery)) continue;
                Delivery product = (Delivery)prod;
                boolean isNewProduct = ProductsHelper.isNewProduct((EntityContainer<BookingFile>)oldBookingFileContainer, (BaseProduct)product);
                this.updateProduct(product, ss, isNewProduct);
            }
        }
        this.updateFinanceDocument(bookingFileContainer, (EntityContainer<BookingFile>)oldBookingFileContainer, ss);
    }

    private void updateProduct(Delivery product, SessionCallback ss, boolean isNewProduct) throws Exception {
        this.updateBranch(product);
        for (DeliveryItem item : product.getDeliveryItems()) {
            NestedEntityReference itemProductReference;
            if (item.getType() != DeliveryItemType.PRODUCT || (itemProductReference = (NestedEntityReference)item.getObject()) == null) continue;
            this.updateProductIndex(itemProductReference.getNestedEntityUid(), ss);
        }
        if (TextUtil.isBlank((String)product.getSystemNumber())) {
            this.updateSystemNumber(product);
        }
        if (product.getStatus() == null) {
            product.setStatus(DeliveryStatus.PLANNED);
        }
        if (product.getLocalIssueDate() == null) {
            product.setLocalIssueDate(product.getIssueDate());
        }
        if (product.getReservation().getBookingFile().getAgency() == null) {
            product.getReservation().getBookingFile().setAgency(product.getAgency());
        }
        if (product.getReservation().getBookingFile().getCustomerProfile() == null && product.getAddressee() != null && Organization.class.equals((Object)product.getAddressee().getType())) {
            product.getReservation().getBookingFile().setCustomerProfile(product.getAddressee());
        }
    }

    private void updateSystemNumber(final Delivery product) throws Exception {
        SequenceNumberHelper.get().generateInc(new CompositeNumber(){

            public void setNumberSuffix(String value) {
            }

            public void setNumberPrefix(String value) {
            }

            public void setNumber(String value) {
                product.setSystemNumber(value);
            }

            public String getNumberSuffix() {
                return null;
            }

            public String getNumberPrefix() {
                return null;
            }

            public String getNumber() {
                return product.getSystemNumber();
            }
        }, Delivery.class.getName(), null);
    }

    private void updateBranch(Delivery product) throws Exception {
        if (product.getBranch() != null) {
            return;
        }
        EntityContainer salesPointContainer = EntityStorage.get().resolve(product.getSalesPoint());
        if (salesPointContainer != null) {
            product.setBranch(((SalesPoint)salesPointContainer.getEntity()).getBranch());
        }
    }

    private void updateProductIndex(String productUid, SessionCallback ss) throws Exception {
        final HashSet<EntityReference> relatedBookings = new HashSet<EntityReference>();
        SearchQuery searchQuery = new SearchQuery();
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductSearchIndex.Property.productUid.name(), (Object)productUid));
        List relatedProductSearchIndexes = EntityStorage.get().search(ProductSearchIndex.class, searchQuery).getData();
        for (ProductSearchIndex relatedProductSearchIndex : relatedProductSearchIndexes) {
            relatedBookings.add(relatedProductSearchIndex.getSource());
        }
        ss.addCallback(new Callback(){
            private static final long serialVersionUID = -7864016444896474082L;

            public void execute(SessionCallback ss1) {
                for (EntityReference relatedBooking : relatedBookings) {
                    try {
                        LoggerFactory.getLogger(this.getClass()).debug("rebuilding index of " + relatedBooking);
                        EntityContainer ctr = EntityStorage.get().resolve(relatedBooking);
                        LogicalStorage.get().getEntityStorage().updateIndexes(ss1, ctr, ctr);
                    }
                    catch (Exception e) {
                        LoggerFactory.getLogger(this.getClass()).error("unable to rebuild index of " + relatedBooking, (Throwable)e);
                    }
                }
            }
        });
    }

    private void updateFinanceDocument(EntityContainer<BookingFile> bookingFileContainer, EntityContainer<BookingFile> oldBookingFileContainer, SessionCallback ss) throws Exception {
        HashMap<String, MiscUtil.Pair> financeDocuments = new HashMap<String, MiscUtil.Pair>();
        if (bookingFileContainer != null) {
            financeDocuments.clear();
            financeDocuments.putAll(((BookingFile)bookingFileContainer.getEntity()).getReservations().stream().flatMap(item -> item.getProducts().stream()).filter(item -> item instanceof Delivery).flatMap(item -> ((Delivery)item).getDeliveryItems().stream().filter(deliveryItem -> deliveryItem.getType() == DeliveryItemType.FINANCE_DOCUMENT && deliveryItem.getObject() != null).map(deliveryItem -> new MiscUtil.Pair((Object)new NestedEntityReference(bookingFileContainer, (BaseEntity)item, ProductHandler.of((BaseProduct)item).generateShortProductName(item)), (Object)((EntityReference)deliveryItem.getObject())))).collect(Collectors.toMap(item -> ((EntityReference)item.getSecond()).getUid(), item -> item)));
        }
        HashMap<String, MiscUtil.Pair> oldFinanceDocuments = new HashMap<String, MiscUtil.Pair>();
        if (oldBookingFileContainer != null) {
            oldFinanceDocuments.clear();
            oldFinanceDocuments.putAll(((BookingFile)oldBookingFileContainer.getEntity()).getReservations().stream().flatMap(item -> item.getProducts().stream()).filter(item -> item instanceof Delivery).flatMap(item -> ((Delivery)item).getDeliveryItems().stream().filter(deliveryItem -> deliveryItem.getType() == DeliveryItemType.FINANCE_DOCUMENT && deliveryItem.getObject() != null).map(deliveryItem -> new MiscUtil.Pair((Object)new NestedEntityReference(oldBookingFileContainer, (BaseEntity)item, ProductHandler.of((BaseProduct)item).generateShortProductName(item)), (Object)((EntityReference)deliveryItem.getObject())))).collect(Collectors.toMap(item -> ((EntityReference)item.getSecond()).getUid(), item -> item)));
        }
        ChangeData<Object, Object> changeData = new ChangeData<Object, Object>();
        Set uids = Stream.concat(financeDocuments.keySet().stream(), oldFinanceDocuments.keySet().stream()).collect(Collectors.toSet());
        for (String uid : uids) {
            MiscUtil.Pair financeDocument = (MiscUtil.Pair)financeDocuments.get(uid);
            MiscUtil.Pair oldFinanceDocument = (MiscUtil.Pair)oldFinanceDocuments.get(uid);
            if (financeDocument != null && oldFinanceDocument != null) {
                if (MiscUtil.equals((Object)financeDocument.getSecond(), (Object)oldFinanceDocument.getSecond())) continue;
                changeData.addChange(financeDocument.getSecond(), financeDocument.getFirst(), ChangeType.SET);
                changeData.addChange(oldFinanceDocument.getSecond(), oldFinanceDocument.getFirst(), ChangeType.CLEAR);
                continue;
            }
            if (financeDocument != null && oldFinanceDocument == null) {
                changeData.addChange(financeDocument.getSecond(), financeDocument.getFirst(), ChangeType.SET);
                continue;
            }
            if (financeDocument != null || oldFinanceDocument == null) continue;
            changeData.addChange(oldFinanceDocument.getSecond(), oldFinanceDocument.getFirst(), ChangeType.CLEAR);
        }
        if (changeData.getChanges().size() == 0) {
            return;
        }
        final Set shipments = (Set)LogicalStorage.get().getEntityStorage().getGlobalOperationContext().getParameters().computeIfAbsent(KEY_UPDATE_SHIPMENT_INDEX_SHIPMENT_LIST, key -> new HashSet());
        EntityStorageContext storageContext = LogicalStorageHelper.getEntityStorageContext();
        for (Change change : changeData.getChanges()) {
            EntityReference financeDocumentReference = (EntityReference)change.getObject();
            NestedEntityReference productReference = (NestedEntityReference)change.getSupplement();
            ChangeType type = change.getType();
            EntityContainer financeDocumentContainer = EntityStorageHelper.resolve((EntityReference)financeDocumentReference, (EntityStorageContext)storageContext);
            if (financeDocumentContainer == null) continue;
            FinanceDocument financeDocument = (FinanceDocument)financeDocumentContainer.getEntity();
            if (type == ChangeType.SET) {
                if (financeDocument.getDelivery() != null) {
                    if (MiscUtil.equals((Object)financeDocument.getDelivery(), (Object)productReference)) continue;
                    throw new Exception(String.format("finance document %s already included to delivery %s", financeDocumentReference, productReference));
                }
                financeDocument.setDelivery(productReference);
                financeDocumentContainer.getVersionInfo().setDataSource("delivery-interceptor-set-delivery");
                shipments.addAll(financeDocument.getRelatedShipments());
            } else if (type == ChangeType.CLEAR) {
                if (financeDocument.getDelivery() == null) continue;
                financeDocument.setDelivery(null);
                financeDocumentContainer.getVersionInfo().setDataSource("delivery-interceptor-clear-delivery");
                shipments.addAll(financeDocument.getRelatedShipments());
            }
            EntityStorage.get().save(financeDocumentContainer, true);
        }
        if (Boolean.TRUE.equals(LogicalStorage.get().getEntityStorage().getGlobalOperationContext().getParameters().get(KEY_UPDATE_SHIPMENT_INDEX_CALLBACK_ADDED))) {
            return;
        }
        LogicalStorage.get().getEntityStorage().getGlobalOperationContext().getParameters().put(KEY_UPDATE_SHIPMENT_INDEX_CALLBACK_ADDED, Boolean.TRUE);
        ss.addCallback(new Callback(){
            private static final long serialVersionUID = 4972785354747690919L;

            public void execute(SessionCallback ss1) {
                AsyncExecutor.get().execute(this.getClass().getName(), (AsyncCommand & Serializable)() -> {
                    for (EntityReference shipment : shipments) {
                        try {
                            EntityContainer shipmentContainer = EntityStorage.get().resolve(shipment);
                            LogicalStorage.get().getEntityStorage().updateIndexes(shipmentContainer, shipmentContainer, Collections.singleton(ShipmentIndex.class), false);
                        }
                        catch (Exception e) {
                            log.error("unable to rebuild shipment index of " + shipment, (Throwable)e);
                        }
                    }
                }, new AsyncCommandOption[0]);
            }
        });
    }

    static enum ChangeType {
        SET,
        CLEAR;

    }

    static class Change<O, S>
    implements Serializable {
        private static final long serialVersionUID = 2049911998811487863L;
        private ChangeType type;
        private O object;
        private S supplement;

        Change() {
        }

        public ChangeType getType() {
            return this.type;
        }

        public void setType(ChangeType type) {
            this.type = type;
        }

        public O getObject() {
            return this.object;
        }

        public void setObject(O object) {
            this.object = object;
        }

        public S getSupplement() {
            return this.supplement;
        }

        public void setSupplement(S supplement) {
            this.supplement = supplement;
        }
    }

    static class ChangeData<O, S>
    implements Serializable {
        private static final long serialVersionUID = -6927654307334766241L;
        private final Map<O, Change<O, S>> changes = new HashMap<O, Change<O, S>>();

        ChangeData() {
        }

        public Collection<Change<O, S>> getChanges() {
            return this.changes.values();
        }

        public void addChange(O object, S supplement, ChangeType type) {
            Change change = this.changes.computeIfAbsent(object, key -> new Change());
            if (type == ChangeType.SET) {
                change.setObject(object);
                change.setSupplement(supplement);
                change.setType(type);
            } else if (type == ChangeType.CLEAR && change.getType() != ChangeType.SET) {
                change.setObject(object);
                change.setSupplement(supplement);
                change.setType(type);
            }
        }
    }
}

