/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.jms.messages.standard.EntityExportMessage;
import com.gridnine.xtrip.common.model.booking.jms.messages.standard.Operation;
import com.gridnine.xtrip.common.model.export.xml.XMLEntityExportHelper;
import com.gridnine.xtrip.common.model.export.xml.XMLFilterHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.ServerApplication;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.jms.JMSFacade;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.java.plugin.util.ExtendedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class EntitiesExportInterceptor
implements EntityInterceptor {
    protected static final Logger log = LoggerFactory.getLogger(EntitiesExportInterceptor.class);
    private static final String ENTITY_EXPORT_FILE_ENABLED_PROPERTY_NAME = "entity.exporter.file.enabled";
    private static final String ENTITY_EXPORT_FILE_TYPE_PROPERTY_NAME = "entity.exporter.file.type";
    private static final String ENTITY_EXPORT_FILE_PATH_PROPERTY_NAME = "entity.exporter.file.path";
    private static final String ENTITY_EXPORT_FILE_FILTER_FILE_PROPERTY_NAME = "entity.exporter.file.filter.file";
    private static final String ENTITY_EXPORT_FILE_FILTER_EXCLUSIVE_PROPERTY_NAME = "entity.exporter.file.filter.exclusive";
    private static final String ENTITY_EXPORT_JMS_ENABLED_PROPERTY_NAME = "entity.exporter.jms.enabled";
    private static final String ENTITY_EXPORT_JMS_TYPE_PROPERTY_NAME = "entity.exporter.jms.type";
    private static final String ENTITY_EXPORT_JMS_FILTER_FILE_PROPERTY_NAME = "entity.exporter.jms.filter.file";
    private static final String ENTITY_EXPORT_JMS_FILTER_EXCLUSIVE_PROPERTY_NAME = "entity.exporter.jms.filter.exclusive";
    private static final String ENABLED_PROPERTY_NAME = "entity.exporter.enabled";
    private static final String TYPES_PROPERTY_NAME = "entity.exporter.types";
    private final Lock lock = new ReentrantLock(true);

    public double getPriority() {
        return 2.147483647E9;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
        this.exportJms(data, true);
        this.exportOld(data, true);
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        this.exportFile(data, false);
        this.exportJms(data, false);
        this.exportOld(data, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportFile(EntityContainer<?> entityContainer, boolean delete) throws Exception {
        File folder;
        EntityContainer oldEntityContainer;
        log.debug(String.format("preparing entity export (file) %s", entityContainer.toReference()));
        if (!Environment.isPublished(ServerApplication.class)) {
            return;
        }
        ExtendedProperties serverProperties = ((ServerApplication)Environment.getPublished(ServerApplication.class)).getConfiguration();
        String enabledString = serverProperties.getProperty(ENTITY_EXPORT_FILE_ENABLED_PROPERTY_NAME, null);
        boolean enabled = !TextUtil.isBlank((String)enabledString) && enabledString.trim().equalsIgnoreCase("true");
        log.debug(String.format("entity export (file) service enabled %s", String.valueOf(enabled)));
        if (!enabled) {
            return;
        }
        ArrayList<String> types = new ArrayList<String>();
        for (Object value : serverProperties.getSubset(ENTITY_EXPORT_FILE_TYPE_PROPERTY_NAME).values()) {
            String type = ((String)value).trim();
            if (types.contains(type)) continue;
            types.add(type);
        }
        if (!types.contains(entityContainer.getEntityType().getName())) {
            return;
        }
        log.debug(String.format("starting entity export (file) %s", entityContainer.toReference()));
        Operation operation = null;
        operation = delete ? Operation.DELETE : ((oldEntityContainer = LogicalStorage.get().getEntityStorage().getLocalOperationContext(entityContainer.toReference()).getOldCtr()) != null ? Operation.UPDATE : Operation.ADD);
        log.debug(String.format("entity export (file) operation %s", operation));
        String filterFile = serverProperties.getProperty(ENTITY_EXPORT_FILE_FILTER_FILE_PROPERTY_NAME, null);
        String filterExclusiveString = serverProperties.getProperty(ENTITY_EXPORT_FILE_FILTER_EXCLUSIVE_PROPERTY_NAME, null);
        boolean filterExclusive = TextUtil.isBlank((String)filterExclusiveString) || !filterExclusiveString.trim().equalsIgnoreCase("false");
        List filters = XMLFilterHelper.getFilters();
        if (!TextUtil.isBlank((String)filterFile)) {
            try {
                if (filterExclusive) {
                    filters.add(XMLFilterHelper.createExclusiveFilter((String)filterFile));
                } else {
                    filters.add(XMLFilterHelper.createInclusiveFilter((String)filterFile));
                }
            }
            catch (IOException e) {
                log.warn(String.format("entity export (file) filter file \"%s\" was not found", filterFile), (Throwable)e);
            }
        }
        ArrayList messages = new ArrayList();
        Document document = XMLEntityExportHelper.export((BaseEntity)entityContainer.getEntity(), (List)filters, messages);
        if (document == null || MessageHelper.hasErrorMessages(messages)) {
            log.debug(String.format("entity export (file) unable to create document of entity %s", entityContainer.toReference()));
            return;
        }
        String exportPath = serverProperties.getProperty(ENTITY_EXPORT_FILE_PATH_PROPERTY_NAME, null);
        File file = folder = !TextUtil.isBlank((String)exportPath) ? new File(exportPath) : new File(Environment.getDataFolder(), "export/entities");
        if (!folder.isDirectory()) {
            folder.mkdirs();
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        Date date = new Date();
        int count = 1;
        String fileName = String.format("%s_%s.xml", entityContainer.getEntityType().getName(), format.format(date));
        File file2 = new File(folder, fileName);
        if (!file2.createNewFile()) {
            this.lock.lock();
            try {
                while (!file2.createNewFile()) {
                    fileName = String.format("%s_%s_%s.xml", entityContainer.getEntityType().getName(), format.format(date), String.valueOf(count));
                    file2 = new File(folder, fileName);
                    ++count;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        try (FileOutputStream outputStream = null;){
            outputStream = new FileOutputStream(file2);
            Transformer transformer = XUtil.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new DOMSource(document), new StreamResult(outputStream));
            outputStream.flush();
            log.info(String.format("entity export (file) entity %s (%s) was exported successfully to the file %s", entityContainer.toReference(), operation, file2.getName()));
            if (entityContainer.getEntityType().getName().equals(BookingFile.class.getName())) {
                SysLogHelper.audit(entityContainer.toReference(), "entity-modification", SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)L10nResourcesManager.getStr((String)Messages.BookingFileExportInterceptor_orderSuccessfullyExport, (Object[])new Object[]{file2.getName()}), (Object[])new Object[0]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportJms(EntityContainer<?> entityContainer, boolean delete) throws Exception {
        EntityContainer oldEntityContainer;
        log.debug(String.format("preparing entity export (jms) %s", entityContainer.toReference()));
        if (!Environment.isPublished(ServerApplication.class)) {
            return;
        }
        ExtendedProperties serverProperties = ((ServerApplication)Environment.getPublished(ServerApplication.class)).getConfiguration();
        String enabledString = serverProperties.getProperty(ENTITY_EXPORT_JMS_ENABLED_PROPERTY_NAME, null);
        boolean enabled = !TextUtil.isBlank((String)enabledString) && enabledString.trim().equalsIgnoreCase("true");
        log.debug(String.format("entity export (jms) service enabled %s", String.valueOf(enabled)));
        if (!enabled) {
            return;
        }
        ArrayList<String> types = new ArrayList<String>();
        for (Object value : serverProperties.getSubset(ENTITY_EXPORT_JMS_TYPE_PROPERTY_NAME).values()) {
            String type = ((String)value).trim();
            if (types.contains(type)) continue;
            types.add(type);
        }
        if (!types.contains(entityContainer.getEntityType().getName())) {
            return;
        }
        log.debug(String.format("starting entity export (jms) %s", entityContainer.toReference()));
        Operation operation = null;
        operation = delete ? Operation.DELETE : ((oldEntityContainer = LogicalStorage.get().getEntityStorage().getLocalOperationContext(entityContainer.toReference()).getOldCtr()) != null ? Operation.UPDATE : Operation.ADD);
        log.debug(String.format("entity export (jms) operation %s", operation));
        String filterFile = serverProperties.getProperty(ENTITY_EXPORT_JMS_FILTER_FILE_PROPERTY_NAME, null);
        String filterExclusiveString = serverProperties.getProperty(ENTITY_EXPORT_JMS_FILTER_EXCLUSIVE_PROPERTY_NAME, null);
        boolean filterExclusive = TextUtil.isBlank((String)filterExclusiveString) || !filterExclusiveString.trim().equalsIgnoreCase("false");
        List filters = XMLFilterHelper.getFilters();
        if (!TextUtil.isBlank((String)filterFile)) {
            try {
                if (filterExclusive) {
                    filters.add(XMLFilterHelper.createExclusiveFilter((String)filterFile));
                } else {
                    filters.add(XMLFilterHelper.createInclusiveFilter((String)filterFile));
                }
            }
            catch (IOException e) {
                log.warn(String.format("entity export (jms) filter file \"%s\" was not found", filterFile), (Throwable)e);
            }
        }
        EntityExportMessage message = new EntityExportMessage();
        message.setOperation(operation);
        message.setEntity(entityContainer.getEntity());
        ArrayList messages = new ArrayList();
        Document document = XMLEntityExportHelper.export((BaseEntity)message, (List)XMLFilterHelper.getFilters(), messages);
        if (document == null || MessageHelper.hasErrorMessages(messages)) {
            log.debug(String.format("entity export (jms) unable to create document of message for entity %s", entityContainer.toReference()));
            return;
        }
        try (StringWriter writer = null;){
            writer = new StringWriter();
            Transformer transformer = XUtil.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new DOMSource(document), new StreamResult(writer));
            writer.flush();
            log.debug(String.format("entity export (jms) document of message for entity %s created", entityContainer.toReference()));
            String content = writer.toString();
            ((JMSFacade)Environment.getPublished(JMSFacade.class)).publishMessageAsync("entity-export", (Object)content);
            log.debug(String.format("entity export (jms) entity %s (%s) content: %s", entityContainer.toReference(), operation, content));
            log.info(String.format("entity export (jms) entity %s (%s) was exported successfully", entityContainer.toReference(), operation));
            if (entityContainer.getEntityType().getName().equals(BookingFile.class.getName())) {
                SysLogHelper.audit(entityContainer.toReference(), "entity-modification", SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)L10nResourcesManager.getStr((String)Messages.EntitiesExportInterceptor_orderSuccessfullyExportJms, (Object[])new Object[0]), (Object[])new Object[0]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportOld(EntityContainer<?> entityContainer, boolean delete) throws Exception {
        EntityContainer oldEntityContainer;
        log.debug(String.format("preparing export entity %s", entityContainer.toReference()));
        if (!Environment.isPublished(ServerApplication.class)) {
            return;
        }
        ExtendedProperties serverProperties = ((ServerApplication)Environment.getPublished(ServerApplication.class)).getConfiguration();
        String enabledString = serverProperties.getProperty(ENABLED_PROPERTY_NAME, null);
        boolean enabled = !TextUtil.isBlank((String)enabledString) && enabledString.trim().equalsIgnoreCase("true");
        log.debug(String.format("entity export service enabled %s", String.valueOf(enabled)));
        if (!enabled) {
            return;
        }
        String typesString = serverProperties.getProperty(TYPES_PROPERTY_NAME, null);
        if (TextUtil.isBlank((String)typesString)) {
            return;
        }
        List types = TextUtil.split((String)typesString, (String)",", (boolean)true, (boolean)true);
        if (!types.contains(entityContainer.getEntityType().getName())) {
            return;
        }
        log.debug(String.format("starting export entity %s", entityContainer.toReference()));
        Operation operation = null;
        operation = delete ? Operation.DELETE : ((oldEntityContainer = LogicalStorage.get().getEntityStorage().getLocalOperationContext(entityContainer.toReference()).getOldCtr()) != null ? Operation.UPDATE : Operation.ADD);
        log.debug(String.format("entity operation %s", operation));
        BaseEntity entity = entityContainer.getEntity();
        EntityExportMessage message = new EntityExportMessage();
        message.setOperation(operation);
        message.setEntity(entity);
        try (StringWriter writer = null;){
            ArrayList messages = new ArrayList();
            Document document = XMLEntityExportHelper.export((BaseEntity)message, (List)XMLFilterHelper.getFilters(), messages);
            if (document == null || MessageHelper.hasErrorMessages(messages)) {
                log.debug(String.format("unable to create document of message for entity %s", entityContainer.toReference()));
                return;
            }
            writer = new StringWriter();
            Transformer transformer = XUtil.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new DOMSource(document), new StreamResult(writer));
            writer.flush();
            log.debug(String.format("document of message for entity %s created", entityContainer.toReference()));
            String content = writer.toString();
            ((JMSFacade)Environment.getPublished(JMSFacade.class)).publishMessageAsync("entity-export", (Object)content);
            log.debug(String.format("entity %s (%s) content: %s", entityContainer.toReference(), operation, content));
            log.info(String.format("entity %s (%s) was exported successfully", entityContainer.toReference(), operation));
        }
    }
}

