/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.SysLogItem;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;

public class EntityDeleteInterceptor
implements EntityInterceptor {
    public double getPriority() {
        return 1000.0;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
        SearchQuery query;
        if (!(data.getEntity() instanceof BaseFileDocument)) {
            BaseFileDocument doc;
            EntityContainer ctr;
            query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), (Object)data.toReference()));
            query.getPreferredProperties().add(BasicDocumentIndex.Property.owner.name());
            EntityStorage es = EntityStorage.get();
            for (BasicDocumentIndex index : es.search(BasicDocumentIndex.class, query).getData()) {
                ctr = es.resolve(index.getSource());
                if (ctr == null || !(ctr.getEntity() instanceof BaseFileDocument)) continue;
                doc = (BaseFileDocument)ctr.getEntity();
                if (doc.isDeleteWithOwner()) {
                    es.delete(ctr);
                    continue;
                }
                ctr.getVersionInfo().setDataSource("delete owner");
                doc.setOwner(null);
                es.save(ctr, true);
            }
            query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)BasicDocumentIndex.Property.ownersUids.name(), (Object)data.toReference()));
            query.getPreferredProperties().add(BasicDocumentIndex.Property.ownersUids.name());
            for (BasicDocumentIndex index : es.search(BasicDocumentIndex.class, query).getData()) {
                ctr = es.resolve(index.getSource());
                if (ctr == null || !(ctr.getEntity() instanceof BaseFileDocument)) continue;
                doc = (BaseFileDocument)ctr.getEntity();
                if (doc.isDeleteWithOwner() && doc.getOwners().size() < 2) {
                    es.delete(ctr);
                    continue;
                }
                ctr.getVersionInfo().setDataSource("delete owner");
                doc.getOwners().remove(data.toReference());
                es.save(ctr, true);
            }
        }
        query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)SysLogItem.Property.referenceType.name(), (Object)data.getEntityType().getName()));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)SysLogItem.Property.referenceUid.name(), (Object)data.getUid()));
        query.getPreferredProperties().add(BaseAsset.Property.uid.name());
        AssetsStorage as = AssetsStorage.get();
        for (SysLogItem item : as.search(SysLogItem.class, query).getData()) {
            as.delete((BaseAsset)item);
        }
    }
}

