/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.BaseContract;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.EventNotificationIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.db.Callback;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import java.io.Serializable;
import java.util.List;

public class EventNotificationCleanupInterceptor
implements EntityInterceptor {
    public double getPriority() {
        return 1500.0;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (this.isApplicable(data.getEntity())) {
            ss.addCallback((Callback & Serializable)callback -> {
                SearchQuery query = new SearchQuery();
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)EventNotificationIndex.Property.entityReference.name(), (Object)data.toReference()));
                List notificationIndexList = EntityStorage.get().search(EventNotificationIndex.class, query).getData();
                for (EventNotificationIndex notificationIndex : notificationIndexList) {
                    EntityStorage.get().delete(notificationIndex.getSource());
                }
            });
        }
    }

    private boolean isApplicable(BaseEntity entity) {
        return entity instanceof Person || entity instanceof BaseContract;
    }
}

