/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsSettings;
import com.gridnine.xtrip.common.model.finance.FinanceInitializationData;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinanceInitializationDataInterceptor
implements EntityInterceptor {
    static final Logger log = LoggerFactory.getLogger(FinanceInitializationDataInterceptor.class);

    public double getPriority() {
        return 0.0;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (Organization.class.isAssignableFrom(data.getEntityType())) {
            EntityContainer<?> organizationContainer = data;
            EntityContainer oldOrgCtr = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
            boolean isCreating = oldOrgCtr == null;
            log.debug(String.format("finance initialization data %s -> save", this.getTitle((EntityReference<Organization>)organizationContainer.toReference())));
            EntityReference initializationDataReference = FinanceHelper.getFinanceInitializationData((EntityReference)organizationContainer.toReference());
            log.info(String.format("finance initialization data %s -> save -> finance initialization data found %s", this.getTitle((EntityReference<Organization>)organizationContainer.toReference()), String.valueOf(initializationDataReference != null)));
            if (initializationDataReference != null) {
                return;
            }
            EntityContainer chartOfAccountsSettingsContainer = EntityStorage.get().resolve(FinanceHelper.getChartOfAccountsSettings(organizationContainer, (boolean)false));
            log.info(String.format("finance initialization data %s -> save -> chart of accounts settings found %s", this.getTitle((EntityReference<Organization>)organizationContainer.toReference()), String.valueOf(chartOfAccountsSettingsContainer != null)));
            if (chartOfAccountsSettingsContainer == null) {
                return;
            }
            ChartOfAccountsSettings chartOfAccountsSettings = (ChartOfAccountsSettings)chartOfAccountsSettingsContainer.getEntity();
            if (FinanceHelper.isChartOfAccountsSettingsDisabled((ChartOfAccountsSettings)chartOfAccountsSettings)) {
                log.info(String.format("finance initialization data %s -> save -> chart of accounts settings disabled", this.getTitle((EntityReference<Organization>)organizationContainer.toReference())));
                return;
            }
            log.info(String.format("finance initialization data %s -> save -> creating data", this.getTitle((EntityReference<Organization>)organizationContainer.toReference())));
            FinanceInitializationData initializationData = new FinanceInitializationData();
            initializationData.setOrganization(organizationContainer.toReference());
            initializationData.setDate(MiscUtil.clearTime((Date)new Date()));
            if (isCreating) {
                initializationData.setUseNewFinanceModuleOnly(true);
            }
            EntityContainer financeInitializationDataContainer = EntityContainer.create((BaseEntity)initializationData);
            financeInitializationDataContainer.getVersionInfo().setDataSource("FinanceInitializationDataInterceptor");
            EntityStorage.get().save(financeInitializationDataContainer, true);
            log.info(String.format("finance initialization data %s -> saved -> %s", this.getTitle((EntityReference<Organization>)organizationContainer.toReference()), financeInitializationDataContainer.getUid()));
        }
    }

    private String getTitle(EntityReference<Organization> organization) {
        return String.format("%s (%s)", organization, organization.getUid());
    }
}

