/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class FopPayerInterceptor
implements EntityInterceptor {
    public static final double PRIORITY = 4.0;

    public double getPriority() {
        return 4.0;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) {
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) {
        if (!BookingFile.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        BookingFile bookingFile = (BookingFile)data.getEntity();
        BookingFile oldBookingFile = Optional.ofNullable(LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr()).map(item -> (BookingFile)item.getEntity()).orElse(null);
        List products = bookingFile.getReservations().stream().flatMap(item -> item.getProducts().stream()).collect(Collectors.toList());
        for (BaseProduct product : products) {
            BaseProduct oldProduct = oldBookingFile != null ? (BaseProduct)oldBookingFile.getReservations().stream().flatMap(item -> item.getProducts().stream()).filter(item -> MiscUtil.equals((Object)item, (Object)product)).findFirst().orElse(null) : null;
            List contractRelations = ProductHandler.of((BaseProduct)product).getUnmodifiableContractRelations(product);
            boolean update = false;
            for (GeneralProductContractRelationData contractRelation : contractRelations) {
                EntityReference oldCustomer;
                EntityReference customer;
                GeneralProductContractRelationData oldContractRelation = oldProduct != null ? (GeneralProductContractRelationData)ProductHandler.of((BaseProduct)oldProduct).getUnmodifiableContractRelations(oldProduct).stream().filter(item -> MiscUtil.equals((Object)item, (Object)contractRelation)).findFirst().orElse(null) : null;
                EntityReference entityReference = customer = GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription()) == ContractType.CLIENT ? bookingFile.getCustomerProfile() : GeneralProductHelper.getContractRelationCustomer((EntityReference)contractRelation.getDescription(), (SalesChain)ProductHandler.of((BaseProduct)product).getSalesChain(product));
                EntityReference entityReference2 = oldContractRelation != null ? (GeneralProductHelper.getContractType((EntityReference)oldContractRelation.getDescription()) == ContractType.CLIENT ? oldBookingFile.getCustomerProfile() : GeneralProductHelper.getContractRelationCustomer((EntityReference)oldContractRelation.getDescription(), (SalesChain)ProductHandler.of((BaseProduct)oldProduct).getSalesChain(oldProduct))) : (oldCustomer = null);
                if (customer == null) continue;
                for (GeneralProductFop fop : contractRelation.getFops()) {
                    boolean includedToShipment = product.getFopDetalizations().entrySet().stream().filter(item -> MiscUtil.equals(item.getKey(), (Object)fop.getUid())).flatMap(item -> ((FopDetalization)item.getValue()).getComponents().stream()).anyMatch(item -> item.getShipment() != null);
                    if (includedToShipment || fop.getPayer() != null && (MiscUtil.equals((Object)customer, (Object)oldCustomer) || !MiscUtil.equals((Object)fop.getPayer(), (Object)oldCustomer))) continue;
                    fop.setPayer(customer);
                    update = true;
                }
            }
            if (!update) continue;
            ProductHandler.of((BaseProduct)product).updateContractRelations(product, contractRelations);
        }
    }
}

