/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.XCompareHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.model.helpers.ShipmentHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class FreezeProductClientPartInterceptor
implements EntityInterceptor {
    public static final String SHIPMENT_CHECK_ENABLED = "com.gridnine.xtrip.server.model.interceptors.FreezeProductClientPartInterceptor.enabled";
    private static final Set<String> DATA_SOURCES_TO_IGNORE = new HashSet<String>();

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (this.isDisabled() || this.ignore(data)) {
            return;
        }
        EntityStorageContext storageContext = new EntityStorageContext();
        if (BookingFile.class.equals((Object)data.getEntityType())) {
            EntityContainer oldCtr = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
            BookingFile bookingFile = (BookingFile)data.getEntity();
            if (oldCtr != null) {
                BookingFile oldBookingFile = (BookingFile)oldCtr.getEntity();
                for (Reservation res : oldBookingFile.getReservations()) {
                    for (BaseProduct prod : res.getProducts()) {
                        BaseProduct newProduct;
                        String productTitle = GeneralProductHelper.getProductTitle((BaseProduct)prod);
                        if (ShipmentHelper.hasRelatedShipment(prod)) {
                            Set<EntityContainer<Shipment>> clientShipments;
                            newProduct = BookingHelper.findProduct((BookingFile)bookingFile, (String)prod.getUid());
                            if (newProduct == null) {
                                throw Xeption.forEndUser((String)"\u043d\u0430 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 {0} \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0430 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f, \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e", (Object[])new Object[]{productTitle});
                            }
                            Set<EntityContainer<Shipment>> subagentShipments = ShipmentHelper.getSubagentRelatedShipments(prod);
                            if (!subagentShipments.isEmpty()) {
                                EntityReference subagency = GeneralProductHelper.getSubagency((BaseProduct)prod);
                                EntityReference newSubagency = GeneralProductHelper.getSubagency((BaseProduct)newProduct);
                                if (subagency != null && !subagency.equals((Object)newSubagency)) {
                                    throw Xeption.forEndUser((String)"\u043d\u0430 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 {0} \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0430 \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u043a\u0430\u044f \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f, \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e", (Object[])new Object[]{productTitle});
                                }
                                ShipmentHelper.checkDeletionFops(subagentShipments, newProduct, storageContext, "\u043d\u0430 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 {0} \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0430 \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u043a\u0430\u044f \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f, \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u043a\u0438\u0445 \u0424\u041e\u041f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e", productTitle);
                            }
                            if (!(clientShipments = ShipmentHelper.getClientRelatedShipments(prod)).isEmpty()) {
                                if (!MiscUtil.equals((Object)bookingFile.getCustomerProfile(), (Object)oldBookingFile.getCustomerProfile()) && ShipmentHelper.hasClientRelatedShipment(newProduct)) {
                                    throw Xeption.forEndUser((String)"\u043d\u0430 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 {0} \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0430 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f, \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u043a\u043b\u0438\u0435\u043d\u0442\u0430 \u0432 \u0437\u0430\u043a\u0430\u0437\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e", (Object[])new Object[]{productTitle});
                                }
                                ShipmentHelper.checkDeletionFops(clientShipments, newProduct, storageContext, "\u043d\u0430 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 {0} \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0430 \u043a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u0430\u044f \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f, \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u0438\u0445 \u0424\u041e\u041f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e", productTitle);
                            }
                            if (!ShipmentHelper.hasRelatedShipment(newProduct)) continue;
                            XCompareHelper.Difference diff = ShipmentHelper.getFinanceDifference(prod, newProduct);
                            if (diff != null) {
                                throw Xeption.forEndUser((String)"\u043d\u0430 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 {0} \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0430 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f, \u043d\u043e \u0432 \u043d\u0435\u043c \u043f\u043e\u043c\u0435\u043d\u044f\u043b\u0438\u0441\u044c \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e \u0437\u043d\u0430\u0447\u0438\u043c\u044b\u0435 \u043f\u043e\u043b\u044f. \u0414\u0435\u0442\u0430\u043b\u0438: \n\u043f\u0443\u0442\u044c = {1}\n\u0441\u0442\u0430\u0440\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 = {2}\n\u043d\u043e\u0432\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 = {3}", (Object[])new Object[]{productTitle, diff.path, diff.oldValue, diff.newValue});
                            }
                        }
                        if (prod.getPrepaymentDocuments().isEmpty()) continue;
                        newProduct = BookingHelper.findProduct((BookingFile)bookingFile, (String)prod.getUid());
                        if (newProduct == null) {
                            throw Xeption.forEndUser((String)"\u043d\u0430 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 {0} \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043d\u0430 \u043f\u0440\u0435\u0434\u043e\u043f\u043b\u0430\u0442\u0443, \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e", (Object[])new Object[]{productTitle});
                        }
                        if (CollectionUtil.equals((Collection)GeneralProductHelper.getTravellers((BaseProduct)prod), (Collection)GeneralProductHelper.getTravellers((BaseProduct)newProduct), (boolean)true)) continue;
                        throw Xeption.forEndUser((String)"\u043d\u0430 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 {0} \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043d\u0430 \u043f\u0440\u0435\u0434\u043e\u043f\u043b\u0430\u0442\u0443, \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u043f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a\u043e\u0432 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e", (Object[])new Object[]{productTitle});
                    }
                }
            }
        }
    }

    private boolean isDisabled() {
        return "false".equals(System.getProperty(SHIPMENT_CHECK_ENABLED));
    }

    private boolean ignore(EntityContainer<?> data) {
        return DATA_SOURCES_TO_IGNORE.contains(data.getVersionInfo().getDataSource());
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (BookingFile.class.equals((Object)data.getEntityType())) {
            BookingFile booking = (BookingFile)data.getEntity();
            for (Reservation res : booking.getReservations()) {
                for (BaseProduct prod : res.getProducts()) {
                    if (ShipmentHelper.hasRelatedShipment(prod)) {
                        throw Xeption.forEndUser((String)"\u043d\u0430 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 {0} \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0430 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f, \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0430\u0437\u0430 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e", (Object[])new Object[]{GeneralProductHelper.getProductTitle((BaseProduct)prod)});
                    }
                    if (prod.getPrepaymentDocuments().isEmpty()) continue;
                    throw Xeption.forEndUser((String)"\u043d\u0430 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 {0} \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043d\u0430 \u043f\u0440\u0435\u0434\u043e\u043f\u043b\u0430\u0442\u0443, \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0430\u0437\u0430 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e", (Object[])new Object[]{GeneralProductHelper.getProductTitle((BaseProduct)prod)});
                }
            }
        }
    }

    public double getPriority() {
        return 2.147483647E9;
    }

    static {
        DATA_SOURCES_TO_IGNORE.add("fx-join-booking-file-task");
        DATA_SOURCES_TO_IGNORE.add("traveller-to-travellers-task");
        DATA_SOURCES_TO_IGNORE.add("shipments:products-exclude");
        DATA_SOURCES_TO_IGNORE.add("shipments:delete");
    }
}

