/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristicHelper;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.VatValue;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.model.interceptors.ProductsHelper;
import java.util.Date;
import java.util.List;
import org.slf4j.LoggerFactory;

public class InsuranceTouristicInterceptor
implements EntityInterceptor {
    public double getPriority() {
        return 2.01;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!BookingFile.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        EntityContainer<?> bookingFileContainer = data;
        EntityContainer oldBookingFileContainer = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        for (Reservation res : bookingFile.getReservations()) {
            for (BaseProduct prod : res.getProducts()) {
                ProductHandler handler;
                BaseProduct relatedProduct;
                if (!(prod instanceof InsuranceTouristic)) continue;
                InsuranceTouristic product = (InsuranceTouristic)prod;
                boolean isNewProduct = ProductsHelper.isNewProduct((EntityContainer<BookingFile>)oldBookingFileContainer, (BaseProduct)product);
                this.updateProduct(product, isNewProduct);
                if (product.getRelatedProductUid() == null || (relatedProduct = BookingHelper.findProduct((BookingFile)bookingFile, (String)product.getRelatedProductUid())) == null || (handler = HandlersRegistry.get().findProductHandler(relatedProduct.getClass())) == null) continue;
                product.setRelatedProductType(handler.getProductType(relatedProduct));
            }
        }
    }

    private void updateProduct(InsuranceTouristic product, boolean isNewProduct) throws Exception {
        this.updateBranch(product);
        this.updateVat(product);
        if (product.getStatus() == null) {
            product.setStatus(ProductStatus.SELL);
        }
        if (product.getLocalIssueDate() == null) {
            product.setLocalIssueDate(product.getIssueDate());
        }
        if (isNewProduct) {
            this.updateFops(product);
        }
        this.updateScnAndEticketFlag(product);
    }

    private void updateVat(InsuranceTouristic product) {
        if (product.getEquivalentFareVatValue() == null) {
            VatValue vatValue = new VatValue();
            product.setEquivalentFareVatValue(vatValue);
        }
    }

    private void updateScnAndEticketFlag(final InsuranceTouristic product) {
        ProductsHelper.updateScnAndEticketFlag(new ProductsHelper.BlankTypeHandler(){

            @Override
            public void setEticket(boolean value) {
            }

            @Override
            public String getSystemNumber() {
                return product.getSystemNumber();
            }

            @Override
            public int getConjunctionsCount() {
                return 0;
            }

            @Override
            public DictionaryReference<BlankType> getBlankType() {
                return product.getBlankType();
            }

            @Override
            public void clearSCN() {
                product.setScn(null);
            }

            @Override
            public void addSCN(String value) {
                product.setScn(value);
            }
        });
    }

    private void updateBranch(InsuranceTouristic product) throws Exception {
        if (product.getBranch() != null) {
            return;
        }
        EntityContainer salesPointContainer = EntityStorage.get().resolve(product.getSalesPoint());
        if (salesPointContainer != null) {
            product.setBranch(((SalesPoint)salesPointContainer.getEntity()).getBranch());
        }
    }

    private void updateFops(InsuranceTouristic product) {
        List contractRelations = InsuranceTouristicHelper.getContractRelations((InsuranceTouristic)product);
        EntityReference salesPointRef = product.getSalesPoint();
        Date operationDate = product.getIssueDate();
        EntityReference<Person> agent = product.getAgent();
        if (agent == null) {
            try {
                agent = ProfileDao.findCurrentAgent(null);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("unable to find current agent", (Throwable)e);
            }
        }
        operationDate = null;
        agent = null;
        ProductsHelper.updateFops(contractRelations, (EntityReference<SalesPoint>)salesPointRef, operationDate, agent);
    }
}

