/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettings;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.model.system.lrt.LongRunningTasksSettings;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.model.tasks.LongRunningTaskLauncherTask;
import com.gridnine.xtrip.server.model.tasks.LongRunningTasksSchedulerTask;

public class LongRunningTasksSettingsInterceptor
implements EntityInterceptor {
    public double getPriority() {
        return 0.0;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        int poolingDelayInSeconds;
        if (!LongRunningTasksSettings.class.equals((Object)data.getEntityType())) {
            return;
        }
        LongRunningTasksSettings settings = (LongRunningTasksSettings)data.getEntity();
        int poolingPeriodInSeconds = settings.getPoolingPeriodInSeconds();
        if (poolingPeriodInSeconds <= 0) {
            poolingPeriodInSeconds = 60;
        }
        if ((poolingDelayInSeconds = settings.getPoolingDelayInSeconds()) <= 0) {
            poolingDelayInSeconds = 300;
        }
        this.updateLauncher(poolingPeriodInSeconds, poolingDelayInSeconds, settings.getInstallationId());
        this.updateStopper(poolingPeriodInSeconds, poolingDelayInSeconds, settings.getInstallationId(), settings.getWorkingPeriods().isEmpty());
    }

    private void updateStopper(int poolingPeriodInSeconds, int poolingDelayInSeconds, String installationId, boolean deleteOnly) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicSystemSettingsIndex.Property.type.name(), (Object)SystemSettingsType.SCHEDULED_TASK_SETTINGS));
        for (BasicSystemSettingsIndex item : EntityStorage.get().search(BasicSystemSettingsIndex.class, query).getData()) {
            EntityContainer ctr = EntityStorage.get().resolve(item.getSource());
            if (ctr == null || !ctr.getEntityType().equals(ScheduledTaskSettings.class)) continue;
            ScheduledTaskSettings ett = (ScheduledTaskSettings)ctr.getEntity();
            if (!LongRunningTasksSchedulerTask.class.getName().equals(ett.getJobClass())) continue;
            EntityStorage.get().delete(ctr);
        }
        if (deleteOnly) {
            return;
        }
        ScheduledTaskSettings stt = new ScheduledTaskSettings();
        stt.setDelay(Long.valueOf((long)(poolingDelayInSeconds - 1) * 1000L));
        stt.setEnabled(true);
        stt.setLocal(TextUtil.isBlank((String)installationId));
        stt.setInstallationId(installationId);
        stt.setJobClass(LongRunningTasksSchedulerTask.class.getName());
        stt.setName(String.format("\u0421\u043b\u0443\u0436\u0435\u0431\u043d\u043e\u0435: \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0437\u0430\u0434\u0430\u0447", new Object[0]));
        stt.setPeriod(Long.valueOf(1000L * (long)poolingPeriodInSeconds));
        stt.setType(SystemSettingsType.SCHEDULED_TASK_SETTINGS);
        EntityStorage.get().save(EntityContainer.create((BaseEntity)stt), true);
    }

    private void updateLauncher(int poolingPeriodInSeconds, int poolingDelayInSeconds, String installationId) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicSystemSettingsIndex.Property.type.name(), (Object)SystemSettingsType.SCHEDULED_TASK_SETTINGS));
        for (BasicSystemSettingsIndex item : EntityStorage.get().search(BasicSystemSettingsIndex.class, query).getData()) {
            EntityContainer ctr = EntityStorage.get().resolve(item.getSource());
            if (ctr == null || !ctr.getEntityType().equals(ScheduledTaskSettings.class)) continue;
            ScheduledTaskSettings ett = (ScheduledTaskSettings)ctr.getEntity();
            if (!LongRunningTaskLauncherTask.class.getName().equals(ett.getJobClass())) continue;
            EntityStorage.get().delete(ctr);
        }
        ScheduledTaskSettings stt = new ScheduledTaskSettings();
        stt.setDelay(Long.valueOf((long)poolingDelayInSeconds * 1000L));
        stt.setEnabled(true);
        stt.setLocal(TextUtil.isBlank((String)installationId));
        stt.setInstallationId(installationId);
        stt.setJobClass(LongRunningTaskLauncherTask.class.getName());
        stt.setName(String.format("\u0421\u043b\u0443\u0436\u0435\u0431\u043d\u043e\u0435: \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u0437\u0430\u0434\u0430\u0447", new Object[0]));
        stt.setPeriod(Long.valueOf(1000L * (long)poolingPeriodInSeconds));
        stt.setType(SystemSettingsType.SCHEDULED_TASK_SETTINGS);
        EntityStorage.get().save(EntityContainer.create((BaseEntity)stt), true);
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!LongRunningTasksSettings.class.equals((Object)data.getEntityType())) {
            return;
        }
        throw new Exception("unsupported opperation");
    }
}

