/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.MCOFees;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import java.math.BigDecimal;
import java.util.Optional;

public class MCOFeesInterceptor
implements EntityInterceptor {
    public double getPriority() {
        return 2.05;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!BookingFile.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        EntityContainer<?> container = data;
        BookingFile bookingFile = (BookingFile)container.getEntity();
        for (Reservation res : bookingFile.getReservations()) {
            for (BaseProduct prod : res.getProducts()) {
                if (!(prod instanceof MCOFees)) continue;
                MCOFees product = (MCOFees)prod;
                this.updateProduct(product);
            }
        }
    }

    private void updateProduct(MCOFees product) throws Exception {
        this.updateBranch(product);
        if (product.getStatus() == null) {
            product.setStatus(ProductStatus.SELL);
        }
        if (product.getLocalIssueDate() == null) {
            product.setLocalIssueDate(product.getIssueDate());
        }
        BigDecimal total = product.getSources().stream().map(item -> Optional.ofNullable(item.getFare()).map(money -> money.getValue()).orElse(null)).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(null);
        product.setTotal(total);
    }

    private void updateBranch(MCOFees product) throws Exception {
        if (product.getBranch() != null) {
            return;
        }
        EntityContainer salesPointContainer = EntityStorage.get().resolve(product.getSalesPoint());
        if (salesPointContainer != null) {
            product.setBranch(((SalesPoint)salesPointContainer.getEntity()).getBranch());
        }
    }
}

