/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductFop;
import com.gridnine.xtrip.common.model.booking.xtriphotels.MainHotelProductIndex;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.standard.hotelProductSettings.HotelProductSettingsActionSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumberHelper;
import com.gridnine.xtrip.server.model.handlers.HotelPropertySet;
import com.gridnine.xtrip.server.model.handlers.rules.hotel.HotelRulesHelper;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.model.interceptors.ProductsHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.LoggerFactory;

public class MainHotelProductInterceptor
implements EntityInterceptor {
    public static final double priority = 2.0;

    public double getPriority() {
        return 2.0;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!BookingFile.class.equals((Object)data.getEntityType())) {
            return;
        }
        EntityContainer<?> bookingFileContainer = data;
        EntityContainer oldBookingFileContainer = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        for (Reservation res : bookingFile.getReservations()) {
            for (BaseProduct prod : res.getProducts()) {
                if (!(prod instanceof HotelProduct)) continue;
                HotelProduct product = (HotelProduct)prod;
                boolean isNewProduct = ProductsHelper.isNewProduct((EntityContainer<BookingFile>)oldBookingFileContainer, (BaseProduct)product);
                boolean supplierChanged = ProductsHelper.isSupplierChanged((EntityContainer<BookingFile>)oldBookingFileContainer, (BaseProduct)product);
                this.updateProduct(product, isNewProduct, supplierChanged);
            }
        }
    }

    private void updateProduct(HotelProduct product, boolean isNewProduct, boolean supplierChanged) throws Exception {
        if (TextUtil.isBlank((String)product.getSystemNumber()) && Holder.getParams().isSetSystemNumber(product)) {
            this.updateSystemNumer(product);
        }
        if (TextUtil.isBlank((String)product.getBlankOwnerCode()) && product.getBlankOwnerRef() != null) {
            product.setBlankOwnerCode(HotelProductHelper.getBlankOwnerCode((EntityReference)product.getBlankOwnerRef()));
        }
        product.setServiceLocationType(HotelProductHelper.getServiceLocationType((HotelProduct)product));
        if (supplierChanged) {
            HotelProductContractRelationData vendorContractRelation;
            RuleProxy<HotelPropertySet, HotelProductSettingsActionSet> ruleProxy = HotelRulesHelper.applyHotelProductSettingsRules(product);
            EntityReference productSupplier = HotelProductHelper.getSupplier((HotelProduct)product);
            EntityReference rulesSupplier = ((HotelProductSettingsActionSet)ruleProxy.getActionSet()).getSupplier();
            if (productSupplier == null && rulesSupplier != null) {
                HotelProductHelper.setSupplier((HotelProduct)product, (EntityReference)rulesSupplier);
            }
            if (product.getBlankOwnerRef() == null && ((HotelProductSettingsActionSet)ruleProxy.getActionSet()).getBlankOwner() != null) {
                product.setBlankOwnerRef(((HotelProductSettingsActionSet)ruleProxy.getActionSet()).getBlankOwner());
            }
            if ((vendorContractRelation = HotelProductHelper.getVendorContractRelation((HotelProduct)product)) != null && (productSupplier == null || rulesSupplier == null || MiscUtil.equals((Object)productSupplier, (Object)rulesSupplier)) && vendorContractRelation.getGeneralData().getContractData().getManualContract() == null) {
                vendorContractRelation.getGeneralData().getContractData().setManualContract(((HotelProductSettingsActionSet)ruleProxy.getActionSet()).getVendorContract());
            }
        }
        if (isNewProduct) {
            this.updateFops(product);
        }
    }

    private void updateSystemNumer(HotelProduct prod) {
        try {
            String number = SequenceNumberHelper.generateNumber(HotelProduct.class, MainHotelProductIndex.class, (String)MainHotelProductIndex.Property.systemNumber.name());
            prod.setSystemNumber(number);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("unable to generate sequence number for product " + prod.getUid());
        }
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    private void updateFops(HotelProduct product) {
        List vendorFops = Collections.emptyList();
        List clientFops = Collections.emptyList();
        ArrayList<List> subagentFops = new ArrayList<List>();
        for (HotelProductContractRelationData item : HotelProductHelper.getContractRelations((HotelProduct)product)) {
            switch (GeneralProductHelper.getContractType((EntityReference)item.getDescription())) {
                case VENDOR: {
                    vendorFops = item.getFops();
                    break;
                }
                case CLIENT: {
                    clientFops = item.getFops();
                    break;
                }
                case SUBAGENCY: {
                    subagentFops.add(item.getFops());
                    break;
                }
            }
        }
        EntityReference<Person> agent = product.getCashier();
        if (agent == null) {
            try {
                agent = ProfileDao.findCurrentAgent(null);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("unable to find current agent", (Throwable)e);
            }
        }
        EntityReference<Person> finalAgent = agent = null;
        vendorFops.stream().filter(fop -> fop.getAgent() == null).forEach(fop -> fop.setAgent(finalAgent));
        subagentFops.stream().flatMap(Collection::stream).filter(fop -> fop.getAgent() == null).forEach(fop -> fop.setAgent(finalAgent));
        clientFops.stream().filter(fop -> fop.getAgent() == null).forEach(fop -> fop.setAgent(finalAgent));
        this.updateFops(clientFops, vendorFops);
        for (List sf : subagentFops) {
            this.updateFops(sf, clientFops);
        }
    }

    private void updateFops(List<HotelProductFop> targetFops, List<HotelProductFop> sourceFops) {
        if (!targetFops.isEmpty() || sourceFops.isEmpty()) {
            return;
        }
        for (HotelProductFop pf : sourceFops) {
            if (!HotelProductHelper.isServiceFop((HotelProductFop)pf)) continue;
            try {
                HotelProductFop fop = (HotelProductFop)XCloneHelper.clone((XCloneable)pf, (boolean)true);
                fop.setOperationDate(null);
                fop.setAgent(null);
                targetFops.add(fop);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("unable to clone a fop", (Throwable)e);
            }
        }
    }

    private static class Holder {
        private static final Parameters PARAMS = Environment.isPublished(Parameters.class) ? (Parameters)Environment.getPublished(Parameters.class) : product -> true;

        private Holder() {
        }

        private static Parameters getParams() {
            if (Environment.isTest()) {
                return Environment.isPublished(Parameters.class) ? (Parameters)Environment.getPublished(Parameters.class) : new Parameters(){

                    @Override
                    public boolean isSetSystemNumber(HotelProduct product) {
                        return true;
                    }
                };
            }
            return PARAMS;
        }
    }

    public static interface Parameters {
        public boolean isSetSystemNumber(HotelProduct var1);
    }
}

