/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.async.AsyncCommand;
import com.gridnine.xtrip.common.async.AsyncCommandOption;
import com.gridnine.xtrip.common.async.AsyncExecutor;
import com.gridnine.xtrip.common.helper.SearchHelper;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Contract2ModelContract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.server.db.Callback;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public class ModelContractInterceptor
implements EntityInterceptor {
    public double getPriority() {
        return -1000.0;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        ContractCustomerInfo info;
        List contractCustomerInfo;
        if (!data.getEntity().getClass().equals(Contract.class)) {
            return;
        }
        Contract contract = (Contract)data.getEntity();
        if (!contract.isNewModel()) {
            return;
        }
        if (LogicalStorage.get().getEntityStorage().isGlobalOperationContextAvailable()) {
            EntityContainer oldContractCtr = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
            Set refs1 = contract.getModelContracts().stream().map(Contract2ModelContract::getModelContract).collect(Collectors.toSet());
            Set refs2 = oldContractCtr != null ? ((Contract)oldContractCtr.getEntity()).getModelContracts().stream().map(Contract2ModelContract::getModelContract).collect(Collectors.toSet()) : Collections.emptySet();
            HashSet<EntityReference<ModelContract>> refs = new HashSet<EntityReference<ModelContract>>();
            refs1.stream().filter(r -> !refs2.contains(r)).forEach(refs::add);
            refs2.stream().filter(r -> !refs1.contains(r)).forEach(refs::add);
            ModelContractInterceptor.reindexModelContracts(refs, ss);
        }
        if ((contractCustomerInfo = contract.getCustomers()).size() >= 1) {
            while (contractCustomerInfo.size() > 1) {
                contractCustomerInfo.remove(contractCustomerInfo.size() - 1);
            }
            info = (ContractCustomerInfo)contractCustomerInfo.get(0);
        } else {
            info = new ContractCustomerInfo();
            contract.getCustomers().add(info);
        }
        info.setDescription(contract.getNotes());
        info.setNumber(contract.getNumber());
        info.setCustomer(contract.getCustomer());
        info.setIssueDate(contract.getIssueDate());
        info.setStartDate(contract.getStartDate());
        info.setEndDate(contract.getEndDate());
        info.setTourCode(contract.getTourCode());
        info.setVendorContractType(contract.getVendorContractType());
        info.getAppendices().clear();
        info.getAppendices().addAll(contract.getAppendices());
        info.setPaymentCurrency(contract.getPaymentCurrency());
        info.setValue("paymentConditions", (Object)contract.getPaymentConditions());
        info.getExchangeRateConditions().clear();
        info.getExchangeRateConditions().addAll(contract.getExchangeRateConditions());
        info.getTchDirectContracts().clear();
        info.getTchDirectContracts().addAll(contract.getTchDirectContracts());
        info.getFopSettings().clear();
        info.getFopSettings().addAll(contract.getFopSettings());
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (data.getEntity().getClass().equals(Contract.class)) {
            Contract contract = (Contract)data.getEntity();
            if (!contract.isNewModel()) {
                return;
            }
            Set<EntityReference<ModelContract>> refs = contract.getModelContracts().stream().map(Contract2ModelContract::getModelContract).collect(Collectors.toSet());
            ModelContractInterceptor.reindexModelContracts(refs, ss);
            return;
        }
        if (!data.getEntity().getClass().equals(ModelContract.class)) {
            return;
        }
        EntityReference ref = data.toReference();
        ss.addCallback((Callback & Serializable)ss2 -> {
            Set contractRefs = SearchHelper.searchEntity(ContractIndex.class, (SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)ContractIndex.Property.modelContracts.name(), (Object)ref)}).stream().map(ContractIndex::getSource).filter(Objects::nonNull).collect(Collectors.toSet());
            if (!contractRefs.isEmpty()) {
                for (EntityReference c : contractRefs) {
                    AsyncExecutor.get().execute("remove-model-contract-from-contract", (AsyncCommand & Serializable)() -> LockUtil.lock((EntityReference)c, c2 -> {
                        if (null == c2) {
                            return;
                        }
                        if (Environment.isTest()) {
                            LoggerFactory.getLogger(ModelContractInterceptor.class).info("CONTRACT VERSION:" + c2.getVersionsCount() + ", REMOVE, id: " + System.identityHashCode(c2) + ", THREAD: " + Thread.currentThread().getId());
                        }
                        if (((Contract)c2.getEntity()).getModelContracts().removeIf(mc -> Objects.equals(mc.getModelContract(), ref))) {
                            c2.getVersionInfo().setDataSource("delete-model-container-interceptor");
                            EntityStorage.get().save(c2, true);
                        }
                    }), new AsyncCommandOption[0]);
                }
            }
        });
    }

    private static void reindexModelContracts(Collection<EntityReference<ModelContract>> refs, SessionCallback ss) {
        if (!refs.isEmpty()) {
            ss.addCallback((Callback & Serializable)ss2 -> {
                for (EntityReference ref : refs) {
                    EntityContainer ctr = EntityStorage.get().resolve(ref);
                    if (ctr == null) continue;
                    try {
                        LogicalStorage.get().getEntityStorage().updateIndexes(ss2, ctr, ctr);
                    }
                    catch (Exception e) {
                        LoggerFactory.getLogger(ModelContractInterceptor.class).error("unable to rebuild index of " + ref, (Throwable)e);
                    }
                }
            });
        }
    }
}

