/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.async.AsyncCommand;
import com.gridnine.xtrip.common.async.AsyncCommandOption;
import com.gridnine.xtrip.common.async.AsyncExecutor;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class OrganizationInterceptor
implements EntityInterceptor {
    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (Organization.class.equals((Object)data.getEntityType())) {
            this.setAuthor(data);
            this.updatePersonCostCodes(data);
            this.validateOrganizationBin(data);
        }
    }

    private void setAuthor(EntityContainer<?> data) {
        if (LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr() == null) {
            Organization org = (Organization)data.getEntity();
            org.setAuthor(ProfileHelper.getCurrentUser());
        }
    }

    private void updatePersonCostCodes(EntityContainer<?> data) {
        EntityContainer oldCtr = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
        if (oldCtr != null) {
            String className = this.getClass().getName();
            AsyncExecutor.get().execute(className, (AsyncCommand & Serializable)() -> LockUtil.lock((String)LockUtil.getLockKey((EntityContainer)data, (String)className), () -> {
                Organization org = (Organization)data.getEntity();
                Organization oldOrg = (Organization)oldCtr.getEntity();
                Map changedProperties = org.getCostCodeProperties().stream().filter(ccp -> this.changedProperty((CostCodeProperties)ccp, (CostCodeProperties)CollectionUtil.find((Iterable)oldOrg.getCostCodeProperties(), (String)ccp.getUid()))).collect(Collectors.toMap(BaseIdentity::getUid, Function.identity()));
                Set deletedProperties = oldOrg.getCostCodeProperties().stream().filter(ccp -> !org.getCostCodeProperties().contains(ccp)).collect(Collectors.toSet());
                if (!changedProperties.isEmpty() || !deletedProperties.isEmpty()) {
                    SearchQuery query = new SearchQuery();
                    query.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.employments.name(), (Object)org));
                    List personIndices = EntityStorage.get().search(PersonIndex.class, query).getData();
                    for (PersonIndex personIndex : personIndices) {
                        EntityContainer personCtr = EntityStorage.get().resolve(personIndex.getSource());
                        if (personCtr == null) continue;
                        boolean changed = false;
                        List personCostCodes = ((Person)personCtr.getEntity()).getCostCodes().stream().filter(personCostCode -> personCostCode.getCostCodeProperties() != null).filter(personCostCode -> changedProperties.containsKey(personCostCode.getCostCodeProperties().getUid())).collect(Collectors.toList());
                        for (PersonCostCode costCode : personCostCodes) {
                            changed = true;
                            costCode.setCostCodeProperties((CostCodeProperties)changedProperties.get(costCode.getCostCodeProperties().getUid()));
                        }
                        if (!(changed |= ((Person)personCtr.getEntity()).getCostCodes().removeIf(personCostCode -> deletedProperties.contains(personCostCode.getCostCodeProperties())))) continue;
                        personCtr.getVersionInfo().setDataSource("update udid properties");
                        EntityStorage.get().save(personCtr, true);
                    }
                }
            }), new AsyncCommandOption[]{AsyncCommandOption.LOCAL});
        }
    }

    private boolean changedProperty(CostCodeProperties p1, CostCodeProperties p2) {
        if (p1 == null || p2 == null) {
            return false;
        }
        return !MiscUtil.equals((Object)p1.getType(), (Object)p2.getType()) || !MiscUtil.equals((Object)p1.getName(), (Object)p2.getName()) || !MiscUtil.equals((Object)p1.getCategory().getCode(), (Object)p2.getCategory().getCode()) || !MiscUtil.equals((Object)p1.getStartDate(), (Object)p2.getStartDate()) || !MiscUtil.equals((Object)p1.getEndDate(), (Object)p2.getEndDate()) || !MiscUtil.equals((Object)p1.isSabreDropList(), (Object)p2.isSabreDropList()) || !MiscUtil.equals((Object)p1.isDontSyncToSabre(), (Object)p2.isDontSyncToSabre()) || !MiscUtil.equals((Object)p1.isPassValueInSabreToOrder(), (Object)p2.isPassValueInSabreToOrder()) || !MiscUtil.equals((Object)p1.isCommon(), (Object)p2.isCommon()) || !MiscUtil.equals((Object)p1.isPassengerUdid(), (Object)p2.isPassengerUdid()) || !MiscUtil.equals((Object)p1.isShipmentCategory(), (Object)p2.isShipmentCategory()) || !MiscUtil.equals((Object)p1.isDependant(), (Object)p2.isDependant()) || !MiscUtil.equals((Object)p1.getDisplayType(), (Object)p2.getDisplayType()) || !MiscUtil.equals((Object)p1.getDesignatorType(), (Object)p2.getDesignatorType()) || !MiscUtil.equals((Object)p1.getFillingPoint(), (Object)p2.getFillingPoint()) || !MiscUtil.equals((Object)p1.getMask(), (Object)p2.getMask()) || !MiscUtil.equals((Object)p1.getSabreRemarks(), (Object)p2.getSabreRemarks()) || !MiscUtil.equals((Object)p1.getSabreValue(), (Object)p2.getSabreValue());
    }

    private void validateOrganizationBin(EntityContainer<?> data) {
        Organization org = (Organization)data.getEntity();
        if (TextUtil.nonBlank((String)org.getBin())) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.ne((String)"navigationKey", (Object)org.getUid()));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.bin.name(), (Object)org.getBin()));
            query.setResultMode(ResultMode.COUNT_ONLY);
            if (EntityStorage.get().search(OrganizationIndex.class, query).getTotalCount() > 0) {
                throw Xeption.forEndUser((String)Messages.organizationWithBinAlreadyExists, (Object[])new Object[]{org.getBin()});
            }
        }
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public double getPriority() {
        return 0.0;
    }
}

