/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.system.model.PaymentCode;
import com.gridnine.xtrip.common.system.model.PaymentCodeSettings;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PaymentCodeSettingsInterceptor
implements EntityInterceptor {
    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!PaymentCodeSettings.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        EntityContainer<?> paymentCodeSettingsContainer = data;
        PaymentCodeSettings paymentCodeSettings = (PaymentCodeSettings)paymentCodeSettingsContainer.getEntity();
        Map<ProductType, List<PaymentCode>> productTypesMap = paymentCodeSettings.getPaymentCodes().stream().filter(paymentCode -> paymentCode.getProductType() != null).collect(Collectors.groupingBy(PaymentCode::getProductType));
        for (Map.Entry<ProductType, List<PaymentCode>> entry : productTypesMap.entrySet()) {
            if (entry.getKey() == ProductType.MISC_PRODUCT) {
                HashSet descriptions = new HashSet();
                entry.getValue().stream().map(PaymentCode::getUniversalProductDescription).forEach(description -> {
                    if (description == null) {
                        throw Xeption.forEndUser((String)Messages.MissingUniversalProductDescription, (Object[])new Object[0]);
                    }
                    if (!descriptions.add(description)) {
                        throw Xeption.forEndUser((String)Messages.DuplicateProductType, (Object[])new Object[0]);
                    }
                });
                continue;
            }
            if (entry.getValue().size() <= 1) continue;
            throw Xeption.forEndUser((String)Messages.DuplicateProductType, (Object[])new Object[0]);
        }
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public double getPriority() {
        return 1.0;
    }
}

