/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.personal.data.PersonalDataPersonRequest;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumberHelper;

public class PersonalDataRequestInterceptor
implements EntityInterceptor {
    public double getPriority() {
        return 2.0;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (PersonalDataPersonRequest.class.getName().equals(data.getEntityType().getName())) {
            PersonalDataPersonRequest request = (PersonalDataPersonRequest)data.getEntity();
            this.generateNumber(request);
        }
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    private void generateNumber(final PersonalDataPersonRequest request) throws Exception {
        ((SequenceNumberHelper)Environment.getPublished(SequenceNumberHelper.class)).generateInc(new CompositeNumber(){

            public void setNumberSuffix(String value) {
            }

            public void setNumberPrefix(String value) {
            }

            public void setNumber(String value) {
                request.setNumber(value);
            }

            public String getNumberSuffix() {
                return null;
            }

            public String getNumberPrefix() {
                return null;
            }

            public String getNumber() {
                return request.getNumber();
            }
        }, String.format("personal_datarequest.%s", PersonalDataPersonRequest.class.getName()), null);
    }
}

