/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.BasePollerSettings;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettings;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.LoggerFactory;

public class PollingConsumerSettingsInterceptor
implements EntityInterceptor {
    private static final String CONSUMERS_KEY = "consumers";

    public double getPriority() {
        return 0.0;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (data == null) {
            return;
        }
        if (!(data.getEntity() instanceof BasePollerSettings)) {
            return;
        }
        try {
            ((IntegrationBusFacade)Environment.getPublished(IntegrationBusFacade.class)).refreshConsumer(data.getUid());
        }
        catch (Throwable e) {
            LoggerFactory.getLogger(this.getClass()).error("unable to refresh consumer " + data.getEntity(), e);
        }
        EntityContainer<ScheduledTaskSettings> settingsCtr = this.findSettigns(this.getPollingGroup(data));
        if (settingsCtr == null) {
            return;
        }
        Set<String> consumers = this.getConsumers((ScheduledTaskSettings)settingsCtr.getEntity());
        if (consumers.contains(data.getUid())) {
            return;
        }
        consumers.add(data.getUid());
        this.setConsumers((ScheduledTaskSettings)settingsCtr.getEntity(), consumers);
        EntityStorage.get().save(settingsCtr, true);
    }

    private void setConsumers(ScheduledTaskSettings entity, Set<String> consumers) {
        StringBuilder sb = new StringBuilder();
        for (String consumer : consumers) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(consumer);
        }
        NamedValue value = null;
        for (NamedValue param : entity.getDataMap()) {
            if (!CONSUMERS_KEY.equals(param.getName())) continue;
            value = param;
            break;
        }
        if (value == null) {
            value = new NamedValue();
            value.setName(CONSUMERS_KEY);
            entity.getDataMap().add(value);
        }
        value.setValue(sb.toString());
    }

    private Set<String> getConsumers(ScheduledTaskSettings stt) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (NamedValue param : stt.getDataMap()) {
            if (!CONSUMERS_KEY.equals(param.getName())) continue;
            if (param.getValue() != null) {
                for (String consumerId : param.getValue().split(",")) {
                    result.add(consumerId);
                }
            }
            return result;
        }
        return result;
    }

    private EntityContainer<ScheduledTaskSettings> findSettigns(String pollingGroup) {
        if (TextUtil.isBlank((String)pollingGroup)) {
            return null;
        }
        for (BasicSystemSettingsIndex item : EntityStorage.get().search(BasicSystemSettingsIndex.class, new SearchQuery()).getData()) {
            EntityContainer ctr = EntityStorage.get().resolve(item.getSource());
            if (ctr == null || !ctr.getEntityType().equals(ScheduledTaskSettings.class)) continue;
            ScheduledTaskSettings stt = (ScheduledTaskSettings)ctr.getEntity();
            for (NamedValue param : stt.getDataMap()) {
                if (!"pollingGroup".equals(param.getName()) || !pollingGroup.equals(param.getValue())) continue;
                return ctr;
            }
        }
        return null;
    }

    private String getPollingGroup(EntityContainer<?> data) {
        if (data == null) {
            return null;
        }
        if (data.getEntity() instanceof BasePollerSettings) {
            BasePollerSettings stt = (BasePollerSettings)data.getEntity();
            return stt.getPollingGroup() == null ? null : stt.getPollingGroup().name();
        }
        return null;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
        EntityContainer<ScheduledTaskSettings> settingsCtr = this.findSettigns(this.getPollingGroup(data));
        if (settingsCtr == null) {
            return;
        }
        Set<String> consumers = this.getConsumers((ScheduledTaskSettings)settingsCtr.getEntity());
        if (!consumers.contains(data.getUid())) {
            return;
        }
        consumers.remove(data.getUid());
        this.setConsumers((ScheduledTaskSettings)settingsCtr.getEntity(), consumers);
        EntityStorage.get().save(settingsCtr, true);
    }
}

