/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.statistics.ProductBillingDataChangeDataSource;
import com.gridnine.xtrip.common.model.booking.statistics.ProductBillingDataChangeEntry;
import com.gridnine.xtrip.common.model.entity.misc.EntityStorageThreadContext;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.ActionSource;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ProductBillingDataChangeInterceptor
implements EntityInterceptor {
    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!BookingFile.class.equals((Object)data.getEntityType())) {
            return;
        }
        EntityContainer<?> bookingCtr = data;
        EntityContainer oldBookingFileContainer = LogicalStorage.get().getEntityStorage().isGlobalOperationContextAvailable() ? LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr() : null;
        for (Reservation res : ((BookingFile)bookingCtr.getEntity()).getReservations()) {
            for (BaseProduct prod : res.getProducts()) {
                ProductHandler handler;
                ProductStatus productStatus;
                if (oldBookingFileContainer == null || BookingHelper.findProduct((BookingFile)((BookingFile)oldBookingFileContainer.getEntity()), (String)prod.getUid()) == null) {
                    prod.getBillingDataChangeEntries().clear();
                    prod.setBillingDataChangeEntriesInitialized(true);
                }
                if ((productStatus = (handler = GeneralProductHelper.getHandler((BaseProduct)prod)).getStatus(prod)) == ProductStatus.EXCHANGE) continue;
                if (handler.getStatus(prod) == ProductStatus.SELL && handler.getPreviousProduct(prod) != null && handler.getStatus(handler.getPreviousProduct(prod)) == ProductStatus.EXCHANGE) {
                    productStatus = ProductStatus.EXCHANGE;
                }
                ProductBillingDataChangeInterceptor.removeDuplicatedEntries(prod.getBillingDataChangeEntries());
                ProductStatus statisticsStatus = null;
                int idx = 0;
                if (!prod.getBillingDataChangeEntries().isEmpty()) {
                    ProductBillingDataChangeEntry lastEntry = (ProductBillingDataChangeEntry)prod.getBillingDataChangeEntries().get(prod.getBillingDataChangeEntries().size() - 1);
                    idx = lastEntry.getVersion() + 1;
                    statisticsStatus = lastEntry.getStatus();
                }
                if (statisticsStatus == productStatus) continue;
                ProductBillingDataChangeEntry entry = new ProductBillingDataChangeEntry();
                entry.setDate(new Date());
                entry.setSource(this.getDataSource());
                entry.setStatus(productStatus);
                entry.setVersion(idx);
                prod.getBillingDataChangeEntries().add(entry);
            }
        }
    }

    public static void removeDuplicatedEntries(List<ProductBillingDataChangeEntry> prodEntries) {
        ArrayList<ProductBillingDataChangeEntry> entries = new ArrayList<ProductBillingDataChangeEntry>(prodEntries);
        boolean hasDeletedEntries = false;
        ProductStatus lastStatus = null;
        for (ProductBillingDataChangeEntry entry : prodEntries) {
            if (lastStatus == null) {
                lastStatus = entry.getStatus();
                continue;
            }
            if (entry.getStatus() == lastStatus) {
                entries.remove(entry);
                hasDeletedEntries = true;
                continue;
            }
            lastStatus = entry.getStatus();
        }
        if (hasDeletedEntries) {
            prodEntries.clear();
            prodEntries.addAll(entries);
        }
    }

    private ProductBillingDataChangeDataSource getDataSource() {
        ActionSource ibusActionSource;
        EntityStorageThreadContext.ActionSource actionSource = EntityStorageThreadContext.getActionSource();
        if (actionSource == null) {
            actionSource = (EntityStorageThreadContext.ActionSource)LogicalStorage.get().getEntityStorage().getGlobalOperationContext().getParameters().get("ENTITY_STORAGE_ACTION_SOURCE");
        }
        if (actionSource != null) {
            switch (actionSource) {
                case MIDOFFICE_CLIENT_FX: {
                    return ProductBillingDataChangeDataSource.CLIENT;
                }
                case PARSER: {
                    return ProductBillingDataChangeDataSource.EXCHANGE_FILE;
                }
                case ONLINE: {
                    return ProductBillingDataChangeDataSource.ONLINE;
                }
            }
        }
        if ((ibusActionSource = (ActionSource)LogicalStorage.get().getEntityStorage().getGlobalOperationContext().getParameters().get(IBusStandardContextKeys.ACTION_SOURCE.name())) != null) {
            switch (ibusActionSource) {
                case PARSER: {
                    return ProductBillingDataChangeDataSource.EXCHANGE_FILE;
                }
                case MIDOFFICE_CLIENT_FX: {
                    return ProductBillingDataChangeDataSource.CLIENT;
                }
                case NEW_SITE: 
                case XML: 
                case BOF_SITE: {
                    return ProductBillingDataChangeDataSource.ONLINE;
                }
            }
            return null;
        }
        return null;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public double getPriority() {
        return 0.0;
    }
}

