/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.service.ExecutorServiceFacade;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ServerApplication;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorageHelper;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationContext;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductValidationInterceptor
implements EntityInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ProductValidationInterceptor.class);
    public static final String KEY_VALIDATE_PRODUCT_TRANSACTIONS = "key-validate-transactions";
    public static final double priority = 1000.0;

    public double getPriority() {
        return 1000.0;
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!BookingFile.class.getName().equals(data.getEntityType().getName())) {
            return;
        }
        final boolean validateProductNumbers = !Environment.isPublished(ServerApplication.class) || !Boolean.parseBoolean(((ServerApplication)Environment.getPublished(ServerApplication.class)).getConfiguration().getProperty("product_validation_interceptor_disable", "false"));
        EntityContainer<?> bookingFileContainer = data;
        BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
        ArrayList<BaseProduct> products = new ArrayList<BaseProduct>();
        for (Reservation reservation : bookingFile.getReservations()) {
            products.addAll(reservation.getProducts());
        }
        if (products.size() == 0) {
            return;
        }
        final ProductValidationContext context = new ProductValidationContext();
        EntityContainer oldBookingFileContainer = LogicalStorageHelper.getOldContainerFromLocalContextByEntityUid((String)bookingFile.getUid(), BookingFile.class);
        if (oldBookingFileContainer != null) {
            context.previousVersionOfBooking((BookingFile)oldBookingFileContainer.getEntity());
        }
        if (products.size() == 1) {
            this.validateProduct((BaseProduct)products.get(0), context, validateProductNumbers);
        } else {
            ExecutorServiceFacade executor = (ExecutorServiceFacade)Environment.getPublished(ExecutorServiceFacade.class);
            final ConcurrentHashMap exceptions = new ConcurrentHashMap();
            final CountDownLatch barrier = new CountDownLatch(products.size());
            for (final BaseProduct product : products) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            DebugUtil.setThreadName((String)"product-validation-interceptor: validate-product");
                            try {
                                try {
                                    ProductValidationInterceptor.this.validateProduct(product, context, validateProductNumbers);
                                }
                                catch (Exception t) {
                                    exceptions.put(product, t);
                                }
                            }
                            finally {
                                DebugUtil.restoreThreadName();
                            }
                        }
                        finally {
                            barrier.countDown();
                        }
                    }
                });
            }
            if (!barrier.await(30L, TimeUnit.MINUTES)) {
                throw new TimeoutException("timeout reached while validate products, please try again");
            }
            this.validateBookingFile(products);
            if (!exceptions.isEmpty()) {
                for (final BaseProduct product : products) {
                    Exception e = (Exception)exceptions.get(product);
                    if (e == null) continue;
                    throw e;
                }
            }
        }
    }

    protected void validateBookingFile(List<BaseProduct> products) {
        products.stream().map(p -> GeneralProductHelper.getHandler((BaseProduct)p).getStatisticalData(p)).filter(Objects::nonNull).map(StatisticsHelper::getAllCostCodes).flatMap(Collection::stream).filter(Objects::nonNull).filter(cc -> cc.getCostCodeProperties() != null && cc.getCostCodeProperties().isCommon() && (TextUtil.nonBlank((String)cc.getValue()) || TextUtil.nonBlank((String)cc.getLocalValue()) || TextUtil.nonBlank((String)cc.getEnglishValue()))).collect(Collectors.groupingBy(CostCode::getCostCodeProperties, Collectors.toList())).entrySet().stream().filter(e -> {
            boolean result;
            boolean bl = result = ((List)e.getValue()).size() == 1;
            if (result) {
                return false;
            }
            ArrayList codes = new ArrayList();
            ((List)e.getValue()).forEach(cc -> {
                if (codes.stream().noneMatch(c -> StatisticsHelper.equalsCostCodeValues((CostCode)c, (CostCode)cc, (int)1))) {
                    codes.add(cc);
                }
            });
            return codes.size() != 1;
        }).map(Map.Entry::getKey).forEach(ccp -> products.stream().filter(p -> {
            StatisticalData sd = GeneralProductHelper.getHandler((BaseProduct)p).getStatisticalData(p);
            return sd != null && sd.getTravellerCostCodes().stream().flatMap(tcc -> tcc.getCostCodes().stream()).anyMatch(cc -> MiscUtil.equals((Object)ccp, (Object)cc.getCostCodeProperties()) && (TextUtil.nonBlank((String)cc.getValue()) || TextUtil.nonBlank((String)cc.getLocalValue()) || TextUtil.nonBlank((String)cc.getEnglishValue())));
        }).forEach(p -> GeneralProductHelper.getValidationMessages((BaseProduct)p).add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.DIFFERENT_VALUES_FOR_COMMON_UDID, (Object[])new Object[]{ccp.getName()}))));
    }

    protected void validateProduct(BaseProduct product, ProductValidationContext context, boolean validateProductNumbers) throws Exception {
        boolean hasSameSystemNumbers;
        ProductHandler handler = ProductHandler.of((BaseProduct)product);
        if (validateProductNumbers && !handler.isDuplicate(product) && !handler.isSystemNumberDuplicateAllowed(product) && (hasSameSystemNumbers = handler.hasSameSystemNumbers(product))) {
            List systemNumbers = handler.getProductNumbers(product);
            ProductType productType = handler.getProductType(product);
            throw Xeption.forEndUser((String)Messages.productWithSystemNumberAlreadyExists, (Object[])new Object[]{productType, systemNumbers.stream().collect(Collectors.joining(", "))});
        }
        ProductValidationHandler<?> validationHandler = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).findProductValidationHandler(product.getClass());
        if (validationHandler != null) {
            validationHandler.validate(product, context);
        }
    }
}

