/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.model.interceptors;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PCCIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProductsHelper {
    private static final Logger log = LoggerFactory.getLogger(ProductsHelper.class);

    public static void updateScnAndEticketFlag(BlankTypeHandler product) {
        BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(product.getBlankType());
        if (blankType == null) {
            product.setEticket(false);
            return;
        }
        product.setEticket(blankType.getBlankCategory() == BlankCategory.ETICKET);
        if (blankType.getBlankCategory() == BlankCategory.GENERATED_NUMBER) {
            return;
        }
        product.clearSCN();
        if (blankType.getBlankCategory() == BlankCategory.ETICKET) {
            return;
        }
        for (int n = 0; n <= product.getConjunctionsCount(); ++n) {
            try {
                product.addSCN(FormattedNumberUtil.add((String)product.getSystemNumber(), (long)n));
                continue;
            }
            catch (Throwable e) {
                log.error("unable to generate scn", e);
            }
        }
    }

    public static void updateValidationMessages(ValidationMessagesHandler product) throws Exception {
        if (product.isChecked()) {
            return;
        }
        Iterator<ValidationMessage> it = product.getValidationMessages().iterator();
        while (it.hasNext()) {
            if (it.next().getCategory() != ValidationMessageCategory.OTHER) continue;
            it.remove();
        }
        product.validate(product.getValidationMessages());
    }

    static List<ValidationMessage> getAgencyValidationMessages(AgencyValidationProductProxy provider) throws Exception {
        List data;
        ArrayList<ValidationMessage> result = new ArrayList<ValidationMessage>();
        String pcc = provider.getPCC();
        if (TextUtil.isBlank((String)pcc)) {
            result.add(ProductsHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.PH_PCC_NOT_DEFINED, new Object[0]));
            return result;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PCCIndex.Property.code.name(), (Object)pcc));
        if (provider.getIssueDate() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)PCCIndex.Property.closed.name(), null), SearchCriterion.ge((String)PCCIndex.Property.closed.name(), (Object)provider.getIssueDate())}));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)PCCIndex.Property.opened.name(), null), SearchCriterion.le((String)PCCIndex.Property.opened.name(), (Object)provider.getIssueDate())}));
        }
        if (!(data = EntityStorage.get().search(PCCIndex.class, query).getData()).isEmpty()) {
            if (data.size() == 1) {
                PCCIndex index = (PCCIndex)data.get(0);
                EntityReference<Organization> agency = provider.getAgency();
                if (agency != null && index.getAgency() != null && !MiscUtil.equals((Object)index.getAgency(), agency)) {
                    result.add(ProductsHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.PH_AGENCY_NOT_EQUAL_PCC, agency, pcc));
                }
                if (index.getSource() != null && provider.getSalesPoint() != null && !provider.getSalesPoint().equals((Object)index.getSource())) {
                    result.add(ProductsHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.PH_SALESPOINT_NOT_EQUAL_PCC, provider.getSalesPoint(), pcc));
                }
                if (index.getSubAgency() != null && !index.getSubAgency().equals(provider.getSubagency())) {
                    result.add(ProductsHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.PH_SUBAGENCY_NOT_EQUAL_PCC, provider.getSubagency(), pcc));
                }
            } else {
                result.add(ProductsHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.PH_MORE_THAN_ONE_SALE_POINT_PCC, pcc));
            }
        }
        return result;
    }

    public static void updateFops(List<GeneralProductFop> targetFops, List<GeneralProductFop> sourceFops, EntityReference<Person> issuingAgent) {
        if (!targetFops.isEmpty() || sourceFops.isEmpty()) {
            return;
        }
        for (GeneralProductFop pf : sourceFops) {
            if (!GeneralProductHelper.isServiceFop((GeneralProductFop)pf)) continue;
            try {
                GeneralProductFop fop = (GeneralProductFop)XCloneHelper.clone((XCloneable)pf, (boolean)true);
                fop.setAgent(issuingAgent == null ? ProfileDao.findCurrentAgent(null) : issuingAgent);
                if (fop.getOperationDate() == null) {
                    fop.setOperationDate(new Date());
                }
                targetFops.add(fop);
            }
            catch (Throwable e) {
                log.error("unable to clone a fop", e);
            }
        }
    }

    @Deprecated
    public static void updateFops(List<GeneralProductContractRelationData> relations, EntityReference<Person> issuingAgent) {
        List vendorFops = null;
        List clientFops = null;
        ArrayList<List> subagentFops = new ArrayList<List>();
        for (GeneralProductContractRelationData item : relations) {
            switch (GeneralProductHelper.getContractType((EntityReference)item.getDescription())) {
                case VENDOR: {
                    vendorFops = item.getFops();
                    break;
                }
                case CLIENT: {
                    clientFops = item.getFops();
                    break;
                }
                case SUBAGENCY: {
                    subagentFops.add(item.getFops());
                }
            }
        }
        ProductsHelper.updateFopsInternal(clientFops, vendorFops, issuingAgent);
        for (List sf : subagentFops) {
            ProductsHelper.updateFopsInternal(sf, clientFops, issuingAgent);
        }
    }

    @Deprecated
    private static void updateFopsInternal(List<GeneralProductFop> targetFops, List<GeneralProductFop> sourceFops, EntityReference<Person> issuingAgent) {
        if (!targetFops.isEmpty() || sourceFops.isEmpty()) {
            return;
        }
        for (GeneralProductFop pf : sourceFops) {
            if (!GeneralProductHelper.isServiceFop((GeneralProductFop)pf)) continue;
            try {
                GeneralProductFop fop = (GeneralProductFop)XCloneHelper.clone((XCloneable)pf, (boolean)true);
                fop.setAgent(issuingAgent == null ? ProfileDao.findCurrentAgent(null) : issuingAgent);
                if (fop.getOperationDate() == null) {
                    fop.setOperationDate(new Date());
                }
                targetFops.add(fop);
            }
            catch (Throwable e) {
                LoggerFactory.getLogger(ProductsHelper.class).error("unable to clone a fop", e);
            }
        }
    }

    public static void updateFops(List<GeneralProductContractRelationData> relations, EntityReference<SalesPoint> salesPointRef, Date operationDate, EntityReference<Person> agent) {
        List vendorFops = null;
        List clientFops = null;
        ArrayList<List> subagentFops = new ArrayList<List>();
        for (GeneralProductContractRelationData item : relations) {
            switch (GeneralProductHelper.getContractType((EntityReference)item.getDescription())) {
                case VENDOR: {
                    vendorFops = item.getFops();
                    break;
                }
                case CLIENT: {
                    clientFops = item.getFops();
                    break;
                }
                case SUBAGENCY: {
                    subagentFops.add(item.getFops());
                }
            }
        }
        ProductsHelper.updateFops(clientFops, vendorFops, salesPointRef, operationDate, agent);
        for (List sf : subagentFops) {
            ProductsHelper.updateFops(sf, clientFops, salesPointRef, operationDate, null);
        }
    }

    private static void updateFops(List<GeneralProductFop> targetFops, List<GeneralProductFop> sourceFops, EntityReference<SalesPoint> salesPointRef, Date operationDate, EntityReference<Person> agent) {
        if (!targetFops.isEmpty() || sourceFops.isEmpty()) {
            return;
        }
        for (GeneralProductFop pf : sourceFops) {
            if (!GeneralProductHelper.isServiceFop((GeneralProductFop)pf)) continue;
            try {
                GeneralProductFop fop = (GeneralProductFop)XCloneHelper.clone((XCloneable)pf, (boolean)true);
                fop.setOperationDate(null);
                fop.setAgent(null);
                targetFops.add(fop);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(ProductsHelper.class).error("unable to clone a fop", (Throwable)e);
            }
        }
    }

    @Deprecated
    public static ValidationMessage createValidationMessage(ValidationMessageSeverity type, String key, Throwable error, Object ... params) {
        ValidationMessage result = new ValidationMessage();
        result.setSeverity(type);
        result.setCategory(ValidationMessageCategory.OTHER);
        if (error != null) {
            result.setDetails(TextUtil.getExceptionStackTrace((Throwable)error));
        }
        result.setMessage(L10nResourcesManager.createL10nMessage((String)key, (Object[])params));
        return result;
    }

    private static ValidationMessage createValidationMessage(ValidationMessageType type, Object ... params) {
        return ValidationMessageHelper.createValidationMessage((ValidationMessageType)type, (Object[])params);
    }

    public static void updatePaymentTypes(BaseProduct product) {
        SalesChain salesChain;
        ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
        if (handler != null && (salesChain = handler.getSalesChain(product)) != null) {
            List contractRelations = handler.getUnmodifiableContractRelations(product);
            boolean changed = false;
            for (GeneralProductContractRelationData contractRelation : contractRelations) {
                ContractType contractType;
                PaymentType paymentType;
                EntityReference customer;
                EntityReference supplier = GeneralProductHelper.getContractRelationSupplier((EntityReference)contractRelation.getDescription(), (SalesChain)salesChain);
                EntityReference entityReference = customer = GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription()) == ContractType.CLIENT ? product.getReservation().getBookingFile().getCustomerProfile() : GeneralProductHelper.getContractRelationCustomer((EntityReference)contractRelation.getDescription(), (SalesChain)salesChain);
                if (supplier == null || customer == null || (paymentType = ProfileHelper.getDefaultPaymentType(ProfileHelper.getContracts((EntityReference)((contractType = GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription())) == ContractType.VENDOR ? supplier : null), (EntityReference)supplier, (EntityReference)customer, (ContractType)contractType, (Date)handler.findIssueDate(product), (boolean)false).stream().map(item -> (ContractCustomerInfo)item.getSecond()).collect(Collectors.toList()))) == null) continue;
                for (GeneralProductFop fop : contractRelation.getFops()) {
                    if (fop.getType() != null && fop.getType() == PaymentType.TICKET) continue;
                    fop.setType(paymentType);
                    changed = true;
                }
            }
            if (changed) {
                handler.updateContractRelations(product, contractRelations);
            }
        }
    }

    public static boolean isNewProduct(EntityContainer<BookingFile> oldBookingFile, BaseProduct product) {
        ProductStatus status;
        ProductHandler productHandler;
        if (oldBookingFile != null && (productHandler = HandlersRegistry.get().findProductHandler(product.getClass())) != null && ((status = productHandler.getBaseStatus(product)) == ProductStatus.SELL || status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE)) {
            return ((BookingFile)oldBookingFile.getEntity()).getReservations().stream().flatMap(item -> item.getProducts().stream()).filter(item -> product.getUid().equals(item.getUid()) && productHandler.getStatus(product) == productHandler.getStatus(item) && productHandler.getConjunction(product) == productHandler.getConjunction(item)).findFirst().orElse(null) == null;
        }
        return true;
    }

    public static boolean isSupplierChanged(EntityContainer<BookingFile> oldBookingFile, BaseProduct product) {
        BaseProduct oldProduct;
        if (oldBookingFile != null && (oldProduct = BookingHelper.findProduct(oldBookingFile, (String)product.getUid())) != null) {
            return !MiscUtil.equals((Object)GeneralProductHelper.getSupplier((BaseProduct)oldProduct), (Object)GeneralProductHelper.getSupplier((BaseProduct)product));
        }
        return false;
    }

    private ProductsHelper() {
    }

    public static interface ValidationMessagesHandler {
        public List<ValidationMessage> getValidationMessages();

        public void validate(List<ValidationMessage> var1);

        public boolean isChecked();
    }

    static interface AgencyValidationProductProxy {
        public String getPCC();

        public EntityReference<Organization> getSubagency();

        public EntityReference<SalesPoint> getSalesPoint();

        public EntityReference<Organization> getAgency();

        public Date getIssueDate();
    }

    public static interface CommonValidationProductProxy<E extends BaseEntity, I extends EntityIndex<E>> {
        public DictionaryReference<BlankType> getBlankType();

        public ProductStatus getStatus();

        public EntityReference<Organization> getBlankOwner();

        public boolean checkPreviousProduct();

        public ProductStatus getPreviousProductStatus();

        public Class<I> getIndexClass();

        public String getSystemNumberIndexPropertyName();

        public String getStatusIndexPropertyName();

        public String getTycketTypeIndexPropertyName();

        public String getSystemNumber();

        public Collection<SearchCriterion> getAdditionalSystemNumberCriterions();
    }

    public static interface FOPValidationProductProxy {
        public List<GeneralProductContractRelationData> getRelations();

        public ProductStatus getStatus();
    }

    public static interface BlankTypeHandler {
        public DictionaryReference<BlankType> getBlankType();

        public void setEticket(boolean var1);

        public void clearSCN();

        public void addSCN(String var1);

        public int getConjunctionsCount();

        public String getSystemNumber();
    }
}

